/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.RetryPolicy;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetricsTest
extends CCMTestsSupport {
    private volatile RetryPolicy.RetryDecision retryDecision;
    MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    @Override
    public Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withRetryPolicy(new RetryPolicy(){

            public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
                return MetricsTest.this.retryDecision;
            }

            public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
                return MetricsTest.this.retryDecision;
            }

            public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
                return MetricsTest.this.retryDecision;
            }

            public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
                return MetricsTest.this.retryDecision;
            }

            public void init(Cluster cluster) {
            }

            public void close() {
            }
        });
    }

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test (k int primary key, v int)", "INSERT INTO test (k, v) VALUES (1, 1)");
    }

    @Test(groups={"short"})
    public void retriesTest() {
        this.retryDecision = RetryPolicy.RetryDecision.retry((ConsistencyLevel)ConsistencyLevel.ONE);
        Statement statement = new SimpleStatement("SELECT v FROM test WHERE k = 1").setConsistencyLevel(ConsistencyLevel.TWO);
        this.session().execute(statement);
        Metrics.Errors errors = this.cluster().getMetrics().getErrorMetrics();
        Assert.assertEquals((long)errors.getUnavailables().getCount(), (long)1L);
        Assert.assertEquals((long)errors.getRetries().getCount(), (long)1L);
        Assert.assertEquals((long)errors.getRetriesOnUnavailable().getCount(), (long)1L);
        this.retryDecision = RetryPolicy.RetryDecision.ignore();
        this.session().execute(statement);
        Assert.assertEquals((long)errors.getUnavailables().getCount(), (long)2L);
        Assert.assertEquals((long)errors.getIgnores().getCount(), (long)1L);
        Assert.assertEquals((long)errors.getIgnoresOnUnavailable().getCount(), (long)1L);
    }

    @Test(groups={"short"})
    public void should_enable_metrics_and_jmx_by_default() throws Exception {
        Assertions.assertThat((Object)this.cluster().getMetrics()).isNotNull();
        ObjectName clusterMetricsON = ObjectName.getInstance(this.cluster().getClusterName() + "-metrics:name=connected-to");
        MBeanInfo mBean = this.server.getMBeanInfo(clusterMetricsON);
        Assertions.assertThat((Object)mBean).isNotNull();
        Assertions.assertThat((boolean)this.cluster().getConfiguration().getMetricsOptions().isEnabled()).isTrue();
        Assertions.assertThat((boolean)this.cluster().getConfiguration().getMetricsOptions().isJMXReportingEnabled()).isTrue();
    }

    @Test(groups={"short"}, expectedExceptions={InstanceNotFoundException.class})
    public void metrics_should_be_null_when_metrics_disabled() throws Exception {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withoutMetrics().build());
        try {
            cluster.init();
            Assertions.assertThat((Object)cluster.getMetrics()).isNull();
            Assertions.assertThat((boolean)cluster.getConfiguration().getMetricsOptions().isEnabled()).isFalse();
            ObjectName clusterMetricsON = ObjectName.getInstance(cluster.getClusterName() + "-metrics:name=connected-to");
            this.server.getMBeanInfo(clusterMetricsON);
        }
        finally {
            cluster.close();
        }
    }

    @Test(groups={"short"}, expectedExceptions={InstanceNotFoundException.class})
    public void should_be_no_jmx_mbean_when_jmx_is_disabled() throws Exception {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withoutJMXReporting().build());
        try {
            cluster.init();
            Assertions.assertThat((Object)cluster.getMetrics()).isNotNull();
            Assertions.assertThat((boolean)cluster.getConfiguration().getMetricsOptions().isEnabled()).isTrue();
            Assertions.assertThat((boolean)cluster.getConfiguration().getMetricsOptions().isJMXReportingEnabled()).isFalse();
            ObjectName clusterMetricsON = ObjectName.getInstance(cluster.getClusterName() + "-metrics:name=connected-to");
            this.server.getMBeanInfo(clusterMetricsON);
        }
        finally {
            cluster.close();
        }
    }
}

