/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.collect.Iterators;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
public class LoadBalancingPolicyRefreshTest
extends CCMTestsSupport {
    UpdatablePolicy policy;

    @Test(groups={"short"})
    @CCMConfig(numberOfNodes={2}, clusterProvider="updatablePolicy")
    public void refreshTest() throws Throwable {
        Host[] hosts = new Host[2];
        for (Host h : this.cluster().getMetadata().getAllHosts()) {
            if (h.getAddress().equals(this.ccm().addressOfNode(1).getAddress())) {
                hosts[0] = h;
                continue;
            }
            hosts[1] = h;
        }
        Assert.assertTrue((boolean)this.session().getState().getConnectedHosts().contains(hosts[0]), (String)("Connected hosts: " + this.session().getState().getConnectedHosts()));
        Assert.assertTrue((!this.session().getState().getConnectedHosts().contains(hosts[1]) ? 1 : 0) != 0, (String)("Connected hosts: " + this.session().getState().getConnectedHosts()));
        this.policy.changeTheHost(hosts[1]);
        Assert.assertTrue((!this.session().getState().getConnectedHosts().contains(hosts[0]) ? 1 : 0) != 0, (String)("Connected hosts: " + this.session().getState().getConnectedHosts()));
        Assert.assertTrue((boolean)this.session().getState().getConnectedHosts().contains(hosts[1]), (String)("Connected hosts: " + this.session().getState().getConnectedHosts()));
    }

    private Cluster.Builder updatablePolicy() {
        this.policy = new UpdatablePolicy();
        return Cluster.builder().withLoadBalancingPolicy((LoadBalancingPolicy)this.policy);
    }

    private class UpdatablePolicy
    implements LoadBalancingPolicy {
        private Cluster cluster;
        private Host theHost;

        private UpdatablePolicy() {
        }

        public void changeTheHost(Host theNewHost) {
            this.theHost = theNewHost;
            this.cluster.getConfiguration().getPoolingOptions().refreshConnectedHosts();
        }

        public void init(Cluster cluster, Collection<Host> hosts) {
            this.cluster = cluster;
            try {
                for (Host h : hosts) {
                    if (!h.getAddress().equals(InetAddress.getByName(TestUtils.IP_PREFIX + '1'))) continue;
                    this.theHost = h;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public HostDistance distance(Host host) {
            return host == this.theHost ? HostDistance.LOCAL : HostDistance.IGNORED;
        }

        public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
            return Iterators.singletonIterator((Object)this.theHost);
        }

        public void onAdd(Host h) {
        }

        public void onRemove(Host h) {
        }

        public void onUp(Host h) {
        }

        public void onDown(Host h) {
        }

        public void close() {
        }
    }
}

