/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.GettableByNameData;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.MappingCodec;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GettableDataIntegrationTest
extends CCMTestsSupport {
    boolean is21;
    CodecRegistry registry = new CodecRegistry();
    AtomicInteger keyCounter = new AtomicInteger(0);
    static final ByteBuffer intBuf = ByteBuffer.allocate(4);
    static InetAddress localhost;
    private TypeMapping<?>[] mappings = new TypeMapping[]{new TypeMapping<String>(new IntToStringCodec(), DataType.varchar(), "1"), new TypeMapping<Long>(new IntToLongCodec(), DataType.bigint(), 1L), new TypeMapping<ByteBuffer>(new IntToByteBufferCodec(), DataType.blob(), intBuf), new TypeMapping<Boolean>(new IntToBooleanCodec(), DataType.cboolean(), true), new TypeMapping<BigDecimal>(new IntToBigDecimalCodec(), DataType.decimal(), new BigDecimal(1)), new TypeMapping<Double>(new IntToDoubleCodec(), DataType.cdouble(), 1.0), new TypeMapping<Float>(new IntToFloatCodec(), DataType.cfloat(), Float.valueOf(1.0f)), new TypeMapping<InetAddress>(new IntToInetAddressCodec(), DataType.inet(), localhost), new TypeMapping<Long>(new IntToLongCodec(), DataType.time(), 8675309L), new TypeMapping<Byte>(new IntToByteCodec(), DataType.tinyint(), (byte)-49), new TypeMapping<Short>(new IntToShortCodec(), DataType.smallint(), (short)1003), new TypeMapping<Date>(new IntToDateCodec(), DataType.timestamp(), new Date(124677L)), new TypeMapping<LocalDate>(new IntToLocalDateCodec(), DataType.date(), LocalDate.fromDaysSinceEpoch((int)1523)), new TypeMapping<UUID>(new IntToUUIDCodec(), DataType.uuid(), new UUID(244242L, 0L)), new TypeMapping<BigInteger>(new IntToBigIntegerCodec(), DataType.varint(), BigInteger.valueOf(4566432L))};

    @Override
    public void onTestContextInitialized() {
        this.is21 = this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"2.1.3")) > 0;
        this.execute("CREATE TABLE codec_mapping (k int PRIMARY KEY, v int, l list<int>, m map<int,int>" + (this.is21 ? ", t tuple<int,int>, s set<frozen<list<int>>>)" : ")"));
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withCodecRegistry(this.registry);
    }

    @BeforeClass(groups={"short"})
    public void setUpRegistry() {
        for (TypeMapping<?> mapping : this.mappings) {
            this.registry.register(mapping.codec);
        }
    }

    @Test(groups={"short"})
    public void should_allow_getting_and_setting_by_type_if_codec_registered() {
        String insertStmt = "INSERT INTO codec_mapping (k,v,l,m" + (this.is21 ? ",t,s" : "") + ") values (?,?,?,?" + (this.is21 ? ",?,?)" : ")");
        PreparedStatement insert = this.session().prepare(insertStmt);
        PreparedStatement select = this.session().prepare("SELECT v,l,m" + (this.is21 ? ",t,s" : "") + " from codec_mapping where k=?");
        TupleType tupleType = new TupleType((List)Lists.newArrayList((Object[])new DataType[]{DataType.cint(), DataType.cint()}), this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion(), this.registry);
        for (TypeMapping<?> mapping : this.mappings) {
            ArrayList keys = Lists.newArrayList();
            ImmutableMap map = ImmutableMap.of(mapping.value, mapping.value);
            ArrayList list = Lists.newArrayList((Object[])new Object[]{mapping.value});
            ImmutableSet set = ImmutableSet.of((Object)list);
            TupleValue tupleValue = new TupleValue(tupleType);
            TestUtils.setValue(tupleValue, 0, mapping.outerType, mapping.value);
            TestUtils.setValue(tupleValue, 1, mapping.outerType, mapping.value);
            BoundStatement byName = insert.bind();
            int byNameKey = this.keyCounter.incrementAndGet();
            keys.add(byNameKey);
            byName.setInt("k", byNameKey);
            TestUtils.setValue(byName, "v", mapping.outerType, mapping.value);
            byName.setList("l", (List)list, mapping.javaType);
            byName.setMap("m", (Map)map, mapping.javaType, mapping.javaType);
            if (this.is21) {
                byName.setTupleValue("t", tupleValue);
                byName.setSet("s", (Set)set, TypeTokens.listOf(mapping.javaType));
            }
            this.session().execute((Statement)byName);
            BoundStatement byIndex = insert.bind();
            int byIndexKey = this.keyCounter.incrementAndGet();
            keys.add(byIndexKey);
            byIndex.setInt(0, byIndexKey);
            TestUtils.setValue(byIndex, 1, mapping.outerType, mapping.value);
            byIndex.setList(2, (List)list, mapping.javaType);
            byIndex.setMap(3, (Map)map, mapping.javaType, mapping.javaType);
            if (this.is21) {
                byIndex.setTupleValue(4, tupleValue);
                byIndex.setSet(5, (Set)set, TypeTokens.listOf(mapping.javaType));
            }
            this.session().execute((Statement)byIndex);
            int fullBindKey = this.keyCounter.incrementAndGet();
            keys.add(fullBindKey);
            BoundStatement fullBind = this.is21 ? insert.bind(new Object[]{fullBindKey, mapping.value, list, map, tupleValue, set}) : insert.bind(new Object[]{fullBindKey, mapping.value, list, map});
            this.session().execute((Statement)fullBind);
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                TupleValue returnedTuple;
                int key = (Integer)iterator.next();
                Row row = this.session().execute((Statement)select.bind(new Object[]{key})).one();
                Assertions.assertThat((Object)TestUtils.getValue((GettableByNameData)row, "v", mapping.outerType, this.registry)).isEqualTo(mapping.value);
                Assertions.assertThat((List)row.getList("l", mapping.codec.getJavaType())).isEqualTo((Object)list);
                Assertions.assertThat((Map)row.getMap("m", mapping.codec.getJavaType(), mapping.codec.getJavaType())).isEqualTo((Object)map);
                if (this.is21) {
                    returnedTuple = row.getTupleValue("t");
                    Assertions.assertThat((Object)TestUtils.getValue((GettableByIndexData)returnedTuple, 0, mapping.outerType, this.registry)).isEqualTo(mapping.value);
                    Assertions.assertThat((Object)TestUtils.getValue((GettableByIndexData)returnedTuple, 1, mapping.outerType, this.registry)).isEqualTo(mapping.value);
                    Assertions.assertThat((Iterable)row.getSet("s", TypeTokens.listOf(mapping.javaType))).isEqualTo((Object)set);
                }
                Assertions.assertThat((Object)TestUtils.getValue((GettableByIndexData)row, 0, mapping.outerType, this.registry)).isEqualTo(mapping.value);
                Assertions.assertThat((List)row.getList(1, mapping.codec.getJavaType())).isEqualTo((Object)list);
                Assertions.assertThat((Map)row.getMap(2, mapping.codec.getJavaType(), mapping.codec.getJavaType())).isEqualTo((Object)map);
                if (!this.is21) continue;
                returnedTuple = row.getTupleValue(3);
                Assertions.assertThat((Object)TestUtils.getValue((GettableByIndexData)returnedTuple, 0, mapping.outerType, this.registry)).isEqualTo(mapping.value);
                Assertions.assertThat((Object)TestUtils.getValue((GettableByIndexData)returnedTuple, 1, mapping.outerType, this.registry)).isEqualTo(mapping.value);
                Assertions.assertThat((Iterable)row.getSet(4, TypeTokens.listOf(mapping.javaType))).isEqualTo((Object)set);
            }
        }
    }

    static {
        intBuf.putInt(1);
        intBuf.flip();
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            localhost = null;
        }
    }

    private static class IntToBigIntegerCodec
    extends MappingCodec<BigInteger, Integer> {
        IntToBigIntegerCodec() {
            super(TypeCodec.cint(), BigInteger.class);
        }

        @Override
        protected BigInteger deserialize(Integer value) {
            return BigInteger.valueOf(value.intValue());
        }

        @Override
        protected Integer serialize(BigInteger value) {
            return value.intValue();
        }
    }

    private static class IntToUUIDCodec
    extends MappingCodec<UUID, Integer> {
        IntToUUIDCodec() {
            super(TypeCodec.cint(), UUID.class);
        }

        @Override
        protected UUID deserialize(Integer value) {
            return new UUID(value.intValue(), 0L);
        }

        @Override
        protected Integer serialize(UUID value) {
            return new Long(value.getMostSignificantBits()).intValue();
        }
    }

    private static class IntToLocalDateCodec
    extends MappingCodec<LocalDate, Integer> {
        IntToLocalDateCodec() {
            super(TypeCodec.cint(), LocalDate.class);
        }

        @Override
        protected LocalDate deserialize(Integer value) {
            return LocalDate.fromDaysSinceEpoch((int)value);
        }

        @Override
        protected Integer serialize(LocalDate value) {
            return value.getDaysSinceEpoch();
        }
    }

    private static class IntToDateCodec
    extends MappingCodec<Date, Integer> {
        IntToDateCodec() {
            super(TypeCodec.cint(), Date.class);
        }

        @Override
        protected Date deserialize(Integer value) {
            return new Date(value.intValue());
        }

        @Override
        protected Integer serialize(Date value) {
            return new Long(value.getTime()).intValue();
        }
    }

    private static class IntToShortCodec
    extends MappingCodec<Short, Integer> {
        IntToShortCodec() {
            super(TypeCodec.cint(), Short.class);
        }

        @Override
        protected Short deserialize(Integer value) {
            return value.shortValue();
        }

        @Override
        protected Integer serialize(Short value) {
            return value.intValue();
        }
    }

    private static class IntToByteCodec
    extends MappingCodec<Byte, Integer> {
        IntToByteCodec() {
            super(TypeCodec.cint(), Byte.class);
        }

        @Override
        protected Byte deserialize(Integer value) {
            return value.byteValue();
        }

        @Override
        protected Integer serialize(Byte value) {
            return value.intValue();
        }
    }

    private static class IntToInetAddressCodec
    extends MappingCodec<InetAddress, Integer> {
        IntToInetAddressCodec() {
            super(TypeCodec.cint(), InetAddress.class);
        }

        @Override
        protected InetAddress deserialize(Integer value) {
            byte[] address = ByteBuffer.allocate(4).putInt(value).array();
            try {
                return InetAddress.getByAddress(address);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }

        @Override
        protected Integer serialize(InetAddress value) {
            return ByteBuffer.wrap(value.getAddress()).getInt();
        }
    }

    private static class IntToFloatCodec
    extends MappingCodec<Float, Integer> {
        IntToFloatCodec() {
            super(TypeCodec.cint(), Float.class);
        }

        @Override
        protected Float deserialize(Integer value) {
            return Float.valueOf(value.floatValue());
        }

        @Override
        protected Integer serialize(Float value) {
            return value.intValue();
        }
    }

    private static class IntToDoubleCodec
    extends MappingCodec<Double, Integer> {
        IntToDoubleCodec() {
            super(TypeCodec.cint(), Double.class);
        }

        @Override
        protected Double deserialize(Integer value) {
            return value.doubleValue();
        }

        @Override
        protected Integer serialize(Double value) {
            return value.intValue();
        }
    }

    private static class IntToBigDecimalCodec
    extends MappingCodec<BigDecimal, Integer> {
        IntToBigDecimalCodec() {
            super(TypeCodec.cint(), BigDecimal.class);
        }

        @Override
        protected BigDecimal deserialize(Integer value) {
            return new BigDecimal(value);
        }

        @Override
        protected Integer serialize(BigDecimal value) {
            return value.intValue();
        }
    }

    private static class IntToBooleanCodec
    extends MappingCodec<Boolean, Integer> {
        IntToBooleanCodec() {
            super(TypeCodec.cint(), Boolean.class);
        }

        @Override
        protected Boolean deserialize(Integer value) {
            return value != 0;
        }

        @Override
        protected Integer serialize(Boolean value) {
            return value != false ? 1 : 0;
        }
    }

    private static class IntToByteBufferCodec
    extends MappingCodec<ByteBuffer, Integer> {
        IntToByteBufferCodec() {
            super(TypeCodec.cint(), ByteBuffer.class);
        }

        @Override
        protected ByteBuffer deserialize(Integer value) {
            ByteBuffer buf = ByteBuffer.allocate(4);
            buf.putInt(value);
            buf.flip();
            return buf;
        }

        @Override
        protected Integer serialize(ByteBuffer value) {
            return value.duplicate().getInt();
        }
    }

    private static class IntToStringCodec
    extends MappingCodec<String, Integer> {
        IntToStringCodec() {
            super(TypeCodec.cint(), String.class);
        }

        @Override
        protected String deserialize(Integer value) {
            return value.toString();
        }

        @Override
        protected Integer serialize(String value) {
            return Integer.parseInt(value);
        }
    }

    private static class IntToLongCodec
    extends MappingCodec<Long, Integer> {
        IntToLongCodec() {
            super(TypeCodec.cint(), Long.class);
        }

        @Override
        protected Long deserialize(Integer value) {
            return value.longValue();
        }

        @Override
        protected Integer serialize(Long value) {
            return value.intValue();
        }
    }

    private static class TypeMapping<T> {
        final TypeCodec<T> codec;
        final TypeToken<Object> javaType;
        final DataType outerType;
        final T value;

        TypeMapping(TypeCodec<T> codec, DataType outerType, T value) {
            this.codec = codec;
            this.javaType = codec.getJavaType();
            this.outerType = outerType;
            this.value = value;
        }
    }
}

