/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.utils.UUIDs;
import com.datastax.driver.dse.DseCluster;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.testng.annotations.Test;

public class DseClusterIdTest {
    @Test(groups={"unit"})
    public void should_use_provided_id() {
        UUID uuid = UUIDs.random();
        DseCluster cluster = DseCluster.builder().addContactPoint("127.0.0.1").withClusterId(uuid).build();
        Assertions.assertThat((Comparable)cluster.getId()).isEqualTo((Object)uuid);
    }

    @Test(groups={"unit"})
    public void should_generate_random_id_if_not_provided() {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (int i = 0; i < 100; ++i) {
            DseCluster cluster = DseCluster.builder().addContactPoint("127.0.0.1").build();
            UUID id = cluster.getId();
            Assertions.assertThat((Comparable)id).isNotNull();
            ids.add(id);
        }
        Assertions.assertThat((Iterable)ids).hasSize(100);
    }
}

