/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.DataProviders;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostAssert;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.DelegatingLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.base.Function;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.assertj.core.api.AbstractIntegerAssert;
import org.scassandra.http.client.PrimingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(dirtiesContext={true}, createCluster={false})
public class ControlConnectionTest
extends CCMTestsSupport {
    static final Logger logger = LoggerFactory.getLogger(ControlConnectionTest.class);

    @Test(groups={"short"})
    @CCMConfig(numberOfNodes={2})
    public void should_prevent_simultaneous_reconnection_attempts() throws InterruptedException {
        QueryPlanCountingPolicy loadBalancingPolicy = new QueryPlanCountingPolicy(Policies.defaultLoadBalancingPolicy());
        AtomicInteger reconnectionAttempts = loadBalancingPolicy.counter;
        ConstantReconnectionPolicy reconnectionPolicy = new ConstantReconnectionPolicy(60000L);
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withReconnectionPolicy((ReconnectionPolicy)reconnectionPolicy).withLoadBalancingPolicy((LoadBalancingPolicy)loadBalancingPolicy).build());
        cluster.init();
        this.ccm().stop(1);
        TimeUnit.SECONDS.sleep(1L);
        Assertions.assertThat((int)reconnectionAttempts.get()).isEqualTo(1);
        this.ccm().stop(2);
        TimeUnit.SECONDS.sleep(1L);
        Assertions.assertThat((int)reconnectionAttempts.get()).isEqualTo(2);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_parse_UDT_definitions_when_using_default_protocol_version() {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).build());
        Session session = cluster.connect();
        session.execute("create keyspace ks WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 1}");
        session.execute("create type ks.foo (i int)");
        cluster.close();
        Cluster cluster2 = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).build());
        UserType fooType = cluster2.getMetadata().getKeyspace("ks").getUserType("foo");
        Assertions.assertThat((Iterable)fooType.getFieldNames()).containsExactly((Object[])new String[]{"i"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"long"})
    @CCMConfig(numberOfNodes={3})
    public void should_reestablish_if_control_node_decommissioned() throws InterruptedException {
        InetSocketAddress firstHost = this.ccm().addressOfNode(1);
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{firstHost.getAddress()}).withPort(this.ccm().getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build());
        try {
            cluster.init();
            InetAddress controlHost = cluster.manager.controlConnection.connectedHost().getAddress();
            Assertions.assertThat((Object)controlHost).isEqualTo((Object)firstHost.getAddress());
            this.ccm().decommission(1);
            Host newHost = cluster.manager.controlConnection.connectedHost();
            Assertions.assertThat(newHost).isNotNull();
            Assertions.assertThat((Object)newHost.getAddress()).isNotEqualTo((Object)controlHost);
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    @CCMConfig(createCcm={false})
    public void should_randomize_contact_points_when_determining_control_connection() {
        int hostCount = 5;
        int iterations = 100;
        ScassandraCluster scassandras = ScassandraCluster.builder().withNodes(hostCount).build();
        scassandras.init();
        try {
            ArrayList contactPoints = Lists.newArrayList();
            for (int i = 1; i <= hostCount; ++i) {
                contactPoints.add(scassandras.address(i).getAddress());
            }
            final HashMultiset occurrencesByHost = HashMultiset.create((int)hostCount);
            for (int i = 0; i < iterations; ++i) {
                Cluster cluster = Cluster.builder().addContactPoints((Collection)contactPoints).withPort(scassandras.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
                try {
                    cluster.init();
                    occurrencesByHost.add((Object)cluster.manager.controlConnection.connectedHost().getAddress());
                    continue;
                }
                finally {
                    cluster.close();
                }
            }
            if (logger.isDebugEnabled()) {
                ImmutableMap hostCounts = Maps.toMap((Iterable)occurrencesByHost.elementSet(), (Function)new Function<InetAddress, Integer>(){

                    public Integer apply(InetAddress input) {
                        return occurrencesByHost.count((Object)input);
                    }
                });
                logger.debug("Control Connection Use Counts by Host: {}", (Object)hostCounts);
            }
            ((AbstractIntegerAssert)Assertions.assertThat((int)occurrencesByHost.elementSet().size()).as("Not all hosts were used as contact points.  There is a very small chance of this happening based on randomness, investigate whether or not this is a bug.", new Object[0])).isEqualTo(hostCount);
        }
        finally {
            scassandras.stop();
        }
    }

    @DataProvider
    public static Object[][] disallowedNullColumnsInPeerData() {
        return new Object[][]{{"host_id", false, true}, {"data_center", false, true}, {"rack", false, true}, {"tokens", false, true}, {"host_id,data_center,rack,tokens", false, true}, {"rpc_address", false, false}, {"host_id", true, true}, {"data_center", true, true}, {"rack", true, true}, {"tokens", true, true}, {"host_id,data_center,rack,tokens", true, true}, {"native_address", true, false}, {"native_port", true, false}, {"native_address,native_port", true, false}};
    }

    @Test(groups={"isolated"}, dataProvider="disallowedNullColumnsInPeerData")
    @CCMConfig(createCcm={false})
    public void should_ignore_peer_if_extended_peer_check_is_enabled(String columns, boolean withPeersV2, boolean extendPeerCheckRequired) {
        System.setProperty("com.datastax.driver.EXTENDED_PEER_CHECK", "true");
        ControlConnectionTest.run_with_null_peer_info(columns, false, withPeersV2);
    }

    @Test(groups={"short"}, dataProvider="disallowedNullColumnsInPeerData")
    @CCMConfig(createCcm={false})
    public void should_ignore_and_warn_peers_with_null_entries_by_default(String columns, boolean withPeersV2, boolean extendedPeerCheckRequired) {
        ControlConnectionTest.run_with_null_peer_info(columns, false, withPeersV2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void run_with_null_peer_info(String columns, boolean expectPeer2, boolean withPeersV2) {
        ScassandraCluster.ScassandraClusterBuilder builder = ScassandraCluster.builder().withNodes(3);
        if (withPeersV2) {
            builder.withPeersV2(true);
        }
        StringBuilder columnDataBuilder = new StringBuilder();
        for (String column : columns.split(",")) {
            builder = builder.forcePeerInfo(1, 2, column, null);
            columnDataBuilder.append(String.format("%s=null, ", column));
        }
        String columnData = columnDataBuilder.toString();
        if (columnData.endsWith(", ")) {
            columnData = columnData.substring(0, columnData.length() - 2);
        }
        ScassandraCluster scassandraCluster = builder.build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        org.apache.log4j.Logger cLogger = org.apache.log4j.Logger.getLogger((String)"com.datastax.driver.core");
        Level originalLevel = cLogger.getLevel();
        if (originalLevel != null && !originalLevel.isGreaterOrEqual((Priority)Level.WARN)) {
            cLogger.setLevel(Level.WARN);
        }
        MemoryAppender logs = new MemoryAppender();
        cLogger.addAppender((Appender)logs);
        try {
            scassandraCluster.init();
            cluster.init();
            InetAddress node2Address = scassandraCluster.address(2).getAddress();
            String expectedError = String.format("Found invalid row in system.peers: [peer=%s, %s]. This is likely a gossip or snitch issue, this host will be ignored.", node2Address, columnData);
            String log = logs.get();
            if (expectPeer2) {
                Assertions.assertThat((Iterable)cluster.getMetadata().getAllHosts()).hasSize(3).extractingResultOf("getAddress").contains(new Object[]{node2Address});
                Assertions.assertThat((String)log).doesNotContain((CharSequence)expectedError);
            } else {
                Assertions.assertThat((Iterable)cluster.getMetadata().getAllHosts()).hasSize(2).extractingResultOf("getAddress").doesNotContain(new Object[]{node2Address});
                Assertions.assertThat((String)log).containsOnlyOnce((CharSequence)expectedError);
            }
        }
        finally {
            cLogger.removeAppender((Appender)logs);
            cLogger.setLevel(originalLevel);
            cluster.close();
            scassandraCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    @CCMConfig(createCcm={false})
    public void should_fetch_whole_peers_table_if_broadcast_address_changed() throws UnknownHostException {
        ScassandraCluster scassandras = ScassandraCluster.builder().withNodes(2).build();
        scassandras.init();
        InetSocketAddress node2RpcAddress = scassandras.address(2);
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandras.address(1).getAddress()}).withPort(scassandras.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            cluster.init();
            Host host2 = cluster.getMetadata().getHost(node2RpcAddress);
            Assertions.assertThat(host2).isNotNull();
            InetSocketAddress node2OldBroadcastAddress = host2.getBroadcastSocketAddress();
            InetSocketAddress node2NewBroadcastAddress = new InetSocketAddress(InetAddress.getByName("1.2.3.4"), scassandras.getBinaryPort());
            Assertions.assertThat((Object)host2.getSocketAddress().getAddress()).isEqualTo((Object)node2OldBroadcastAddress.getAddress());
            ImmutableMap rows = ImmutableMap.builder().put((Object)"peer", (Object)node2NewBroadcastAddress.getAddress()).put((Object)"rpc_address", (Object)host2.getAddress()).put((Object)"host_id", (Object)UUID.randomUUID()).put((Object)"data_center", (Object)ScassandraCluster.datacenter(1)).put((Object)"rack", (Object)"rack1").put((Object)"release_version", (Object)"2.1.8").put((Object)"tokens", (Object)ImmutableSet.of((Object)Long.toString(scassandras.getTokensForDC(1).get(1)))).build();
            scassandras.node(1).primingClient().clearAllPrimes();
            scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("SELECT * FROM system.peers WHERE peer='" + node2OldBroadcastAddress.getAddress().getHostAddress() + "'").withThen(PrimingRequest.then().withColumnTypes(ScassandraCluster.SELECT_PEERS).build()).build());
            scassandras.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("SELECT * FROM system.peers").withThen(PrimingRequest.then().withColumnTypes(ScassandraCluster.SELECT_PEERS).withRows(new Map[]{rows}).build()).build());
            Assertions.assertThat((boolean)cluster.manager.controlConnection.refreshNodeInfo(host2)).isTrue();
            host2 = cluster.getMetadata().getHost(node2RpcAddress);
            Assertions.assertThat(host2).isNotNull();
            Assertions.assertThat((Object)host2.getBroadcastSocketAddress().getAddress()).isEqualTo((Object)node2NewBroadcastAddress.getAddress());
            Assertions.assertThat((Object)host2.getSocketAddress()).isEqualTo((Object)node2RpcAddress);
        }
        finally {
            cluster.close();
            scassandras.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProviderClass=DataProviders.class, dataProvider="bool")
    @CCMConfig(createCcm={false})
    public void should_use_port_from_peers_v2_table(boolean sharedIP) {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5).withPeersV2(true).withSharedIP(sharedIP).build();
        Cluster.Builder builder = Cluster.builder().addContactPointsWithPorts(new InetSocketAddress[]{sCluster.address(1)}).withNettyOptions(TestUtils.nonQuietClusterCloseOptions);
        if (!sharedIP) {
            builder.withPort(sCluster.getBinaryPort());
        }
        Cluster cluster = builder.build();
        try {
            sCluster.init();
            cluster.connect();
            Assertions.assertThat((Iterable)cluster.getMetadata().getAllHosts()).hasSize(5);
            HashSet<InetAddress> uniqueAddresses = new HashSet<InetAddress>();
            HashSet<InetSocketAddress> uniqueSocketAddresses = new HashSet<InetSocketAddress>();
            for (int i = 1; i <= 5; ++i) {
                Host host = sCluster.host(cluster, 1, i);
                ((HostAssert)Assertions.assertThat(host).isNotNull()).isUp().hasSocketAddress(sCluster.address(i)).hasBroadcastSocketAddress(sCluster.listenAddress(i));
                if (i == 1) {
                    Assertions.assertThat(host).hasListenSocketAddress(sCluster.listenAddress(i));
                } else {
                    Assertions.assertThat(host).hasNoListenSocketAddress();
                }
                uniqueAddresses.add(host.getAddress());
                uniqueSocketAddresses.add(host.getSocketAddress());
            }
            if (!sharedIP) {
                Assertions.assertThat(uniqueAddresses).hasSize(5);
            } else {
                Assertions.assertThat(uniqueAddresses).hasSize(1);
                Assertions.assertThat(uniqueSocketAddresses).hasSize(5);
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    @Test(groups={"short"})
    @CCMConfig(createCcm={false})
    public void should_connect_when_peers_v2_table_not_present() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5).withPeersV2(false).build();
        Cluster cluster = Cluster.builder().addContactPointsWithPorts(new InetSocketAddress[]{sCluster.address(1)}).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withPort(sCluster.getBinaryPort()).build();
        try {
            sCluster.init();
            cluster.connect();
            Assertions.assertThat((Iterable)cluster.getMetadata().getAllHosts()).hasSize(5);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    static class QueryPlanCountingPolicy
    extends DelegatingLoadBalancingPolicy {
        final AtomicInteger counter = new AtomicInteger();

        public QueryPlanCountingPolicy(LoadBalancingPolicy delegate) {
            super(delegate);
        }

        @Override
        public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
            this.counter.incrementAndGet();
            return super.newQueryPlan(loggedKeyspace, statement);
        }
    }
}

