/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataProviders;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import java.net.InetAddress;
import java.util.List;
import org.scassandra.Scassandra;
import org.scassandra.http.client.BatchExecution;
import org.scassandra.http.client.PreparedStatementExecution;
import org.scassandra.http.client.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConsistencyTest {
    private static final Logger logger = LoggerFactory.getLogger(ConsistencyTest.class);
    private ScassandraCluster sCluster;

    @BeforeClass(groups={"short"})
    public void setUp() {
        this.sCluster = ScassandraCluster.builder().withNodes(1).build();
        this.sCluster.init();
    }

    @AfterClass(groups={"short"})
    public void tearDownClass() {
        this.sCluster.stop();
    }

    @AfterMethod(groups={"short"})
    public void tearDown() {
        this.clearActivityLog();
    }

    public void clearActivityLog() {
        for (Scassandra node : this.sCluster.nodes()) {
            node.activityClient().clearAllRecordedActivity();
        }
    }

    public Cluster.Builder builder() {
        return Cluster.builder().addContactPoints(new InetAddress[]{this.sCluster.address(1).getAddress()}).withPort(this.sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions);
    }

    public void checkSerialCLMatch(ConsistencyLevel expected, String received) {
        if (expected.equals((Object)ConsistencyLevel.SERIAL)) {
            Assert.assertNull((Object)received);
        } else {
            Assert.assertTrue((boolean)received.equals(expected.toString()));
        }
    }

    public PreparedStatementExecution executePrepared(Session session, String statement, ConsistencyLevel level, ConsistencyLevel serialLevel) {
        PreparedStatement ps = session.prepare(statement);
        BoundStatement bound = ps.bind();
        if (level != null) {
            bound.setConsistencyLevel(level);
        }
        if (serialLevel != null) {
            bound.setSerialConsistencyLevel(serialLevel);
        }
        session.execute((Statement)bound);
        List pses = this.sCluster.node(1).activityClient().retrievePreparedStatementExecutions();
        PreparedStatementExecution pse = (PreparedStatementExecution)pses.get(0);
        Assert.assertTrue((boolean)pse.getPreparedStatementText().equals(statement));
        return pse;
    }

    public BatchExecution executeBatch(Session session, String statement, ConsistencyLevel level, ConsistencyLevel serialLevel) {
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement(statement));
        if (level != null) {
            batch.setConsistencyLevel(level);
        }
        if (serialLevel != null) {
            batch.setSerialConsistencyLevel(serialLevel);
        }
        session.execute((Statement)batch);
        List batches = this.sCluster.node(1).activityClient().retrieveBatches();
        Assert.assertEquals((int)batches.size(), (int)1);
        return (BatchExecution)batches.get(0);
    }

    public Query executeSimple(Session session, String statement, ConsistencyLevel level, ConsistencyLevel serialLevel) {
        SimpleStatement simpleStatement = new SimpleStatement(statement);
        if (level != null) {
            simpleStatement.setConsistencyLevel(level);
        }
        if (serialLevel != null) {
            simpleStatement.setSerialConsistencyLevel(serialLevel);
        }
        session.execute((Statement)simpleStatement);
        List queries = this.sCluster.node(1).activityClient().retrieveQueries();
        for (Query query : queries) {
            if (!query.getQuery().equals(statement)) continue;
            return query;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_global_default_cl_when_none_specified() throws Throwable {
        Cluster cluster = this.builder().build();
        try {
            Session session = cluster.connect();
            String queryString = "default_cl";
            Query clQuery = this.executeSimple(session, queryString, null, null);
            Assert.assertTrue((boolean)clQuery.getConsistency().equals(ConsistencyLevel.LOCAL_ONE.toString()));
            String prepareString = "prepared_default_cl";
            PreparedStatementExecution pse = this.executePrepared(session, prepareString, null, null);
            Assert.assertTrue((boolean)pse.getConsistency().equals(ConsistencyLevel.LOCAL_ONE.toString()));
            String batchStateString = "batch_default_cl";
            BatchExecution batch = this.executeBatch(session, batchStateString, null, null);
            Assert.assertTrue((boolean)batch.getConsistency().equals(ConsistencyLevel.LOCAL_ONE.toString()));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="consistencyLevels", dataProviderClass=DataProviders.class)
    public void should_use_query_option_cl(ConsistencyLevel cl) throws Throwable {
        Cluster cluster = this.builder().withQueryOptions(new QueryOptions().setConsistencyLevel(cl)).build();
        try {
            Session session = cluster.connect();
            String queryString = "query_cl";
            Query clQuery = this.executeSimple(session, queryString, null, null);
            Assert.assertTrue((boolean)clQuery.getConsistency().equals(cl.toString()));
            String prepareString = "preapred_query_cl";
            PreparedStatementExecution pse = this.executePrepared(session, prepareString, null, null);
            Assert.assertTrue((boolean)pse.getConsistency().equals(cl.toString()));
            String batchStateString = "batch_query_cl";
            BatchExecution batch = this.executeBatch(session, batchStateString, null, null);
            Assert.assertTrue((boolean)batch.getConsistency().equals(cl.toString()));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="consistencyLevels", dataProviderClass=DataProviders.class)
    public void should_use_statement_cl(ConsistencyLevel cl) throws Throwable {
        Cluster cluster = this.builder().build();
        try {
            Session session = cluster.connect();
            String queryString = "statement_cl";
            Query clQuery = this.executeSimple(session, queryString, cl, null);
            Assert.assertTrue((boolean)clQuery.getConsistency().equals(cl.toString()));
            String prepareString = "preapred_statement_cl";
            PreparedStatementExecution pse = this.executePrepared(session, prepareString, cl, null);
            Assert.assertTrue((boolean)pse.getConsistency().equals(cl.toString()));
            String batchStateString = "batch_statement_cl";
            BatchExecution batch = this.executeBatch(session, batchStateString, cl, null);
            Assert.assertTrue((boolean)batch.getConsistency().equals(cl.toString()));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_use_appropriate_cl_when_multiple_defined() throws Throwable {
        ConsistencyLevel cl_one = ConsistencyLevel.ONE;
        Cluster cluster = this.builder().withQueryOptions(new QueryOptions().setConsistencyLevel(cl_one)).build();
        try {
            Session session = cluster.connect();
            String queryString = "opts_cl";
            Query clQuery = this.executeSimple(session, queryString, null, null);
            Assert.assertTrue((boolean)clQuery.getConsistency().equals(cl_one.toString()));
            ConsistencyLevel cl_all = ConsistencyLevel.ALL;
            queryString = "stm_cl";
            clQuery = this.executeSimple(session, queryString, cl_all, null);
            Assert.assertTrue((boolean)clQuery.getConsistency().equals(cl_all.toString()));
            String prepareString = "prep_opts_cl";
            PreparedStatementExecution pse = this.executePrepared(session, prepareString, null, null);
            Assert.assertTrue((boolean)pse.getConsistency().equals(cl_one.toString()));
            this.clearActivityLog();
            prepareString = "prep_stm_cl";
            pse = this.executePrepared(session, prepareString, cl_all, null);
            Assert.assertTrue((boolean)pse.getConsistency().equals(cl_all.toString()));
            String batchString = "batch_opts_cl";
            BatchExecution batch = this.executeBatch(session, batchString, null, null);
            Assert.assertTrue((boolean)batch.getConsistency().equals(cl_one.toString()));
            this.clearActivityLog();
            batchString = "prep_stm_cl";
            batch = this.executeBatch(session, batchString, cl_all, null);
            Assert.assertTrue((boolean)batch.getConsistency().equals(cl_all.toString()));
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="serialConsistencyLevels", dataProviderClass=DataProviders.class)
    public void should_use_query_option_serial_cl(ConsistencyLevel cl) throws Throwable {
        Cluster cluster = this.builder().withQueryOptions(new QueryOptions().setSerialConsistencyLevel(cl)).build();
        try {
            Session session = cluster.connect();
            String queryString = "serial_query_cl";
            Query clQuery = this.executeSimple(session, queryString, null, cl);
            this.checkSerialCLMatch(cl, clQuery.getSerialConsistency());
            String prepareString = "preapred_statement_serial_cl";
            PreparedStatementExecution pse = this.executePrepared(session, prepareString, null, null);
            this.checkSerialCLMatch(cl, pse.getSerialConsistency());
            String batchStateString = "batch_statement_serial_cl";
            BatchExecution batch = this.executeBatch(session, batchStateString, null, null);
            this.checkSerialCLMatch(cl, batch.getSerialConsistency());
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="serialConsistencyLevels", dataProviderClass=DataProviders.class)
    public void should_use_statement_serial_cl(ConsistencyLevel cl) throws Throwable {
        Cluster cluster = this.builder().build();
        try {
            Session session = cluster.connect();
            String queryString = "statement_serial_cl";
            Query clQuery = this.executeSimple(session, queryString, null, cl);
            this.checkSerialCLMatch(cl, clQuery.getSerialConsistency());
            String prepareString = "preapred_statement_serial_cl";
            PreparedStatementExecution pse = this.executePrepared(session, prepareString, null, cl);
            this.checkSerialCLMatch(cl, pse.getSerialConsistency());
            String batchStateString = "batch_statement_serial_cl";
            BatchExecution batch = this.executeBatch(session, batchStateString, null, cl);
            this.checkSerialCLMatch(cl, batch.getSerialConsistency());
        }
        finally {
            cluster.close();
        }
    }
}

