/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Duration;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.TypeCodecAssert;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.CodecNotFoundException;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mockito.Mockito;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class CodecRegistryTest {
    @DataProvider
    public static Object[][] cql() {
        return new Object[][]{{DataType.blob(), TypeCodec.blob()}, {DataType.cboolean(), TypeCodec.cboolean()}, {DataType.smallint(), TypeCodec.smallInt()}, {DataType.tinyint(), TypeCodec.tinyInt()}, {DataType.cint(), TypeCodec.cint()}, {DataType.bigint(), TypeCodec.bigint()}, {DataType.counter(), TypeCodec.counter()}, {DataType.cdouble(), TypeCodec.cdouble()}, {DataType.cfloat(), TypeCodec.cfloat()}, {DataType.varint(), TypeCodec.varint()}, {DataType.decimal(), TypeCodec.decimal()}, {DataType.varchar(), TypeCodec.varchar()}, {DataType.ascii(), TypeCodec.ascii()}, {DataType.timestamp(), TypeCodec.timestamp()}, {DataType.date(), TypeCodec.date()}, {DataType.time(), TypeCodec.time()}, {DataType.uuid(), TypeCodec.uuid()}, {DataType.timeuuid(), TypeCodec.timeUUID()}, {DataType.inet(), TypeCodec.inet()}, {DataType.duration(), TypeCodec.duration()}};
    }

    @DataProvider
    public static Object[][] cqlAndJava() {
        return new Object[][]{{DataType.blob(), ByteBuffer.class, TypeCodec.blob()}, {DataType.cboolean(), Boolean.class, TypeCodec.cboolean()}, {DataType.smallint(), Short.class, TypeCodec.smallInt()}, {DataType.tinyint(), Byte.class, TypeCodec.tinyInt()}, {DataType.cint(), Integer.class, TypeCodec.cint()}, {DataType.bigint(), Long.class, TypeCodec.bigint()}, {DataType.counter(), Long.class, TypeCodec.counter()}, {DataType.cdouble(), Double.class, TypeCodec.cdouble()}, {DataType.cfloat(), Float.class, TypeCodec.cfloat()}, {DataType.varint(), BigInteger.class, TypeCodec.varint()}, {DataType.decimal(), BigDecimal.class, TypeCodec.decimal()}, {DataType.varchar(), String.class, TypeCodec.varchar()}, {DataType.ascii(), String.class, TypeCodec.ascii()}, {DataType.timestamp(), Date.class, TypeCodec.timestamp()}, {DataType.date(), LocalDate.class, TypeCodec.date()}, {DataType.time(), Long.class, TypeCodec.time()}, {DataType.uuid(), UUID.class, TypeCodec.uuid()}, {DataType.timeuuid(), UUID.class, TypeCodec.timeUUID()}, {DataType.inet(), InetAddress.class, TypeCodec.inet()}, {DataType.duration(), Duration.class, TypeCodec.duration()}};
    }

    @DataProvider
    public static Object[][] value() {
        return new Object[][]{{ByteBuffer.allocate(0), TypeCodec.blob()}, {Boolean.TRUE, TypeCodec.cboolean()}, {(short)42, TypeCodec.smallInt()}, {(byte)42, TypeCodec.tinyInt()}, {42, TypeCodec.cint()}, {42L, TypeCodec.bigint()}, {42.0, TypeCodec.cdouble()}, {Float.valueOf(42.0f), TypeCodec.cfloat()}, {new BigInteger("1234"), TypeCodec.varint()}, {new BigDecimal("123.45"), TypeCodec.decimal()}, {"foo", TypeCodec.varchar()}, {new Date(42L), TypeCodec.timestamp()}, {LocalDate.fromDaysSinceEpoch((int)42), TypeCodec.date()}, {UUID.randomUUID(), TypeCodec.uuid()}, {Mockito.mock(InetAddress.class), TypeCodec.inet()}, {Duration.from((String)"1mo2d3h"), TypeCodec.duration()}};
    }

    @DataProvider
    public static Object[][] cqlAndValue() {
        return new Object[][]{{DataType.blob(), ByteBuffer.allocate(0), TypeCodec.blob()}, {DataType.cboolean(), true, TypeCodec.cboolean()}, {DataType.smallint(), (short)42, TypeCodec.smallInt()}, {DataType.tinyint(), (byte)42, TypeCodec.tinyInt()}, {DataType.cint(), 42, TypeCodec.cint()}, {DataType.bigint(), 42L, TypeCodec.bigint()}, {DataType.counter(), 42L, TypeCodec.counter()}, {DataType.cdouble(), 42.0, TypeCodec.cdouble()}, {DataType.cfloat(), Float.valueOf(42.0f), TypeCodec.cfloat()}, {DataType.varint(), new BigInteger("1234"), TypeCodec.varint()}, {DataType.decimal(), new BigDecimal("123.45"), TypeCodec.decimal()}, {DataType.varchar(), "foo", TypeCodec.varchar()}, {DataType.ascii(), "foo", TypeCodec.ascii()}, {DataType.timestamp(), new Date(42L), TypeCodec.timestamp()}, {DataType.date(), LocalDate.fromDaysSinceEpoch((int)42), TypeCodec.date()}, {DataType.time(), 42L, TypeCodec.time()}, {DataType.uuid(), UUID.randomUUID(), TypeCodec.uuid()}, {DataType.timeuuid(), UUID.randomUUID(), TypeCodec.timeUUID()}, {DataType.inet(), Mockito.mock(InetAddress.class), TypeCodec.inet()}, {DataType.duration(), Duration.from((String)"1mo2d3h"), TypeCodec.duration()}};
    }

    @Test(groups={"unit"}, dataProvider="cql")
    public void should_find_codec_by_cql_type(DataType cqlType, TypeCodec<?> expected) {
        CodecRegistry registry = new CodecRegistry();
        TypeCodec actual = registry.codecFor(cqlType);
        ((TypeCodecAssert)Assertions.assertThat(actual).isNotNull()).accepts(cqlType).isSameAs(expected);
    }

    @Test(groups={"unit"}, dataProvider="cqlAndJava")
    public void should_find_codec_by_cql_type_java_type(DataType cqlType, Class<?> javaType, TypeCodec<?> expected) {
        CodecRegistry registry = new CodecRegistry();
        TypeCodec actual = registry.codecFor(cqlType, javaType);
        ((TypeCodecAssert)Assertions.assertThat(actual).isNotNull()).accepts(cqlType).accepts(javaType).isSameAs(expected);
    }

    @Test(groups={"unit"}, dataProvider="value")
    public void should_find_codec_by_value(Object value, TypeCodec<?> expected) {
        CodecRegistry registry = new CodecRegistry();
        TypeCodec actual = registry.codecFor(value);
        ((TypeCodecAssert)Assertions.assertThat(actual).isNotNull()).accepts(value).isSameAs(expected);
    }

    @Test(groups={"unit"}, dataProvider="cqlAndValue")
    public void should_find_codec_by_cql_type_and_value(DataType cqlType, Object value, TypeCodec<?> expected) {
        CodecRegistry registry = new CodecRegistry();
        TypeCodec actual = registry.codecFor(cqlType, value);
        ((TypeCodecAssert)Assertions.assertThat(actual).isNotNull()).accepts(cqlType).accepts(value).isSameAs(expected);
    }

    @Test(groups={"unit"})
    public void should_find_newly_registered_codec_by_cql_type() {
        CodecRegistry registry = new CodecRegistry();
        TypeCodec expected = this.mockCodec((DataType)DataType.list((DataType)DataType.text()), TypeTokens.listOf(String.class));
        registry.register(expected);
        TypeCodec actual = registry.codecFor((DataType)DataType.list((DataType)DataType.text()));
        ((TypeCodecAssert)Assertions.assertThat(actual).isNotNull()).isSameAs(expected);
    }

    @Test(groups={"unit"})
    public void should_find_default_codec_if_cql_type_already_registered() {
        CodecRegistry registry = new CodecRegistry();
        TypeCodec newCodec = this.mockCodec(DataType.text(), TypeToken.of(StringBuilder.class));
        registry.register(newCodec);
        TypeCodec actual = registry.codecFor(DataType.text());
        ((TypeCodecAssert)((TypeCodecAssert)Assertions.assertThat(actual).isNotNull()).isNotSameAs(newCodec)).accepts(DataType.text()).accepts(String.class).doesNotAccept(StringBuilder.class);
    }

    @Test(groups={"unit"})
    public void should_find_newly_registered_codec_by_cql_type_and_java_type() {
        CodecRegistry registry = new CodecRegistry();
        TypeCodec expected = this.mockCodec((DataType)DataType.list((DataType)DataType.text()), TypeTokens.listOf(String.class));
        registry.register(expected);
        TypeCodec actual = registry.codecFor((DataType)DataType.list((DataType)DataType.text()), TypeTokens.listOf(String.class));
        ((TypeCodecAssert)Assertions.assertThat(actual).isNotNull()).isSameAs(expected);
    }

    @Test(groups={"unit"})
    public void should_create_list_codec() {
        DataType.CollectionType cqlType = DataType.list((DataType)DataType.cint());
        TypeToken javaType = TypeTokens.listOf(Integer.class);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType)).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, javaType)).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor(Collections.singletonList(42))).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, Collections.singletonList(42))).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor(new ArrayList())).isNotNull()).accepts((DataType)DataType.list((DataType)DataType.blob())).accepts(TypeTokens.listOf(ByteBuffer.class));
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, new ArrayList())).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
    }

    @Test(groups={"unit"})
    public void should_create_set_codec() {
        DataType.CollectionType cqlType = DataType.set((DataType)DataType.cint());
        TypeToken javaType = TypeTokens.setOf(Integer.class);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType)).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, javaType)).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor(Collections.singleton(42))).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, Collections.singleton(42))).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor(new HashSet())).isNotNull()).accepts((DataType)DataType.set((DataType)DataType.blob())).accepts(TypeTokens.setOf(ByteBuffer.class));
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, new HashSet())).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
    }

    @Test(groups={"unit"})
    public void should_create_map_codec() {
        DataType.CollectionType cqlType = DataType.map((DataType)DataType.cint(), (DataType)DataType.list((DataType)DataType.varchar()));
        TypeToken javaType = TypeTokens.mapOf((TypeToken)TypeToken.of(Integer.class), (TypeToken)TypeTokens.listOf(String.class));
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType)).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, javaType)).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor(Collections.singletonMap(42, Collections.singletonList("foo")))).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, Collections.singletonMap(42, Collections.singletonList("foo")))).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor(new HashMap())).isNotNull()).accepts((DataType)DataType.map((DataType)DataType.blob(), (DataType)DataType.blob())).accepts(TypeTokens.mapOf(ByteBuffer.class, ByteBuffer.class));
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)cqlType, new HashMap())).isNotNull()).accepts((DataType)cqlType).accepts(javaType);
    }

    @Test(groups={"unit"})
    public void should_create_tuple_codec() {
        CodecRegistry registry = new CodecRegistry();
        TupleType tupleType = TupleType.of((ProtocolVersion)ProtocolVersion.V4, (CodecRegistry)registry, (DataType[])new DataType[]{DataType.cint(), DataType.varchar()});
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((DataType)tupleType)).isNotNull()).accepts((DataType)tupleType).accepts(TupleValue.class);
        registry = new CodecRegistry();
        tupleType = TupleType.of((ProtocolVersion)ProtocolVersion.V4, (CodecRegistry)registry, (DataType[])new DataType[]{DataType.cint(), DataType.varchar()});
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((DataType)tupleType, TupleValue.class)).isNotNull()).accepts((DataType)tupleType).accepts(TupleValue.class);
        registry = new CodecRegistry();
        tupleType = TupleType.of((ProtocolVersion)ProtocolVersion.V4, (CodecRegistry)registry, (DataType[])new DataType[]{DataType.cint(), DataType.varchar()});
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((Object)new TupleValue(tupleType))).isNotNull()).accepts((DataType)tupleType).accepts(TupleValue.class);
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((DataType)tupleType, (Object)new TupleValue(tupleType))).isNotNull()).accepts((DataType)tupleType).accepts(TupleValue.class);
    }

    @Test(groups={"unit"})
    public void should_create_udt_codec() {
        CodecRegistry registry = new CodecRegistry();
        UserType udt = new UserType("ks", "test", false, Collections.emptyList(), ProtocolVersion.V4, registry);
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((DataType)udt)).isNotNull()).accepts((DataType)udt).accepts(UDTValue.class);
        registry = new CodecRegistry();
        udt = new UserType("ks", "test", false, Collections.emptyList(), ProtocolVersion.V4, registry);
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((DataType)udt, UDTValue.class)).isNotNull()).accepts((DataType)udt).accepts(UDTValue.class);
        registry = new CodecRegistry();
        udt = new UserType("ks", "test", false, Collections.emptyList(), ProtocolVersion.V4, registry);
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((Object)new UDTValue(udt))).isNotNull()).accepts((DataType)udt).accepts(UDTValue.class);
        registry = new CodecRegistry();
        udt = new UserType("ks", "test", false, Collections.emptyList(), ProtocolVersion.V4, registry);
        ((TypeCodecAssert)Assertions.assertThat(registry.codecFor((DataType)udt, (Object)new UDTValue(udt))).isNotNull()).accepts((DataType)udt).accepts(UDTValue.class);
    }

    @Test(groups={"unit"})
    public void should_create_codec_for_custom_cql_type() {
        DataType.CustomType custom = DataType.custom((String)"foo");
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)custom)).isNotNull()).accepts((DataType)custom).accepts(ByteBuffer.class);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)custom, ByteBuffer.class)).isNotNull()).accepts((DataType)custom).accepts(ByteBuffer.class);
        ((TypeCodecAssert)Assertions.assertThat(new CodecRegistry().codecFor((DataType)custom, (Object)ByteBuffer.allocate(0))).isNotNull()).accepts((DataType)custom).accepts(ByteBuffer.class);
    }

    @Test(groups={"unit"})
    public void should_create_derived_codecs_for_java_type_handled_by_custom_codec() {
        TypeCodec newCodec = this.mockCodec(DataType.varchar(), TypeToken.of(StringBuilder.class));
        CodecRegistry registry = new CodecRegistry().register(newCodec);
        Assertions.assertThat(registry.codecFor((DataType)DataType.list((DataType)DataType.varchar()))).doesNotAccept(TypeTokens.listOf(StringBuilder.class));
        Assertions.assertThat(registry.codecFor((DataType)DataType.list((DataType)DataType.varchar()), TypeTokens.listOf(StringBuilder.class))).isNotNull();
    }

    @Test(groups={"unit"})
    public void should_not_find_codec_if_java_type_unknown() {
        try {
            new CodecRegistry().codecFor(StringBuilder.class);
            Assert.fail((String)"Should not have found a codec for ANY <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            new CodecRegistry().codecFor(DataType.varchar(), StringBuilder.class);
            Assert.fail((String)"Should not have found a codec for varchar <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            new CodecRegistry().codecFor((Object)new StringBuilder());
            Assert.fail((String)"Should not have found a codec for ANY <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
        try {
            new CodecRegistry().codecFor(DataType.varchar(), (Object)new StringBuilder());
            Assert.fail((String)"Should not have found a codec for varchar <-> StringBuilder");
        }
        catch (CodecNotFoundException codecNotFoundException) {
            // empty catch block
        }
    }

    @Test(groups={"unit"})
    public void should_ignore_codec_colliding_with_already_registered_codec() {
        MemoryAppender logs = this.startCapturingLogs();
        CodecRegistry registry = new CodecRegistry();
        TypeCodec newCodec = this.mockCodec(DataType.cint(), TypeToken.of(Integer.class));
        registry.register(newCodec);
        Assertions.assertThat((String)logs.getNext()).contains(new CharSequence[]{"Ignoring codec MockCodec"});
        Assertions.assertThat(registry.codecFor(DataType.cint(), Integer.class)).isNotSameAs(newCodec);
        this.stopCapturingLogs(logs);
    }

    @Test(groups={"unit"})
    public void should_ignore_codec_colliding_with_already_generated_codec() {
        MemoryAppender logs = this.startCapturingLogs();
        CodecRegistry registry = new CodecRegistry();
        registry.codecFor((DataType)DataType.list((DataType)DataType.cint()), TypeTokens.listOf(Integer.class));
        TypeCodec newCodec = this.mockCodec((DataType)DataType.list((DataType)DataType.cint()), TypeTokens.listOf(Integer.class));
        registry.register(newCodec);
        Assertions.assertThat((String)logs.getNext()).contains(new CharSequence[]{"Ignoring codec MockCodec"});
        Assertions.assertThat(registry.codecFor((DataType)DataType.list((DataType)DataType.cint()), TypeTokens.listOf(Integer.class))).isNotSameAs(newCodec);
        this.stopCapturingLogs(logs);
    }

    private MemoryAppender startCapturingLogs() {
        Logger registryLogger = Logger.getLogger(CodecRegistry.class);
        registryLogger.setLevel(Level.WARN);
        MemoryAppender logs = new MemoryAppender();
        registryLogger.addAppender((Appender)logs);
        return logs;
    }

    private void stopCapturingLogs(MemoryAppender logs) {
        Logger registryLogger = Logger.getLogger(CodecRegistry.class);
        registryLogger.setLevel(null);
        registryLogger.removeAppender((Appender)logs);
    }

    private <T> TypeCodec<T> mockCodec(DataType cqlType, TypeToken<T> javaType) {
        TypeCodec newCodec = (TypeCodec)Mockito.mock(TypeCodec.class);
        Mockito.when((Object)newCodec.getCqlType()).thenReturn((Object)cqlType);
        Mockito.when((Object)newCodec.getJavaType()).thenReturn(javaType);
        Mockito.when((Object)newCodec.accepts(cqlType)).thenReturn((Object)true);
        Mockito.when((Object)newCodec.accepts(javaType)).thenReturn((Object)true);
        Mockito.when((Object)newCodec.toString()).thenReturn((Object)String.format("MockCodec [%s <-> %s]", cqlType, javaType));
        return newCodec;
    }
}

