/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ClusterWidePercentileTracker;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PercentileTrackerTest;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class ClusterWidePercentileTrackerTest
extends PercentileTrackerTest<ClusterWidePercentileTracker.Builder, ClusterWidePercentileTracker> {
    @Test(groups={"unit"})
    public void should_track_all_measurements_for_cluster() {
        int i;
        Cluster cluster0 = (Cluster)Mockito.mock(Cluster.class);
        ClusterWidePercentileTracker tracker = ((ClusterWidePercentileTracker.Builder)((ClusterWidePercentileTracker.Builder)this.builder().withInterval(1L, TimeUnit.SECONDS)).withMinRecordedValues(100)).build();
        tracker.onRegister(cluster0);
        ArrayList hosts = Lists.newArrayList((Object[])new Host[]{(Host)Mockito.mock(Host.class), (Host)Mockito.mock(Host.class), (Host)Mockito.mock(Host.class)});
        ArrayList statements = Lists.newArrayList((Object[])new Statement[]{(Statement)Mockito.mock(Statement.class), (Statement)Mockito.mock(Statement.class)});
        ArrayList exceptions = Lists.newArrayList((Object[])new Exception[]{new Exception(), null, new ReadTimeoutException(ConsistencyLevel.ANY, 1, 1, true), null, null});
        for (i = 0; i < 100; ++i) {
            tracker.update((Host)hosts.get(i % hosts.size()), (Statement)statements.get(i % statements.size()), (Exception)exceptions.get(i % exceptions.size()), TimeUnit.NANOSECONDS.convert(i + 1, TimeUnit.MILLISECONDS));
        }
        Uninterruptibles.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        for (i = 1; i <= 99; ++i) {
            long latencyAtPct = tracker.getLatencyAtPercentile(null, null, null, (double)i);
            Assertions.assertThat((long)latencyAtPct).isEqualTo((long)i);
        }
    }

    @Override
    public ClusterWidePercentileTracker.Builder builder() {
        return ClusterWidePercentileTracker.builder((long)this.defaultMaxLatency);
    }
}

