/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import java.net.InetSocketAddress;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@Test
@CCMConfig(numberOfNodes={3})
public class CCMBridgeTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_make_JMX_connection() throws Exception {
        InetSocketAddress addr1 = this.ccm().jmxAddressOfNode(1);
        InetSocketAddress addr2 = this.ccm().jmxAddressOfNode(2);
        InetSocketAddress addr3 = this.ccm().jmxAddressOfNode(3);
        Assertions.assertThat((int)addr1.getPort()).isNotEqualTo(addr2.getPort());
        Assertions.assertThat((int)addr1.getPort()).isNotEqualTo(addr3.getPort());
        Assertions.assertThat((int)addr2.getPort()).isNotEqualTo(addr3.getPort());
        JMXServiceURL url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%d/jmxrmi", addr2.getAddress().getHostAddress(), addr2.getPort()));
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        Assertions.assertThat((boolean)jmxc.getConnectionId().isEmpty()).isFalse();
    }

    @Test(groups={"short"})
    public void should_configure_JMX_ports_through_builder() throws Exception {
        CCMBridge.Builder ccmBuilder = CCMBridge.builder().withNodes(3).notStarted().withJmxPorts(12345);
        CCMBridge ccm = ccmBuilder.build();
        Assertions.assertThat((int)ccm.jmxAddressOfNode(1).getPort()).isEqualTo(12345);
        int port2 = ccm.jmxAddressOfNode(2).getPort();
        int port3 = ccm.jmxAddressOfNode(3).getPort();
        Assertions.assertThat((int)port2).isBetween(Integer.valueOf(0), Integer.valueOf(65535));
        Assertions.assertThat((int)port3).isBetween(Integer.valueOf(0), Integer.valueOf(65535));
    }
}

