/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.MemoryAppender;

import java.util.Map;

import static org.assertj.core.api.Assertions.assertThat;

public class GraphSONOptionsTestUtils {

    public static void assertGraphSON1Result(GraphNode graphNode) {
        // ensure that a graphson1 response is received and that the correct GraphNode implementation is used
        assertThat(graphNode.getClass()).isEqualTo(DefaultGraphNode.class);
        // ensure results are being correctly deserialized
        assertThat(graphNode.asVertex().getProperty("name").getValue().asString()).isEqualTo("marko");
        // ensure automatic type conversion is not effective because of graphson1
        assertThat(graphNode.as(Object.class)).isInstanceOf(Map.class);
    }

    public static void assertGraphSON2Result(GraphNode graphNode) {
        // ensure that a graphson2 response is received and that the correct GraphNode implementation is used
        assertThat(graphNode.getClass()).isEqualTo(ObjectGraphNode.class);
        // ensure results are being correctly deserialized
        assertThat(graphNode.asVertex().getProperty("name").getValue().asString()).isEqualTo("marko");
        // ensure automatic type conversion thanks to graphson2 is effective
        assertThat(graphNode.as(Object.class)).isInstanceOf(Vertex.class);
    }

    public static void assertLogContainsGraphSON1Warning(MemoryAppender logs) {
        assertThat(logs.getNext()).contains("GraphSON1 is being used for a graph query");
    }

    public static void assertLogDoesNotContainGraphSON1Warning(MemoryAppender logs) {
        assertThat(logs.getNext()).isEmpty();
    }


}
