/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

import static org.assertj.core.api.Assertions.assertThat;

import org.testng.annotations.Test;

public class NativeTest {

    /**
     * Verifies that {@link Native#processId()} returns a non-zero process id.
     *
     * @jira_ticket JAVA-1797
     */
    @Test(groups = "unit")
    public void should_return_non_zero_pid() {
        assertThat(Native.processId()).isNotZero();
    }
}
