/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.OperationTimedOutException;
import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.EdgeAssert;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphExtractors;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphProtocol;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.PathAssert;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexAssert;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.driver.dse.graph.VertexPropertyAssert;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractListAssert;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
@CCMConfig(numberOfNodes={2})
public abstract class GraphIntegrationTest
extends CCMGraphTestsSupport {
    private final GraphProtocol graphProtocol;
    private final boolean isGraphSON1;

    @Factory(dataProvider="graphProtocolProvider")
    public GraphIntegrationTest(GraphProtocol graphProtocol) {
        this.graphProtocol = graphProtocol;
        this.isGraphSON1 = graphProtocol == GraphProtocol.GRAPHSON_1_0;
    }

    @Override
    public void onTestContextInitialized() {
        super.onTestContextInitialized();
        this.cluster().getConfiguration().getGraphOptions().setGraphSubProtocol(this.graphProtocol);
        this.executeGraph(GraphFixtures.modern);
    }

    @Test(groups={"short"})
    public void should_use_vertex_id_as_parameter() {
        GraphResultSet resultSet = this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.V().hasLabel('person').has('name', name)").set("name", (Object)"marko"));
        List results = resultSet.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        Vertex marko = ((GraphNode)results.get(0)).asVertex();
        GraphAssertions.assertThat(marko).hasProperty("name", "marko");
        resultSet = this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.V(myV)").set("myV", (Object)marko.getId()));
        results = resultSet.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        Vertex marko2 = ((GraphNode)results.get(0)).asVertex();
        GraphAssertions.assertThat(marko2).isEqualTo(marko);
    }

    @Test(groups={"short"})
    public void should_deserialize_vertex_id_as_map() {
        GraphResultSet resultSet = this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.V().hasLabel('person').has('name', name)").set("name", (Object)"marko"));
        List results = resultSet.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        Vertex marko = ((GraphNode)results.get(0)).asVertex();
        GraphAssertions.assertThat(marko).hasProperty("name", "marko");
        Map deserializedId = (Map)marko.getId().as((TypeToken)new TypeToken<Map<String, Object>>(){});
        GraphAssertions.assertThat(deserializedId.keySet()).containsExactly(Iterators.toArray((Iterator)marko.getId().fieldNames(), String.class));
        Iterator keys = marko.getId().fieldNames();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object value = deserializedId.get(key);
            GraphAssertions.assertThat(value).isEqualTo(marko.getId().get(key).as(value.getClass()));
        }
    }

    @Test(groups={"short"})
    public void should_use_edge_id_as_parameter() {
        GraphResultSet resultSet = this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.E().has('weight', weight)").set("weight", (Object)Float.valueOf(0.2f)));
        List results = resultSet.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        Edge created = ((GraphNode)results.get(0)).asEdge();
        ((EdgeAssert)((Object)GraphAssertions.assertThat(created).hasProperty("weight", Float.valueOf(0.2f)))).hasInVLabel("software").hasOutVLabel("person");
        resultSet = this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.E(myE).inV()").set("myE", (Object)created.getId()));
        results = resultSet.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        Vertex lop = ((GraphNode)results.get(0)).asVertex();
        ((VertexAssert)((Object)GraphAssertions.assertThat(lop).hasLabel("software"))).hasProperty("name", "lop").hasProperty("lang", "java");
    }

    @Test(groups={"short"})
    public void should_use_list_as_a_parameter() {
        SimpleGraphStatement schemaStmt = new SimpleGraphStatement("schema.vertexLabel('character').properties('name').create();");
        this.session().executeGraph((GraphStatement)schemaStmt);
        ArrayList characters = Lists.newArrayList((Object[])new String[]{"Mario", "Luigi", "Toad", "Bowser", "Peach", "Wario", "Waluigi"});
        SimpleGraphStatement createCharacters = new SimpleGraphStatement("characters.each { character -> \n    graph.addVertex(label, 'character', 'name', character);\n}").set("characters", (Object)characters);
        this.session().executeGraph((GraphStatement)createCharacters);
        GraphResultSet resultSet = this.session().executeGraph("g.V().hasLabel('character').values('name')");
        GraphAssertions.assertThat((Iterable)Iterables.transform((Iterable)resultSet.all(), (Function)new Function<GraphNode, String>(){

            public String apply(GraphNode input) {
                return input.asString();
            }
        })).containsOnlyElementsOf((Iterable)characters);
    }

    @Test(groups={"short"})
    public void should_use_map_as_a_parameter() {
        SimpleGraphStatement schemaStmt = new SimpleGraphStatement("schema.propertyKey('year_born').Int().create()\nschema.propertyKey('field').Text().create()\nschema.vertexLabel('scientist').properties('name', 'year_born', 'field').create()\nschema.vertexLabel('country').properties('name').create()\nschema.edgeLabel('had_citizenship').connection('scientist', 'country').create()");
        this.session().executeGraph((GraphStatement)schemaStmt);
        String name = "Albert Einstein";
        int year = 1879;
        String field = "Physics";
        ArrayList citizenship = Lists.newArrayList((Object[])new String[]{"Kingdom of W\u00fcrttemberg", "Switzerland", "Austria", "Germany", "United States"});
        ImmutableMap einsteinProps = ImmutableMap.builder().put((Object)"name", (Object)name).put((Object)"year_born", (Object)year).put((Object)"citizenship", (Object)citizenship).put((Object)"field", (Object)field).build();
        SimpleGraphStatement addV = new SimpleGraphStatement("Vertex scientist = graph.addVertex(label, 'scientist', 'name', m.name, 'year_born', m.year_born, 'field', m.field)\nm.citizenship.each { c -> \n    Vertex country = graph.addVertex(label, 'country', 'name', c);\n    scientist.addEdge('had_citizenship', country);\n}").set("m", (Object)einsteinProps);
        this.session().executeGraph((GraphStatement)addV);
        GraphNode result = this.session().executeGraph("g.V().hasLabel('scientist').has('name', name)", (Map)ImmutableMap.of((Object)"name", (Object)name)).one();
        ((VertexAssert)((Object)GraphAssertions.assertThat(result).asVertex().hasLabel("scientist"))).hasProperty("name", name).hasProperty("year_born", year).hasProperty("field", field);
        GraphResultSet resultSet = this.session().executeGraph("g.V(vId).outE('had_citizenship').inV().values('name')", (Map)ImmutableMap.of((Object)"vId", (Object)result.asVertex().getId()));
        List results = resultSet.all();
        GraphAssertions.assertThat((Iterable)Iterables.transform((Iterable)results, (Function)new Function<GraphNode, String>(){

            public String apply(GraphNode input) {
                return input.asString();
            }
        })).containsOnlyElementsOf((Iterable)citizenship);
    }

    @Test(groups={"short"})
    public void should_handle_result_object_of_mixed_types() {
        GraphResultSet rs = this.session().executeGraph("g.V().hasLabel('software').as('a', 'b', 'c').select('a','b','c').by('name').by('lang').by(__.in('created').fold())");
        List results = rs.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(2);
        GraphAssertions.assertThat((List)results).extracting(GraphExtractors.fieldAs("a", String.class)).containsOnly((Object[])new String[]{"lop", "ripple"});
        for (GraphNode result : results) {
            GraphAssertions.assertThat((boolean)result.isObject()).isTrue();
            GraphAssertions.assertThat((Iterator)result.fieldNames()).containsOnlyOnce((Object[])new String[]{"a", "b", "c"});
            GraphAssertions.assertThat(result.get("e")).isNull();
            GraphAssertions.assertThat((boolean)result.get("b").isNull()).isFalse();
            GraphAssertions.assertThat((String)result.get("b").asString()).isEqualTo((Object)"java");
            GraphNode c = result.get("c");
            GraphAssertions.assertThat((boolean)c.isArray()).isTrue();
            if (result.get("a").asString().equals("lop")) {
                GraphAssertions.assertThat((int)c.size()).isEqualTo(3);
                ArrayList vertices = Lists.newArrayList((Object[])new Vertex[]{c.get(0).asVertex(), c.get(1).asVertex(), c.get(2).asVertex()});
                GraphAssertions.assertThat((List)vertices).extracting(GraphExtractors.vertexPropertyValueAs("name", String.class)).containsOnly((Object[])new String[]{"marko", "josh", "peter"});
                continue;
            }
            GraphAssertions.assertThat((int)c.size()).isEqualTo(1);
            Vertex vertex = c.get(0).asVertex();
            GraphAssertions.assertThat(vertex).hasProperty("name", "josh");
        }
    }

    @Test(groups={"short"})
    public void should_handle_subgraph() {
        GraphResultSet rs = this.session().executeGraph("g.E().hasLabel('knows').subgraph('subGraph').cap('subGraph')");
        List results = rs.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        GraphNode result = (GraphNode)results.get(0);
        GraphAssertions.assertThat(result).hasChild("edges").hasChild("vertices");
        GraphNode edges = result.get("edges");
        GraphAssertions.assertThat((int)edges.size()).isEqualTo(2);
        for (int i = 0; i < edges.size(); ++i) {
            GraphNode edge = edges.get(i);
            GraphAssertions.assertThat(edge).asEdge();
        }
        GraphNode vertices = result.get("vertices");
        GraphAssertions.assertThat((int)vertices.size()).isEqualTo(3);
        for (int i = 0; i < vertices.size(); ++i) {
            GraphNode vertex = vertices.get(i);
            GraphAssertions.assertThat(vertex).asVertex();
        }
    }

    @Test(groups={"short"})
    public void should_return_zero_results() {
        GraphResultSet rs = this.session().executeGraph("g.V().hasLabel('notALabel')");
        GraphAssertions.assertThat((int)rs.all().size()).isZero();
    }

    @Test(groups={"short"})
    public void should_parse_meta_properties() {
        this.executeGraph(GraphFixtures.metaProps);
        Vertex v0 = this.session().executeGraph("g.addV('meta_v').property('meta_prop', 'hello')").one().asVertex();
        ImmutableMap vIdParam = ImmutableMap.of((Object)"vId", (Object)v0.getId());
        this.session().executeGraph("g.V(vId).next().property('meta_prop').property('sub_prop', 'hi')", (Map)vIdParam);
        this.session().executeGraph("g.V(vId).next().property('meta_prop').property('sub_prop2', 'hi2')", (Map)vIdParam);
        Vertex v1 = this.session().executeGraph("g.V(vId)", (Map)vIdParam).one().asVertex();
        GraphAssertions.assertThat(v1).hasProperty("meta_prop");
        VertexProperty metaProp = v1.getProperty("meta_prop");
        ((VertexPropertyAssert)((Object)GraphAssertions.assertThat(metaProp).hasValue("hello").hasProperty("sub_prop", "hi"))).hasProperty("sub_prop2", "hi2");
    }

    @Test(groups={"short"})
    public void should_parse_multiple_cardinality_properties() {
        this.executeGraph(GraphFixtures.multiProps);
        Vertex v = this.session().executeGraph("g.addV('multi_v').property('multi_prop', 'Hello').property('multi_prop', 'Sweet').property('multi_prop', 'World')").one().asVertex();
        GraphAssertions.assertThat(v).hasProperty("multi_prop");
        ArrayList props = Lists.newArrayList((Iterator)v.getProperties("multi_prop"));
        ((AbstractListAssert)GraphAssertions.assertThat((List)props).hasSize(3)).extracting(GraphExtractors.vertexPropertyValueAs(String.class)).containsOnly((Object[])new String[]{"Hello", "Sweet", "World"});
    }

    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class}, expectedExceptionsMessageRegExp="Cannot open new entities in read-only transaction")
    public void should_set_tx_as_read_only_using_internal_option() {
        GraphStatement stmt = new SimpleGraphStatement("graph.addVertex(label, 'software', 'name', 'lop2', 'lang', 'java');").setGraphInternalOption("cfg.read_only", "true");
        this.session().executeGraph(stmt);
    }

    @Test(groups={"short"}, expectedExceptions={OperationTimedOutException.class, InvalidQueryException.class})
    public void should_propagate_read_timeout_to_server() {
        GraphStatement stmt = new SimpleGraphStatement("java.util.concurrent.TimeUnit.MILLISECONDS.sleep(1000L);").setReadTimeoutMillis(1);
        GraphAssertions.assertThat((Boolean)stmt.isIdempotent()).isNull();
        this.session().executeGraph(stmt);
    }

    private DseCluster.Builder speculativeExecutionBuilder() {
        return this.createClusterBuilder().withGraphOptions(this.cluster().getConfiguration().getGraphOptions()).addContactPointsWithPorts(this.getContactPointsWithPorts()).withSpeculativeExecutionPolicy((SpeculativeExecutionPolicy)new ConstantSpeculativeExecutionPolicy(1L, 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_not_speculatively_execute_non_idempotent_statement() {
        DseCluster cluster = this.speculativeExecutionBuilder().build();
        try {
            DseSession session = cluster.connect();
            GraphStatement stmt = new SimpleGraphStatement("java.util.concurrent.TimeUnit.MILLISECONDS.sleep(1001L);").setIdempotent(false);
            GraphAssertions.assertThat((Boolean)stmt.isIdempotent()).isFalse();
            GraphResultSet result = session.executeGraph(stmt);
            GraphAssertions.assertThat((int)result.getExecutionInfo().getSpeculativeExecutions()).isEqualTo(0);
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_speculatively_execute_idempotent_statement() {
        DseCluster cluster = this.speculativeExecutionBuilder().build();
        try {
            DseSession session = cluster.connect();
            GraphStatement stmt = new SimpleGraphStatement("java.util.concurrent.TimeUnit.MILLISECONDS.sleep(1001L);").setIdempotent(true);
            GraphAssertions.assertThat((Boolean)stmt.isIdempotent()).isTrue();
            GraphResultSet result = session.executeGraph(stmt);
            GraphAssertions.assertThat((int)result.getExecutionInfo().getSpeculativeExecutions()).isGreaterThan(0);
        }
        finally {
            cluster.close();
        }
    }

    @Test(groups={"short"})
    public void should_detect_all_node_types() {
        GraphNode root = this.session().executeGraph("return [ root: [object: [foo:42], array: [1,2,3], vertex: g.V().next(), edge: g.E().next(), value: 42, nil: null ]]").one().get("root");
        GraphNode object = root.get("object");
        GraphNode array = root.get("array");
        GraphNode vertex = root.get("vertex");
        GraphNode edge = root.get("edge");
        GraphNode value = root.get("value");
        GraphNode nil = root.get("nil");
        GraphAssertions.assertThat(object).isNotNull();
        GraphAssertions.assertThat((boolean)object.isObject()).isTrue();
        GraphAssertions.assertThat((boolean)object.isVertex()).isFalse();
        GraphAssertions.assertThat((boolean)object.isEdge()).isFalse();
        GraphAssertions.assertThat((boolean)object.isArray()).isFalse();
        GraphAssertions.assertThat((boolean)object.isValue()).isFalse();
        GraphAssertions.assertThat((boolean)object.isNull()).isFalse();
        GraphAssertions.assertThat(array).isNotNull();
        GraphAssertions.assertThat((boolean)array.isObject()).isFalse();
        GraphAssertions.assertThat((boolean)array.isVertex()).isFalse();
        GraphAssertions.assertThat((boolean)array.isEdge()).isFalse();
        GraphAssertions.assertThat((boolean)array.isArray()).isTrue();
        GraphAssertions.assertThat((boolean)array.isValue()).isFalse();
        GraphAssertions.assertThat((boolean)array.isNull()).isFalse();
        GraphAssertions.assertThat(vertex).isNotNull();
        GraphAssertions.assertThat((boolean)vertex.isObject()).isEqualTo(this.isGraphSON1);
        GraphAssertions.assertThat((boolean)vertex.isVertex()).isTrue();
        GraphAssertions.assertThat((boolean)vertex.isEdge()).isFalse();
        GraphAssertions.assertThat((boolean)vertex.isArray()).isFalse();
        GraphAssertions.assertThat((boolean)vertex.isValue()).isEqualTo(!this.isGraphSON1);
        GraphAssertions.assertThat((boolean)vertex.isNull()).isFalse();
        GraphAssertions.assertThat(edge).isNotNull();
        GraphAssertions.assertThat((boolean)edge.isObject()).isEqualTo(this.isGraphSON1);
        GraphAssertions.assertThat((boolean)edge.isVertex()).isFalse();
        GraphAssertions.assertThat((boolean)edge.isEdge()).isTrue();
        GraphAssertions.assertThat((boolean)edge.isArray()).isFalse();
        GraphAssertions.assertThat((boolean)edge.isValue()).isEqualTo(!this.isGraphSON1);
        GraphAssertions.assertThat((boolean)edge.isNull()).isFalse();
        GraphAssertions.assertThat(value).isNotNull();
        GraphAssertions.assertThat((boolean)value.isObject()).isFalse();
        GraphAssertions.assertThat((boolean)value.isVertex()).isFalse();
        GraphAssertions.assertThat((boolean)value.isEdge()).isFalse();
        GraphAssertions.assertThat((boolean)value.isArray()).isFalse();
        GraphAssertions.assertThat((boolean)value.isValue()).isTrue();
        GraphAssertions.assertThat((boolean)value.isNull()).isFalse();
        GraphAssertions.assertThat(nil).isNotNull();
        GraphAssertions.assertThat((boolean)nil.isObject()).isFalse();
        GraphAssertions.assertThat((boolean)nil.isVertex()).isFalse();
        GraphAssertions.assertThat((boolean)nil.isEdge()).isFalse();
        GraphAssertions.assertThat((boolean)nil.isArray()).isFalse();
        GraphAssertions.assertThat((boolean)nil.isValue()).isTrue();
        GraphAssertions.assertThat((boolean)nil.isNull()).isTrue();
    }

    @Test(groups={"short"})
    public void should_resolve_path_with_some_labels() {
        GraphResultSet rs = this.session().executeGraph("g.V().hasLabel('person').has('name', 'marko').as('a').outE('knows').inV().as('c', 'd').outE('created').as('e', 'f', 'g').inV().path()");
        List results = rs.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(2);
        for (GraphNode result : results) {
            Path path = result.asPath();
            PathAssert.validatePathObjects(path);
            GraphAssertions.assertThat((List)path.getLabels()).hasSize(5);
            GraphAssertions.assertThat(path).hasLabel(0, "a").hasNoLabel(1).hasLabel(2, "c", "d").hasLabel(3, "e", "f", "g").hasNoLabel(4);
        }
    }

    @Test(groups={"short"})
    public void should_resolve_path_with_labels() {
        GraphResultSet rs = this.session().executeGraph("g.V().hasLabel('person').has('name', 'marko').as('a').outE('knows').as('b').inV().as('c', 'd').outE('created').as('e', 'f', 'g').inV().as('h').path()");
        List results = rs.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(2);
        for (GraphNode result : results) {
            Path path = result.asPath();
            PathAssert.validatePathObjects(path);
            GraphAssertions.assertThat((List)path.getLabels()).hasSize(5);
            GraphAssertions.assertThat(path).hasLabel(0, "a").hasLabel(1, "b").hasLabel(2, "c", "d").hasLabel(3, "e", "f", "g").hasLabel(4, "h");
        }
    }

    @Test(groups={"short"})
    public void should_resolve_path_without_labels() {
        GraphResultSet rs = this.session().executeGraph("g.V().hasLabel('person').has('name', 'marko').outE('knows').inV().outE('created').inV().path()");
        List results = rs.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(2);
        for (GraphNode result : results) {
            Path path = result.asPath();
            PathAssert.validatePathObjects(path);
            GraphAssertions.assertThat((List)path.getLabels()).hasSize(5);
            for (int i = 0; i < 5; ++i) {
                GraphAssertions.assertThat(path).hasNoLabel(i);
            }
        }
    }
}

