/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.QueryConsistencyException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import java.util.List;
import org.testng.annotations.Test;

@CCMConfig(numberOfNodes={3}, dirtiesContext={true})
@DseVersion(value="5.0.0")
public class GraphConsistencyTest
extends CCMGraphTestsSupport {
    private static final boolean isDSE50;

    @Override
    public CCMBridge.Builder configureCCM() {
        CCMBridge.Builder builder = super.configureCCM().withNodes(3);
        for (int i = 1; i <= 3; ++i) {
            builder = builder.withWorkload(i, "graph").withDSEConfiguration("graph.gremlin_server.port", "0");
        }
        return builder;
    }

    @Override
    public void onTestContextInitialized() {
        this.createAndSetGraphConfig(3);
        this.cluster().getConfiguration().getSocketOptions().setReadTimeoutMillis(32000);
        this.executeGraph(GraphFixtures.modern);
        this.session().executeGraph("g.V().limit(1)");
        this.cluster().getConfiguration().getSocketOptions().setReadTimeoutMillis(12000);
        this.ccm().stop(2);
    }

    @Test(groups={"long"})
    public void should_be_able_to_make_read_query_with_graph_read_cl_one_and_node_down() {
        GraphResultSet result = this.session().executeGraph(new SimpleGraphStatement("g.V().limit(1)").setGraphReadConsistencyLevel(ConsistencyLevel.ONE).setGraphWriteConsistencyLevel(ConsistencyLevel.ALL).setConsistencyLevel(ConsistencyLevel.ALL));
        GraphAssertions.assertThat((int)result.all().size()).isEqualTo(1);
    }

    @Test(groups={"long"})
    public void should_be_able_to_make_read_query_with_cl_one_and_node_down() {
        GraphResultSet result = this.session().executeGraph(new SimpleGraphStatement("g.V().limit(1)").setConsistencyLevel(ConsistencyLevel.ONE));
        GraphAssertions.assertThat((int)result.all().size()).isEqualTo(1);
    }

    @Test(groups={"long"})
    public void should_not_be_able_to_make_read_query_with_graph_read_cl_all_and_node_down() {
        try {
            this.session().executeGraph(new SimpleGraphStatement("g.V().limit(1)").setGraphReadConsistencyLevel(ConsistencyLevel.ALL).setGraphWriteConsistencyLevel(ConsistencyLevel.ONE).setConsistencyLevel(ConsistencyLevel.ONE));
        }
        catch (DriverException e) {
            this.assertConsistencyException(e);
        }
    }

    @Test(groups={"long"})
    public void should_not_be_able_to_make_read_query_with_cl_all_and_node_down() {
        try {
            this.session().executeGraph(new SimpleGraphStatement("g.V().limit(1)").setConsistencyLevel(ConsistencyLevel.ALL));
        }
        catch (DriverException e) {
            this.assertConsistencyException(e);
        }
    }

    @Test(groups={"long"})
    public void should_be_able_to_make_write_query_with_graph_write_cl_one_and_node_down() {
        GraphResultSet result = this.session().executeGraph(new SimpleGraphStatement("graph.addVertex(label, 'person', 'name', 'don', 'age', 37)").setGraphWriteConsistencyLevel(ConsistencyLevel.ONE).setGraphReadConsistencyLevel(ConsistencyLevel.ALL).setConsistencyLevel(ConsistencyLevel.ALL));
        List results = result.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        GraphAssertions.assertThat((GraphNode)results.get(0)).asVertex().hasProperty("name", "don");
    }

    @Test(groups={"long"})
    public void should_be_able_to_make_write_query_with_cl_one_and_node_down() {
        GraphResultSet result = this.session().executeGraph(new SimpleGraphStatement("graph.addVertex(label, 'person', 'name', 'don2', 'age', 37)").setConsistencyLevel(ConsistencyLevel.ONE));
        List results = result.all();
        GraphAssertions.assertThat((int)results.size()).isEqualTo(1);
        GraphAssertions.assertThat((GraphNode)results.get(0)).asVertex().hasProperty("name", "don2");
    }

    @Test(groups={"long"})
    public void should_not_be_able_to_make_write_query_with_graph_write_cl_all_and_node_down() {
        try {
            this.session().executeGraph(new SimpleGraphStatement("graph.addVertex(label, 'person', 'name', 'joe', 'age', 42)").setGraphWriteConsistencyLevel(ConsistencyLevel.ALL).setGraphReadConsistencyLevel(ConsistencyLevel.ONE).setConsistencyLevel(ConsistencyLevel.ONE));
        }
        catch (DriverException e) {
            this.assertConsistencyException(e);
        }
    }

    @Test(groups={"long"})
    public void should_not_be_able_to_make_write_query_with_cl_all_and_node_down() {
        try {
            this.session().executeGraph(new SimpleGraphStatement("graph.addVertex(label, 'person', 'name', 'joe', 'age', 42)").setConsistencyLevel(ConsistencyLevel.ALL));
        }
        catch (DriverException e) {
            this.assertConsistencyException(e);
        }
    }

    private void assertConsistencyException(DriverException e) {
        if (isDSE50) {
            GraphAssertions.assertThat((Throwable)e).isInstanceOf(InvalidQueryException.class);
        } else {
            GraphAssertions.assertThat((Throwable)e).isInstanceOfAny(new Class[]{UnavailableException.class, QueryConsistencyException.class});
        }
    }

    static {
        VersionNumber dseVersion = CCMBridge.getGlobalDSEVersion();
        isDSE50 = dseVersion != null && dseVersion.getMajor() == 5 && dseVersion.getMinor() == 0;
    }
}

