/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.datastax.driver.dse.auth.EmbeddedADS;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.assertj.core.api.Assertions;

public class KerberosUtils {
    public static void executeCommand(String command, EmbeddedADS adsServer) throws IOException {
        ImmutableMap environmentMap = ImmutableMap.builder().put((Object)"KRB5_CONFIG", (Object)adsServer.getKrb5Conf().getAbsolutePath()).build();
        CommandLine cli = CommandLine.parse((String)command);
        DefaultExecutor executor = new DefaultExecutor();
        int retValue = executor.execute(cli, (Map)environmentMap);
        Assertions.assertThat((int)retValue).isZero();
    }

    public static void acquireTicket(String principal, File keytab, EmbeddedADS adsServer) throws IOException {
        KerberosUtils.executeCommand(String.format("kinit -t %s -k %s", keytab.getAbsolutePath(), principal), adsServer);
    }

    public static void destroyTicket(EmbeddedADS adsServer) throws IOException {
        KerberosUtils.executeCommand("kdestroy", adsServer);
    }

    public static Configuration ticketClient(final String principal) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                ImmutableMap options = ImmutableMap.builder().put((Object)"principal", (Object)principal).put((Object)"useTicketCache", (Object)"true").put((Object)"refreshKrb5Config", (Object)"true").put((Object)"renewTGT", (Object)"true").build();
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)options)};
            }
        };
    }

    public static Configuration keytabClient(final File keytabFile, final String principal) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                ImmutableMap options = ImmutableMap.builder().put((Object)"principal", (Object)principal).put((Object)"useKeyTab", (Object)"true").put((Object)"refreshKrb5Config", (Object)"true").put((Object)"keyTab", (Object)keytabFile.getAbsolutePath()).build();
                return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, (Map<String, ?>)options)};
            }
        };
    }
}

