/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.utils;

import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.utils.UUIDs;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class UUIDsPIDFromPropertyTest {
    private static final Logger logger = Logger.getLogger(UUIDs.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"isolated"})
    public void should_obtain_pid_from_system_property() {
        MemoryAppender appender = new MemoryAppender();
        Level originalLevel = logger.getLevel();
        try {
            logger.setLevel(Level.INFO);
            logger.addAppender((Appender)appender);
            int pid = 8675;
            System.setProperty("com.datastax.driver.PID", "" + pid);
            UUIDs.timeBased();
            Assertions.assertThat((String)appender.get()).containsOnlyOnce((CharSequence)String.format("PID obtained from System property %s: %d", "com.datastax.driver.PID", pid));
        }
        finally {
            logger.removeAppender((Appender)appender);
            logger.setLevel(originalLevel);
        }
    }
}

