/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class CompressionOptionsTest {
    @Test(groups={"unit"})
    public void should_build_compressions_options_for_lz4() throws Exception {
        String built = SchemaBuilder.lz4().withChunkLengthInKb(Integer.valueOf(128)).withCRCCheckChance(Double.valueOf(0.6)).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'sstable_compression' : 'LZ4Compressor', 'chunk_length_kb' : 128, 'crc_check_chance' : 0.6}");
    }

    @Test(groups={"unit"})
    public void should_create_snappy_compressions_options() throws Exception {
        String built = SchemaBuilder.snappy().withChunkLengthInKb(Integer.valueOf(128)).withCRCCheckChance(Double.valueOf(0.6)).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'sstable_compression' : 'SnappyCompressor', 'chunk_length_kb' : 128, 'crc_check_chance' : 0.6}");
    }

    @Test(groups={"unit"})
    public void should_create_deflate_compressions_options() throws Exception {
        String built = SchemaBuilder.deflate().withChunkLengthInKb(Integer.valueOf(128)).withCRCCheckChance(Double.valueOf(0.6)).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'sstable_compression' : 'DeflateCompressor', 'chunk_length_kb' : 128, 'crc_check_chance' : 0.6}");
    }

    @Test(groups={"unit"})
    public void should_create_no_compressions_options() throws Exception {
        String built = SchemaBuilder.noCompression().withChunkLengthInKb(Integer.valueOf(128)).withCRCCheckChance(Double.valueOf(0.6)).build();
        Assertions.assertThat((String)built).isEqualTo((Object)"{'sstable_compression' : ''}");
    }
}

