/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class QueryBuilder21ExecutionTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE products (id int PRIMARY KEY, description text, price int, categories set<text>, buyers list<int>, features_keys map<text, text>, features_values map<text, text>)", "CREATE INDEX cat_index ON products(categories)", "CREATE INDEX buyers_index ON products(buyers)", "CREATE INDEX feat_index ON products(features_values)", "CREATE INDEX feat_key_index ON products(KEYS(features_keys))", "INSERT INTO products(id, description, price, categories, buyers, features_keys, features_values) VALUES (34134, '120-inch 1080p 3D plasma TV', 9999, {'tv', '3D', 'hdtv'}, [1], {'screen' : '120-inch', 'refresh-rate' : '400hz', 'techno' : 'plasma'}, {'screen' : '120-inch', 'refresh-rate' : '400hz', 'techno' : 'plasma'})", "INSERT INTO products(id, description, price, categories, buyers, features_keys, features_values) VALUES (29412, '32-inch LED HDTV (black)', 929, {'tv', 'hdtv'}, [1,2,3], {'screen' : '32-inch', 'techno' : 'LED'}, {'screen' : '32-inch', 'techno' : 'LED'})", "INSERT INTO products(id, description, price, categories, buyers, features_keys, features_values) VALUES (38471, '32-inch LCD TV', 110, {'tv', 'used'}, [2,4], {'screen' : '32-inch', 'techno' : 'LCD'}, {'screen' : '32-inch', 'techno' : 'LCD'})");
    }

    @Test(groups={"short"})
    public void should_handle_contains_on_set_with_index() {
        PreparedStatement byCategory = this.session().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"id", "description", "categories"}).from("products").where(QueryBuilder.contains((String)"categories", (Object)QueryBuilder.bindMarker((String)"category"))));
        ResultSet results = this.session().execute((Statement)byCategory.bind().setString("category", "hdtv"));
        Assertions.assertThat((int)results.getAvailableWithoutFetching()).isEqualTo(2);
        for (Row row : results) {
            Assertions.assertThat((Iterable)row.getSet("categories", String.class)).contains((Object[])new String[]{"hdtv"});
        }
    }

    @Test(groups={"short"})
    public void should_handle_contains_on_list_with_index() {
        PreparedStatement byBuyer = this.session().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"id", "description", "buyers"}).from("products").where(QueryBuilder.contains((String)"buyers", (Object)QueryBuilder.bindMarker((String)"buyer"))));
        ResultSet results = this.session().execute((Statement)byBuyer.bind().setInt("buyer", 4));
        Row row = results.one();
        Assertions.assertThat((Object)row).isNotNull();
        Assertions.assertThat((int)row.getInt("id")).isEqualTo(38471);
        Assertions.assertThat((List)row.getList("buyers", Integer.class)).contains((Object[])new Integer[]{4});
    }

    @Test(groups={"short"})
    public void should_handle_contains_on_map_with_index() {
        PreparedStatement byFeatures = this.session().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"id", "description", "features_values"}).from("products").where(QueryBuilder.contains((String)"features_values", (Object)QueryBuilder.bindMarker((String)"feature"))));
        ResultSet results = this.session().execute((Statement)byFeatures.bind().setString("feature", "LED"));
        Row row = results.one();
        Assertions.assertThat((Object)row).isNotNull();
        Assertions.assertThat((int)row.getInt("id")).isEqualTo(29412);
        Assertions.assertThat((Map)row.getMap("features_values", String.class, String.class)).containsEntry((Object)"techno", (Object)"LED");
    }

    @Test(groups={"short"})
    public void should_handle_contains_key_on_map_with_index() {
        PreparedStatement byFeatures = this.session().prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"id", "description", "features_keys"}).from("products").where(QueryBuilder.containsKey((String)"features_keys", (Object)QueryBuilder.bindMarker((String)"feature"))));
        ResultSet results = this.session().execute((Statement)byFeatures.bind().setString("feature", "refresh-rate"));
        Row row = results.one();
        Assertions.assertThat((Object)row).isNotNull();
        Assertions.assertThat((int)row.getInt("id")).isEqualTo(34134);
        Assertions.assertThat((Map)row.getMap("features_keys", String.class, String.class)).containsEntry((Object)"refresh-rate", (Object)"400hz");
    }
}

