/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.policies.Clock;
import com.datastax.driver.core.policies.RollingCount;
import java.util.concurrent.TimeUnit;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RollingCountTest {
    @Mock
    Clock clock;
    RollingCount rollingCount;

    @BeforeMethod(groups={"unit"})
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Assertions.assertThat((long)this.clock.nanoTime()).isEqualTo(0L);
        this.rollingCount = new RollingCount(this.clock);
    }

    @Test(groups={"unit"})
    public void should_record_adds_in_first_interval() {
        this.rollingCount.increment();
        this.setTime(1L, TimeUnit.SECONDS);
        this.rollingCount.increment();
        this.setTime(2L, TimeUnit.SECONDS);
        this.rollingCount.increment();
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(0L);
        this.setTime(5L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(3L);
    }

    @Test(groups={"unit"})
    public void should_record_adds_over_two_intervals() {
        this.rollingCount.add(2L);
        this.setTime(5L, TimeUnit.SECONDS);
        this.rollingCount.add(3L);
        this.setTime(10L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(5L);
    }

    @Test(groups={"unit"})
    public void should_record_adds_separated_by_idle_intervals() {
        this.rollingCount.add(2L);
        this.setTime(10L, TimeUnit.SECONDS);
        this.rollingCount.add(3L);
        this.setTime(15L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(5L);
    }

    @Test(groups={"unit"})
    public void should_rotate() {
        this.rollingCount.add(2L);
        for (int i = 1; i < 12; ++i) {
            this.setTime(i * 5, TimeUnit.SECONDS);
            this.rollingCount.add(1L);
        }
        this.setTime(60L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(13L);
        this.rollingCount.add(1L);
        this.setTime(65L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(12L);
    }

    @Test(groups={"unit"})
    public void should_rotate_with_idle_intervals() {
        for (int i = 0; i < 12; ++i) {
            this.setTime(i * 5, TimeUnit.SECONDS);
            this.rollingCount.add(1L);
        }
        this.setTime(75L, TimeUnit.SECONDS);
        this.rollingCount.add(1L);
        this.setTime(80L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(9L);
    }

    @Test(groups={"unit"})
    public void should_rotate_when_idle_for_full_period() {
        for (int i = 0; i < 12; ++i) {
            this.setTime(i * 5, TimeUnit.SECONDS);
            this.rollingCount.add(1L);
        }
        this.setTime(120L, TimeUnit.SECONDS);
        this.rollingCount.add(1L);
        this.setTime(125L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(1L);
    }

    @Test(groups={"unit"})
    public void should_rotate_when_idle_for_more_than_full_period() {
        for (int i = 0; i < 12; ++i) {
            this.setTime(i * 5, TimeUnit.SECONDS);
            this.rollingCount.add(1L);
        }
        this.setTime(125L, TimeUnit.SECONDS);
        this.rollingCount.add(1L);
        this.setTime(130L, TimeUnit.SECONDS);
        Assertions.assertThat((long)this.rollingCount.get()).isEqualTo(1L);
    }

    private void setTime(long time, TimeUnit unit) {
        Mockito.when((Object)this.clock.nanoTime()).thenReturn((Object)TimeUnit.NANOSECONDS.convert(time, unit));
    }
}

