/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.BootstrappingException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.OverloadedException;
import com.datastax.driver.core.exceptions.PagingStateException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.UnpreparedException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ExceptionsTest
extends CCMTestsSupport {
    private InetSocketAddress address1 = new InetSocketAddress("127.0.0.1", 9042);
    private InetSocketAddress address2 = new InetSocketAddress("127.0.0.2", 9042);

    @Test(groups={"short"})
    public void alreadyExistsException() throws Throwable {
        String keyspace = "TestKeyspace";
        String table = "TestTable";
        String[] cqlCommands = new String[]{String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, 1), "USE " + keyspace, String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", table)};
        this.session().execute(cqlCommands[0]);
        this.session().execute(cqlCommands[1]);
        this.session().execute(cqlCommands[2]);
        try {
            this.session().execute(cqlCommands[0]);
        }
        catch (AlreadyExistsException e) {
            String expected = String.format("Keyspace %s already exists", keyspace.toLowerCase());
            Assert.assertEquals((String)e.getMessage(), (String)expected);
            Assert.assertEquals((String)e.getKeyspace(), (String)keyspace.toLowerCase());
            Assert.assertEquals((String)e.getTable(), null);
            Assert.assertEquals((boolean)e.wasTableCreation(), (boolean)false);
            Assert.assertEquals((Object)e.getHost(), (Object)this.ccm().addressOfNode(1).getAddress());
            Assert.assertEquals((Object)e.getAddress(), (Object)this.ccm().addressOfNode(1));
        }
        this.session().execute(cqlCommands[1]);
        try {
            this.session().execute(cqlCommands[2]);
        }
        catch (AlreadyExistsException e) {
            Assert.assertEquals((String)e.getKeyspace(), (String)keyspace.toLowerCase());
            Assert.assertEquals((String)e.getTable(), (String)table.toLowerCase());
            Assert.assertEquals((boolean)e.wasTableCreation(), (boolean)true);
            Assert.assertEquals((Object)e.getHost(), (Object)this.ccm().addressOfNode(1).getAddress());
            Assert.assertEquals((Object)e.getAddress(), (Object)this.ccm().addressOfNode(1));
        }
    }

    @Test(groups={"short"})
    public void noHostAvailableException() throws Exception {
        try {
            Cluster.builder().addContactPoints(new String[]{"255.255.255.255"}).build();
        }
        catch (NoHostAvailableException e) {
            Assert.assertEquals((int)e.getErrors().size(), (int)1);
            Assert.assertTrue((boolean)((Throwable)e.getErrors().values().iterator().next()).toString().contains("[/255.255.255.255] Cannot connect"));
            NoHostAvailableException copy = e.copy();
            Assert.assertEquals((String)copy.getMessage(), (String)e.getMessage());
            Assert.assertEquals((Map)copy.getErrors(), (Map)e.getErrors());
        }
    }

    @Test(groups={"unit"})
    public void driverInternalError() throws Exception {
        String errorMessage = "Test Message";
        try {
            throw new DriverInternalError(errorMessage);
        }
        catch (DriverInternalError e1) {
            try {
                throw new DriverInternalError((Throwable)e1);
            }
            catch (DriverInternalError e2) {
                Assert.assertTrue((boolean)e2.getMessage().contains(errorMessage));
                DriverInternalError copy = e2.copy();
                Assert.assertEquals((String)copy.getMessage(), (String)e2.getMessage());
                return;
            }
        }
    }

    @Test(groups={"unit"})
    public void should_create_proper_already_exists_exception_for_keyspaces() {
        AlreadyExistsException e = new AlreadyExistsException(this.address1, "keyspace1", "");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Keyspace keyspace1 already exists");
        Assertions.assertThat((String)e.getKeyspace()).isEqualTo((Object)"keyspace1");
        Assertions.assertThat((String)e.getTable()).isNull();
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy(this.address2);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Keyspace keyspace1 already exists");
        Assertions.assertThat((String)e.getKeyspace()).isEqualTo((Object)"keyspace1");
        Assertions.assertThat((String)e.getTable()).isNull();
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address2);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address2.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_already_exists_exception_for_tables() {
        AlreadyExistsException e = new AlreadyExistsException(this.address1, "keyspace1", "table1");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Table keyspace1.table1 already exists");
        Assertions.assertThat((String)e.getKeyspace()).isEqualTo((Object)"keyspace1");
        Assertions.assertThat((String)e.getTable()).isEqualTo((Object)"table1");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy(this.address2);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Table keyspace1.table1 already exists");
        Assertions.assertThat((String)e.getKeyspace()).isEqualTo((Object)"keyspace1");
        Assertions.assertThat((String)e.getTable()).isEqualTo((Object)"table1");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address2);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address2.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_bootstrapping_exception() {
        BootstrappingException e = new BootstrappingException(this.address1, "Sorry mate");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)("Queried host (" + this.address1 + ") was bootstrapping: Sorry mate"));
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)("Queried host (" + this.address1 + ") was bootstrapping: Sorry mate"));
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_invalid_query_exception() {
        InvalidQueryException e = new InvalidQueryException("Bad, really bad");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Bad, really bad");
        e = (InvalidQueryException)e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Bad, really bad");
    }

    @Test(groups={"unit"})
    public void should_create_proper_trace_retrieval_exception() {
        TraceRetrievalException e = new TraceRetrievalException("Couldn't find any trace of it");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Couldn't find any trace of it");
        e = e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Couldn't find any trace of it");
    }

    @Test(groups={"unit"})
    public void should_create_proper_paging_state_exception() {
        PagingStateException e = new PagingStateException("Bad, really bad");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Bad, really bad");
    }

    @Test(groups={"unit"})
    public void should_create_proper_invalid_configuration_in_query_exception() {
        InvalidConfigurationInQueryException e = new InvalidConfigurationInQueryException(this.address1, "Bad, really bad");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Bad, really bad");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        InvalidConfigurationInQueryException e1 = e.copy();
        Assertions.assertThat((String)e1.getMessage()).isEqualTo((Object)"Bad, really bad");
    }

    @Test(groups={"unit"})
    public void should_create_proper_overloaded_exception() {
        OverloadedException e = new OverloadedException(this.address1, "I'm busy");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)("Queried host (" + this.address1 + ") was overloaded: I'm busy"));
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)("Queried host (" + this.address1 + ") was overloaded: I'm busy"));
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_syntax_error() {
        SyntaxError e = new SyntaxError(this.address1, "Missing ) at EOF");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Missing ) at EOF");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Missing ) at EOF");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_truncate_exception() {
        TruncateException e = new TruncateException(this.address1, "I'm running headless now");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"I'm running headless now");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"I'm running headless now");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_unauthorized_exception() {
        UnauthorizedException e = new UnauthorizedException(this.address1, "You talking to me?");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"You talking to me?");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"You talking to me?");
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_unavailable_exception() {
        UnavailableException e = new UnavailableException(this.address1, ConsistencyLevel.LOCAL_QUORUM, 3, 2);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Not enough replicas available for query at consistency LOCAL_QUORUM (3 required but only 2 alive)");
        Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_QUORUM);
        Assertions.assertThat((int)e.getAliveReplicas()).isEqualTo(2);
        Assertions.assertThat((int)e.getRequiredReplicas()).isEqualTo(3);
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy(this.address2);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Not enough replicas available for query at consistency LOCAL_QUORUM (3 required but only 2 alive)");
        Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_QUORUM);
        Assertions.assertThat((int)e.getAliveReplicas()).isEqualTo(2);
        Assertions.assertThat((int)e.getRequiredReplicas()).isEqualTo(3);
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address2);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address2.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_unprepared_exception() {
        UnpreparedException e = new UnpreparedException(this.address1, "Caught me unawares");
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)("A prepared query was submitted on " + this.address1 + " but was not known of that node: Caught me unawares"));
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy();
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)("A prepared query was submitted on " + this.address1 + " but was not known of that node: Caught me unawares"));
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_read_timeout_exception() {
        ReadTimeoutException e = new ReadTimeoutException(this.address1, ConsistencyLevel.LOCAL_QUORUM, 2, 3, true);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Cassandra timeout during read query at consistency LOCAL_QUORUM (3 responses were required but only 2 replica responded)");
        Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_QUORUM);
        Assertions.assertThat((int)e.getReceivedAcknowledgements()).isEqualTo(2);
        Assertions.assertThat((int)e.getRequiredAcknowledgements()).isEqualTo(3);
        Assertions.assertThat((boolean)e.wasDataRetrieved()).isTrue();
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy(this.address2);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Cassandra timeout during read query at consistency LOCAL_QUORUM (3 responses were required but only 2 replica responded)");
        Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_QUORUM);
        Assertions.assertThat((int)e.getReceivedAcknowledgements()).isEqualTo(2);
        Assertions.assertThat((int)e.getRequiredAcknowledgements()).isEqualTo(3);
        Assertions.assertThat((boolean)e.wasDataRetrieved()).isTrue();
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address2);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address2.getAddress());
    }

    @Test(groups={"unit"})
    public void should_create_proper_write_timeout_exception() {
        WriteTimeoutException e = new WriteTimeoutException(this.address1, ConsistencyLevel.LOCAL_QUORUM, WriteType.BATCH, 2, 3);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Cassandra timeout during BATCH write query at consistency LOCAL_QUORUM (3 replica were required but only 2 acknowledged the write)");
        Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_QUORUM);
        Assertions.assertThat((int)e.getReceivedAcknowledgements()).isEqualTo(2);
        Assertions.assertThat((int)e.getRequiredAcknowledgements()).isEqualTo(3);
        Assertions.assertThat((Comparable)e.getWriteType()).isEqualTo((Object)WriteType.BATCH);
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address1);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address1.getAddress());
        e = e.copy(this.address2);
        Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Cassandra timeout during BATCH write query at consistency LOCAL_QUORUM (3 replica were required but only 2 acknowledged the write)");
        Assertions.assertThat((Comparable)e.getConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.LOCAL_QUORUM);
        Assertions.assertThat((int)e.getReceivedAcknowledgements()).isEqualTo(2);
        Assertions.assertThat((int)e.getRequiredAcknowledgements()).isEqualTo(3);
        Assertions.assertThat((Comparable)e.getWriteType()).isEqualTo((Object)WriteType.BATCH);
        Assertions.assertThat((Object)e.getAddress()).isEqualTo((Object)this.address2);
        Assertions.assertThat((Object)e.getHost()).isEqualTo((Object)this.address2.getAddress());
    }
}

