/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.base.Strings;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CCMConfig(config={"batch_size_warn_threshold_in_kb:5"})
@CassandraVersion(value="2.2.0")
public class WarningsTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE foo(k int primary key, v text)");
    }

    @Test(groups={"short"})
    public void should_expose_warnings_on_execution_info() {
        ResultSet rs = this.session().execute(String.format("BEGIN UNLOGGED BATCH\nINSERT INTO foo (k, v) VALUES (1, '%s')\nINSERT INTO foo (k, v) VALUES (2, '%s')\nAPPLY BATCH", Strings.repeat((String)"1", (int)2048), Strings.repeat((String)"1", (int)3072)));
        List warnings = rs.getExecutionInfo().getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
    }
}

