/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.VersionNumber;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;

public class VersionNumberAssert
extends AbstractComparableAssert<VersionNumberAssert, VersionNumber> {
    public VersionNumberAssert(VersionNumber actual) {
        super((Comparable)actual, VersionNumberAssert.class);
    }

    public VersionNumberAssert hasMajorMinorPatch(int major, int minor, int patch) {
        Assertions.assertThat((int)((VersionNumber)this.actual).getMajor()).isEqualTo(major);
        Assertions.assertThat((int)((VersionNumber)this.actual).getMinor()).isEqualTo(minor);
        Assertions.assertThat((int)((VersionNumber)this.actual).getPatch()).isEqualTo(patch);
        return this;
    }

    public VersionNumberAssert hasDsePatch(int dsePatch) {
        Assertions.assertThat((int)((VersionNumber)this.actual).getDSEPatch()).isEqualTo(dsePatch);
        return this;
    }

    public VersionNumberAssert hasPreReleaseLabels(String ... labels) {
        Assertions.assertThat((List)((VersionNumber)this.actual).getPreReleaseLabels()).containsExactly((Object[])labels);
        return this;
    }

    public VersionNumberAssert hasNoPreReleaseLabels() {
        Assertions.assertThat((List)((VersionNumber)this.actual).getPreReleaseLabels()).isNull();
        return this;
    }

    public VersionNumberAssert hasBuildLabel(String label) {
        Assertions.assertThat((String)((VersionNumber)this.actual).getBuildLabel()).isEqualTo((Object)label);
        return this;
    }

    public VersionNumberAssert hasNextStable(String version) {
        Assertions.assertThat(((VersionNumber)this.actual).nextStable()).isEqualTo(VersionNumber.parse((String)version));
        return this;
    }

    public VersionNumberAssert hasToString(String string) {
        Assertions.assertThat((String)((VersionNumber)this.actual).toString()).isEqualTo((Object)string);
        return this;
    }
}

