/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.CassandraVersion;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TypeCodecNumbersIntegrationTest
extends CCMTestsSupport {
    private final String insertQuery = "INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)";
    private final String selectQuery = "SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?";
    private int n_int = 42;
    private long n_bigint = 4242L;
    private float n_float = 42.42f;
    private double n_double = 4242.42;
    private BigInteger n_varint = new BigInteger("424242");
    private BigDecimal n_decimal = new BigDecimal("424242.42");

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE \"myTable\" (c_int int, c_bigint bigint, c_float float, c_double double, c_varint varint, c_decimal decimal, PRIMARY KEY (c_int, c_bigint))");
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_use_defaut_codecs_with_simple_statements() {
        this.session().execute("INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)", new Object[]{this.n_int, this.n_bigint, Float.valueOf(this.n_float), this.n_double, this.n_varint, this.n_decimal});
        ResultSet rows = this.session().execute("SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?", new Object[]{this.n_int, this.n_bigint});
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_defaut_codecs_with_prepared_statements_1() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)").bind(new Object[]{this.n_int, this.n_bigint, Float.valueOf(this.n_float), this.n_double, this.n_varint, this.n_decimal}));
        PreparedStatement ps = this.session().prepare("SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind(new Object[]{this.n_int, this.n_bigint}));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_default_codecs_with_prepared_statements_2() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)").bind().setInt(0, this.n_int).setLong(1, this.n_bigint).setFloat(2, this.n_float).setDouble(3, this.n_double).setVarint(4, this.n_varint).setDecimal(5, this.n_decimal));
        PreparedStatement ps = this.session().prepare("SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.n_int).setLong(1, this.n_bigint));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_default_codecs_with_prepared_statements_3() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)").bind().set(0, (Object)this.n_int, Integer.class).set(1, (Object)this.n_bigint, Long.class).set(2, (Object)Float.valueOf(this.n_float), Float.class).set(3, (Object)this.n_double, Double.class).set(4, (Object)this.n_varint, BigInteger.class).set(5, (Object)this.n_decimal, BigDecimal.class));
        PreparedStatement ps = this.session().prepare("SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.n_int).setLong(1, this.n_bigint));
        Row row = rows.one();
        this.assertRow(row);
    }

    private void assertRow(Row row) {
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(this.n_int);
        Assertions.assertThat((long)row.getLong(1)).isEqualTo(this.n_bigint);
        Assertions.assertThat((float)row.getFloat(2)).isEqualTo(this.n_float);
        Assertions.assertThat((double)row.getDouble(3)).isEqualTo(this.n_double);
        Assertions.assertThat((Comparable)row.getVarint(4)).isEqualTo((Object)this.n_varint);
        Assertions.assertThat((BigDecimal)row.getDecimal(5)).isEqualTo((Object)this.n_decimal);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.n_int);
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)this.n_bigint);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)Float.valueOf(this.n_float));
        Assertions.assertThat((Object)row.getObject(3)).isEqualTo((Object)this.n_double);
        Assertions.assertThat((Object)row.getObject(4)).isEqualTo((Object)this.n_varint);
        Assertions.assertThat((Object)row.getObject(5)).isEqualTo((Object)this.n_decimal);
        Assertions.assertThat((Integer)((Integer)row.get(0, Integer.class))).isEqualTo(this.n_int);
        Assertions.assertThat((Long)((Long)row.get(1, Long.class))).isEqualTo(this.n_bigint);
        Assertions.assertThat((Float)((Float)row.get(2, Float.class))).isEqualTo(this.n_float);
        Assertions.assertThat((Double)((Double)row.get(3, Double.class))).isEqualTo(this.n_double);
        Assertions.assertThat((Comparable)((Comparable)row.get(4, BigInteger.class))).isEqualTo((Object)this.n_varint);
        Assertions.assertThat((BigDecimal)((BigDecimal)row.get(5, BigDecimal.class))).isEqualTo((Object)this.n_decimal);
    }
}

