/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.KeyspaceMetadataAssert;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.SchemaElement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.DseVersion;
import java.util.Collections;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.SkipException;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(dirtiesContext={true}, createKeyspace={false})
public class SchemaRefreshDebouncerTest
extends CCMTestsSupport {
    private static final int DEBOUNCE_TIME = 5000;
    private ControlConnection controlConnection;
    private SchemaChangeListener listener;
    private Session session2;
    private Cluster cluster2;

    @BeforeMethod(groups={"short"})
    public void setup() {
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setRefreshSchemaIntervalMillis(5000);
        queryOptions.setMaxPendingRefreshSchemaRequests(5);
        this.cluster2 = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withQueryOptions(queryOptions).build());
        this.session2 = this.cluster2.connect();
        this.cluster2.manager.controlConnection = this.controlConnection = (ControlConnection)Mockito.spy((Object)this.cluster2.manager.controlConnection);
        this.listener = (SchemaChangeListener)Mockito.mock(SchemaChangeListener.class);
        this.cluster2.register(this.listener);
        Mockito.reset((Object[])new SchemaChangeListener[]{this.listener});
        Mockito.reset((Object[])new ControlConnection[]{this.controlConnection});
    }

    @Test(groups={"short"})
    public void should_debounce_and_coalesce_create_and_alter_keyspace_into_refresh_keyspace() throws Exception {
        String keyspace = TestUtils.generateIdentifier("ks_");
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, 1));
        this.session().execute(String.format("ALTER KEYSPACE %s WITH DURABLE_WRITES=false", keyspace));
        ArgumentCaptor captor = ArgumentCaptor.forClass(KeyspaceMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.timeout((long)10000L).only())).onKeyspaceAdded((KeyspaceMetadata)captor.capture());
        Assertions.assertThat((KeyspaceMetadata)captor.getValue()).hasName(keyspace).isNotDurableWrites();
        ((ControlConnection)Mockito.verify((Object)this.controlConnection, (VerificationMode)Mockito.times((int)1))).refreshSchema(SchemaElement.KEYSPACE, keyspace, null, null);
        KeyspaceMetadata ksm = this.cluster2.getMetadata().getKeyspace(keyspace);
        ((KeyspaceMetadataAssert)Assertions.assertThat(ksm).isNotNull()).hasName(keyspace).isNotDurableWrites();
    }

    @Test(groups={"short"})
    public void should_debounce_and_coalesce_create_keyspace_and_table_into_refresh_keyspace() throws Exception {
        String keyspace = TestUtils.generateIdentifier("ks_");
        String table = "tbl1";
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, 1));
        this.session().execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", keyspace + "." + table));
        ArgumentCaptor keyspaceCaptor = ArgumentCaptor.forClass(KeyspaceMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.timeout((long)10000L).times(1))).onKeyspaceAdded((KeyspaceMetadata)keyspaceCaptor.capture());
        Assertions.assertThat((KeyspaceMetadata)keyspaceCaptor.getValue()).hasName(keyspace);
        ArgumentCaptor tableCaptor = ArgumentCaptor.forClass(TableMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.timeout((long)10000L).times(1))).onTableAdded((TableMetadata)tableCaptor.capture());
        Assertions.assertThat((TableMetadata)tableCaptor.getValue()).hasName(table);
        ((ControlConnection)Mockito.verify((Object)this.controlConnection)).refreshSchema(SchemaElement.KEYSPACE, keyspace, null, null);
        ((ControlConnection)Mockito.verify((Object)this.controlConnection, (VerificationMode)Mockito.never())).refreshSchema(SchemaElement.TABLE, keyspace, table, null);
        KeyspaceMetadata ksm = this.cluster2.getMetadata().getKeyspace(keyspace);
        Assertions.assertThat(ksm).isNotNull();
        Assertions.assertThat(ksm.getTable(table)).isNotNull();
    }

    @Test(groups={"short"})
    public void should_debounce_and_coalesce_tables_in_same_keyspace_into_refresh_keyspace() throws Exception {
        String keyspace = TestUtils.generateIdentifier("ks_");
        this.session2.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, 1));
        Mockito.reset((Object[])new ControlConnection[]{this.controlConnection});
        Mockito.reset((Object[])new SchemaChangeListener[]{this.listener});
        int tableCount = 3;
        for (int i = 0; i < tableCount; ++i) {
            this.session().execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", keyspace + ".tbl" + i));
        }
        ((SchemaChangeListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.timeout((long)15000L).times(3))).onTableAdded((TableMetadata)Mockito.any(TableMetadata.class));
        ((ControlConnection)Mockito.verify((Object)this.controlConnection)).refreshSchema(SchemaElement.KEYSPACE, keyspace, null, null);
        KeyspaceMetadata ksm = this.cluster2.getMetadata().getKeyspace(keyspace);
        Assertions.assertThat(ksm).isNotNull();
        for (int i = 0; i < tableCount; ++i) {
            String table = "tbl" + i;
            ((ControlConnection)Mockito.verify((Object)this.controlConnection, (VerificationMode)Mockito.never())).refreshSchema(SchemaElement.TABLE, keyspace, table, null);
            Assertions.assertThat(ksm.getTable(table)).isNotNull();
        }
    }

    @Test(groups={"short"})
    @DseVersion(value="5.0.0")
    public void should_debounce_and_coalesce_multiple_alter_events_on_same_table_into_refresh_table() throws Exception {
        if (this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"2.2")) >= 0) {
            throw new SkipException("Disabled in Cassandra 2.2+ because of CASSANDRA-9996");
        }
        String keyspace = TestUtils.generateIdentifier("ks_");
        String table = "tbl1";
        String comment = "I am changing this table.";
        String columnName = "added_column";
        this.session2.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace, 1));
        this.session2.execute(String.format("CREATE TABLE %s (k text PRIMARY KEY, t text, i int, f float)", keyspace + "." + table));
        Mockito.reset((Object[])new ControlConnection[]{this.controlConnection});
        Mockito.reset((Object[])new SchemaChangeListener[]{this.listener});
        this.session().execute(String.format("ALTER TABLE %s.%s WITH comment = '%s'", keyspace, table, comment));
        this.session().execute(String.format("ALTER TABLE %s.%s ADD %s int", keyspace, table, columnName));
        ArgumentCaptor original = ArgumentCaptor.forClass(TableMetadata.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(TableMetadata.class);
        ((SchemaChangeListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.timeout((long)10000L).times(1))).onTableChanged((TableMetadata)captor.capture(), (TableMetadata)original.capture());
        Assertions.assertThat((TableMetadata)captor.getValue()).hasName(table).isInKeyspace(keyspace).hasColumn(columnName).hasComment(comment);
        Assertions.assertThat((TableMetadata)original.getValue()).hasName(table).isInKeyspace(keyspace).hasNoColumn(columnName).doesNotHaveComment(comment);
        ((ControlConnection)Mockito.verify((Object)this.controlConnection, (VerificationMode)Mockito.times((int)1))).refreshSchema(SchemaElement.TABLE, keyspace, table, Collections.emptyList());
        KeyspaceMetadata ksm = this.cluster2.getMetadata().getKeyspace(keyspace);
        Assertions.assertThat(ksm).isNotNull();
        TableMetadata tm = ksm.getTable(table);
        Assertions.assertThat(tm).hasName(table).isInKeyspace(keyspace).hasColumn(columnName).hasComment(comment);
    }

    @Test(groups={"short"})
    public void should_debounce_and_coalesce_multiple_keyspace_creates_into_refresh_entire_schema() throws Exception {
        int i;
        String prefix = TestUtils.generateIdentifier("ks_");
        for (i = 0; i < 3; ++i) {
            this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", prefix + i, 1));
            Assertions.assertThat(this.cluster().getMetadata().getKeyspace(prefix + i)).isNotNull();
        }
        ((SchemaChangeListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.timeout((long)15000L).times(3))).onKeyspaceAdded((KeyspaceMetadata)Mockito.any(KeyspaceMetadata.class));
        ((ControlConnection)Mockito.verify((Object)this.controlConnection, (VerificationMode)Mockito.times((int)1))).refreshSchema(null, null, null, null);
        for (i = 0; i < 3; ++i) {
            KeyspaceMetadata ksm = this.cluster2.getMetadata().getKeyspace(prefix + i);
            ((KeyspaceMetadataAssert)Assertions.assertThat(ksm).isNotNull()).hasName(prefix + i);
        }
    }

    @Test(groups={"short"})
    public void should_refresh_when_max_pending_requests_reached() throws Exception {
        int i;
        String prefix = TestUtils.generateIdentifier("ks_");
        for (i = 0; i < 5; ++i) {
            this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", prefix + i, 1));
            Assertions.assertThat(this.cluster().getMetadata().getKeyspace(prefix + i)).isNotNull();
        }
        ((SchemaChangeListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.timeout((long)25000L).times(5))).onKeyspaceAdded((KeyspaceMetadata)Mockito.any(KeyspaceMetadata.class));
        ((ControlConnection)Mockito.verify((Object)this.controlConnection, (VerificationMode)Mockito.times((int)1))).refreshSchema(null, null, null, null);
        for (i = 0; i < 5; ++i) {
            KeyspaceMetadata ksm = this.cluster2.getMetadata().getKeyspace(prefix + i);
            ((KeyspaceMetadataAssert)Assertions.assertThat(ksm).isNotNull()).hasName(prefix + i);
        }
    }
}

