/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.SSLTestBase;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import org.testng.annotations.Test;

@CCMConfig(auth={true})
public class SSLAuthenticatedEncryptionTest
extends SSLTestBase {
    @Test(groups={"short"}, dataProvider="sslImplementation", dataProviderClass=SSLTestBase.class)
    public void should_connect_with_ssl_with_client_auth_and_node_requires_auth(SSLTestBase.SslImplementation sslImplementation) throws Exception {
        this.connectWithSSLOptions(this.getSSLOptions(sslImplementation, true, true));
    }

    @Test(groups={"short"}, dataProvider="sslImplementation", dataProviderClass=SSLTestBase.class, expectedExceptions={NoHostAvailableException.class})
    public void should_not_connect_without_client_auth_but_node_requires_auth(SSLTestBase.SslImplementation sslImplementation) throws Exception {
        this.connectWithSSLOptions(this.getSSLOptions(sslImplementation, false, true));
    }

    @Test(groups={"isolated"})
    public void should_use_system_properties_with_default_ssl_options() throws Exception {
        System.setProperty("javax.net.ssl.keyStore", CCMBridge.DEFAULT_CLIENT_KEYSTORE_FILE.getAbsolutePath());
        System.setProperty("javax.net.ssl.keyStorePassword", "cassandra1sfun");
        System.setProperty("javax.net.ssl.trustStore", CCMBridge.DEFAULT_CLIENT_TRUSTSTORE_FILE.getAbsolutePath());
        System.setProperty("javax.net.ssl.trustStorePassword", "cassandra1sfun");
        try {
            this.connectWithSSL();
        }
        finally {
            try {
                System.clearProperty("javax.net.ssl.keyStore");
                System.clearProperty("javax.net.ssl.keyStorePassword");
                System.clearProperty("javax.net.ssl.trustStore");
                System.clearProperty("javax.net.ssl.trustStorePassword");
            }
            catch (SecurityException securityException) {}
        }
    }
}

