/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Token;
import com.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import java.util.List;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class RPTokenFactoryTest {
    Token.Factory factory = Token.RPToken.FACTORY;

    @Test(groups={"unit"})
    public void should_hash_consistently() {
        ByteBuffer byteBuffer = Bytes.fromHexString((String)"0xCAFEBABE");
        Token tokenA = this.factory.hash(byteBuffer);
        Token tokenB = this.factory.hash(byteBuffer);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)tokenA).isEqualTo((Object)this.factory.fromString("59959303159920881837560881824507314222"))).isEqualTo((Object)tokenB);
    }

    @Test(groups={"unit"})
    public void should_split_range() {
        List splits = this.factory.split(this.factory.fromString("0"), this.factory.fromString("127605887595351923798765477786913079296"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("42535295865117307932921825928971026432"), this.factory.fromString("85070591730234615865843651857942052864")});
    }

    @Test(groups={"unit"})
    public void should_split_range_that_wraps_around_the_ring() {
        List splits = this.factory.split(this.factory.fromString("127605887595351923798765477786913079296"), this.factory.fromString("85070591730234615865843651857942052864"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("0"), this.factory.fromString("42535295865117307932921825928971026432")});
    }

    @Test(groups={"unit"})
    public void should_split_range_producing_empty_splits_near_ring_end() {
        Token minToken = this.factory.fromString("-1");
        Token maxToken = this.factory.fromString("170141183460469231731687303715884105728");
        List splits = this.factory.split(maxToken, minToken, 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{maxToken, maxToken});
        splits = this.factory.split(minToken, this.factory.fromString("0"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("0"), this.factory.fromString("0")});
    }

    @Test(groups={"unit"})
    public void should_split_whole_ring() {
        List splits = this.factory.split(this.factory.fromString("-1"), this.factory.fromString("-1"), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{this.factory.fromString("56713727820156410577229101238628035242"), this.factory.fromString("113427455640312821154458202477256070485")});
    }
}

