/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolVersion;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class PoolingOptionsTest {
    @Test(groups={"unit"})
    public void should_initialize_to_v2_defaults_if_v2_or_below() {
        PoolingOptions options = new PoolingOptions();
        options.setProtocolVersion(ProtocolVersion.V1);
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(2);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(8);
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.REMOTE)).isEqualTo(1);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.REMOTE)).isEqualTo(2);
        Assertions.assertThat((int)options.getNewConnectionThreshold(HostDistance.LOCAL)).isEqualTo(100);
        Assertions.assertThat((int)options.getNewConnectionThreshold(HostDistance.REMOTE)).isEqualTo(100);
        Assertions.assertThat((int)options.getMaxRequestsPerConnection(HostDistance.LOCAL)).isEqualTo(128);
        Assertions.assertThat((int)options.getMaxRequestsPerConnection(HostDistance.REMOTE)).isEqualTo(128);
    }

    @Test(groups={"unit"})
    public void should_initialize_to_v3_defaults_if_v3_or_above() {
        PoolingOptions options = new PoolingOptions();
        options.setProtocolVersion(ProtocolVersion.V3);
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(1);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(1);
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.REMOTE)).isEqualTo(1);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.REMOTE)).isEqualTo(1);
        Assertions.assertThat((int)options.getNewConnectionThreshold(HostDistance.LOCAL)).isEqualTo(800);
        Assertions.assertThat((int)options.getNewConnectionThreshold(HostDistance.REMOTE)).isEqualTo(200);
        Assertions.assertThat((int)options.getMaxRequestsPerConnection(HostDistance.LOCAL)).isEqualTo(1024);
        Assertions.assertThat((int)options.getMaxRequestsPerConnection(HostDistance.REMOTE)).isEqualTo(256);
    }

    @Test(groups={"unit"})
    public void should_enforce_invariants_once_protocol_version_known() {
        PoolingOptions options = new PoolingOptions().setCoreConnectionsPerHost(HostDistance.LOCAL, 3);
        options.setCoreConnectionsPerHost(HostDistance.LOCAL, 3);
        options.setProtocolVersion(ProtocolVersion.V2);
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(3);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(8);
        options = new PoolingOptions().setCoreConnectionsPerHost(HostDistance.LOCAL, 3);
        try {
            options.setProtocolVersion(ProtocolVersion.V3);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        options = new PoolingOptions().setMaxRequestsPerConnection(HostDistance.LOCAL, 5000);
        options.setProtocolVersion(ProtocolVersion.V3);
        Assertions.assertThat((int)options.getMaxRequestsPerConnection(HostDistance.LOCAL)).isEqualTo(5000);
        options = new PoolingOptions().setMaxRequestsPerConnection(HostDistance.LOCAL, 5000);
        try {
            options.setProtocolVersion(ProtocolVersion.V2);
            Assertions.fail((String)"Expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test(groups={"unit"})
    public void should_set_core_and_max_connections_simultaneously() {
        PoolingOptions options = new PoolingOptions();
        options.setProtocolVersion(ProtocolVersion.V2);
        options.setConnectionsPerHost(HostDistance.LOCAL, 10, 15);
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(10);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(15);
    }

    @Test(groups={"unit"})
    public void should_leave_connection_options_unset_until_protocol_version_known() {
        PoolingOptions options = new PoolingOptions();
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)options.getCoreConnectionsPerHost(HostDistance.REMOTE)).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.LOCAL)).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)options.getMaxConnectionsPerHost(HostDistance.REMOTE)).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)options.getNewConnectionThreshold(HostDistance.LOCAL)).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)options.getNewConnectionThreshold(HostDistance.REMOTE)).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)options.getMaxRequestsPerConnection(HostDistance.LOCAL)).isEqualTo(Integer.MIN_VALUE);
        Assertions.assertThat((int)options.getMaxRequestsPerConnection(HostDistance.REMOTE)).isEqualTo(Integer.MIN_VALUE);
    }

    @Test(groups={"unit"})
    public void should_reject_negative_connection_options_even_when_protocol_version_unknown() {
        PoolingOptions options = new PoolingOptions();
        try {
            options.setCoreConnectionsPerHost(HostDistance.LOCAL, -1);
            Assertions.fail((String)"expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setMaxConnectionsPerHost(HostDistance.LOCAL, -1);
            Assertions.fail((String)"expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setConnectionsPerHost(HostDistance.LOCAL, -1, 1);
            Assertions.fail((String)"expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setConnectionsPerHost(HostDistance.LOCAL, -2, -1);
            Assertions.fail((String)"expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setNewConnectionThreshold(HostDistance.LOCAL, -1);
            Assertions.fail((String)"expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            options.setMaxRequestsPerConnection(HostDistance.LOCAL, -1);
            Assertions.fail((String)"expected an IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

