/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.QueryOptions;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.Test;

@CCMConfig(dirtiesContext={true}, createCluster={false})
public class NodeRefreshDebouncerTest
extends CCMTestsSupport {
    @Test(groups={"long"})
    public void should_call_onAdd_with_bootstrap_stop_start() {
        int refreshNodeInterval = 30000;
        QueryOptions queryOptions = new QueryOptions().setRefreshNodeIntervalMillis(refreshNodeInterval);
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withQueryOptions(queryOptions).build());
        cluster.connect();
        Host.StateListener listener = (Host.StateListener)Mockito.mock(Host.StateListener.class);
        cluster.register(listener);
        this.ccm().add(2);
        this.ccm().start(2);
        this.ccm().stop(2);
        this.ccm().start(2);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Host.class);
        ((Host.StateListener)Mockito.verify((Object)listener)).onRegister(cluster);
        long addDelay = (long)refreshNodeInterval + TimeUnit.MILLISECONDS.convert(Cluster.NEW_NODE_DELAY_SECONDS, TimeUnit.SECONDS);
        ((Host.StateListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)addDelay))).onAdd((Host)captor.capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
        Assertions.assertThat((String)((Host)captor.getValue()).getState()).isEqualTo((Object)"UP");
        Assertions.assertThat(cluster).host(2).hasState(Host.State.UP);
    }
}

