/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.QueryOptions;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(dirtiesContext={true}, createKeyspace={false})
public class NodeListRefreshDebouncerTest
extends CCMTestsSupport {
    private static final int DEBOUNCE_TIME = 2000;
    private Cluster cluster2;
    private ControlConnection controlConnection;

    @BeforeMethod(groups={"short"})
    public void setup() {
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setRefreshNodeListIntervalMillis(2000);
        queryOptions.setMaxPendingRefreshNodeListRequests(5);
        queryOptions.setRefreshSchemaIntervalMillis(0);
        this.cluster2 = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withQueryOptions(queryOptions).build());
        this.cluster2.init();
        this.cluster2.manager.controlConnection = this.controlConnection = (ControlConnection)Mockito.spy((Object)this.cluster2.manager.controlConnection);
        Mockito.reset((Object[])new ControlConnection[]{this.controlConnection});
    }

    @Test(groups={"short"})
    public void should_refresh_when_max_pending_requests_reached() {
        for (int i = 0; i < 5; ++i) {
            this.cluster2.manager.submitNodeListRefresh();
        }
        ((ControlConnection)Mockito.verify((Object)this.controlConnection, (VerificationMode)Mockito.timeout((long)2000L))).refreshNodeListAndTokenMap();
    }
}

