/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.RemoteEndpointAwareJdkSSLOptions;
import com.datastax.driver.core.RemoteEndpointAwareNettySSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SSLTestBase;
import com.datastax.driver.core.TestUtils;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import java.net.Socket;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedTrustManager;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(auth={false})
public class Jdk8SSLEncryptionTest
extends SSLTestBase {
    @Test(groups={"short"}, dataProvider="sslImplementation", dataProviderClass=SSLTestBase.class)
    public void should_pass_peer_address_to_engine(SSLTestBase.SslImplementation sslImplementation) throws Exception {
        String expectedPeerHost = TestUtils.IP_PREFIX + "1";
        int expectedPeerPort = this.ccm().getBinaryPort();
        EngineInspectingTrustManagerFactory tmf = new EngineInspectingTrustManagerFactory(expectedPeerHost, expectedPeerPort);
        RemoteEndpointAwareNettySSLOptions options = null;
        switch (sslImplementation) {
            case JDK: {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
                SSLParameters parameters = sslContext.getDefaultSSLParameters();
                parameters.setEndpointIdentificationAlgorithm("HTTPS");
                options = RemoteEndpointAwareJdkSSLOptions.builder().withSSLContext(sslContext).build();
                break;
            }
            case NETTY_OPENSSL: {
                SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager((TrustManagerFactory)tmf);
                options = new RemoteEndpointAwareNettySSLOptions(builder.build());
            }
        }
        this.connectWithSSLOptions((SSLOptions)options);
    }

    static class EngineInspectingTrustManagerFactorySpi
    extends TrustManagerFactorySpi {
        String expectedPeerHost;
        int expectedPeerPort;
        private final TrustManager tm = new X509ExtendedTrustManager(){

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType, SSLEngine sslEngine) throws CertificateException {
                String peerHost = sslEngine.getPeerHost();
                int peerPort = sslEngine.getPeerPort();
                if (peerHost == null || !peerHost.equals(EngineInspectingTrustManagerFactorySpi.this.expectedPeerHost)) {
                    throw new CertificateException(String.format("Expected SSLEngine.getPeerHost() (%s) to equal (%s)", peerHost, EngineInspectingTrustManagerFactorySpi.this.expectedPeerHost));
                }
                if (peerPort != EngineInspectingTrustManagerFactorySpi.this.expectedPeerPort) {
                    throw new CertificateException(String.format("Expected SSLEngine.getPeerPort() (%d) to equal (%d)", peerPort, EngineInspectingTrustManagerFactorySpi.this.expectedPeerPort));
                }
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) throws CertificateException {
                throw new UnsupportedOperationException("TrustManger is for establishing server trust only.");
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
                throw new UnsupportedOperationException("TrustManger is for establishing server trust only.");
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                throw new UnsupportedOperationException("TrustManger is for establishing server trust only.");
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };

        EngineInspectingTrustManagerFactorySpi(String expectedPeerHost, int expectedPeerPort) {
            this.expectedPeerHost = expectedPeerHost;
            this.expectedPeerPort = expectedPeerPort;
        }

        @Override
        protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        }

        @Override
        protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        }

        @Override
        protected TrustManager[] engineGetTrustManagers() {
            return new TrustManager[]{this.tm};
        }
    }

    static class EngineInspectingTrustManagerFactory
    extends TrustManagerFactory {
        private static final Provider provider = new Provider("", 0.0, ""){};
        final EngineInspectingTrustManagerFactorySpi spi;

        EngineInspectingTrustManagerFactory(String expectedPeerHost, int expectedPeerPort) {
            this(new EngineInspectingTrustManagerFactorySpi(expectedPeerHost, expectedPeerPort));
        }

        private EngineInspectingTrustManagerFactory(EngineInspectingTrustManagerFactorySpi spi) {
            super(spi, provider, "EngineInspectingTrustManagerFactory");
            this.spi = spi;
        }
    }
}

