/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMAccess;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMCache;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.DseVersion;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.util.Collections;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.testng.annotations.Test;

public class HostMetadataIntegrationTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"long"}, enabled=false)
    @DseVersion(value="5.0.0")
    public void test_mixed_dse_workload() {
        CCMBridge.Builder builder = CCMBridge.builder().withNodes(3).withDSE(true).withWorkload(2, "solr").withWorkload(3, "spark");
        CCMAccess ccm = CCMCache.get(builder);
        VersionNumber version = ccm.getDSEVersion();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{ccm.addressOfNode(1).getAddress()}).withPort(ccm.getBinaryPort()).build();
        try {
            cluster.connect();
            Assertions.assertThat(cluster).host(1).hasWorkload("Cassandra").hasDseVersion(version);
            Assertions.assertThat(cluster).host(2).hasWorkload("Search").hasDseVersion(version);
            Assertions.assertThat(cluster).host(3).hasWorkload("Analytics").hasDseVersion(version);
        }
        finally {
            cluster.close();
            ccm.close();
        }
    }

    @Test(groups={"short"})
    public void should_parse_dse_workload_and_version_if_available() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(5).forcePeerInfo(1, 1, "workload", "Analytics").forcePeerInfo(1, 1, "dse_version", "4.8.4").forcePeerInfo(1, 3, "workload", "Solr").forcePeerInfo(1, 3, "dse_version", "4.8.4").forcePeerInfo(1, 4, "workload", "Cassandra").forcePeerInfo(1, 4, "dse_version", "4.8.4").forcePeerInfo(1, 5, "workload", "AmazingNewFeature").forcePeerInfo(1, 5, "dse_version", "5.0.0").build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat(cluster).host(1).hasWorkload("Analytics").hasDseVersion(VersionNumber.parse((String)"4.8.4"));
            Assertions.assertThat(cluster).host(2).hasNoWorkload().hasNoDseVersion();
            Assertions.assertThat(cluster).host(3).hasWorkload("Solr").hasDseVersion(VersionNumber.parse((String)"4.8.4"));
            Assertions.assertThat(cluster).host(4).hasWorkload("Cassandra").hasDseVersion(VersionNumber.parse((String)"4.8.4"));
            Assertions.assertThat(cluster).host(5).hasWorkload("AmazingNewFeature").hasDseVersion(VersionNumber.parse((String)"5.0.0"));
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    @Test(groups={"short"})
    public void should_not_parse_dse_workload_and_version_if_not_present_in_local_table() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(2).forcePeerInfo(1, 2, "workload", "Analytics").forcePeerInfo(1, 2, "dse_version", "4.8.4").build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat(cluster).host(1).hasNoWorkload().hasNoDseVersion();
            Assertions.assertThat(cluster).host(2).hasWorkload("Analytics").hasDseVersion(VersionNumber.parse((String)"4.8.4"));
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_log_warning_when_invalid_version_used_for_dse_version() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(1).forcePeerInfo(1, 1, "workload", "Analytics").forcePeerInfo(1, 1, "dse_version", "Invalid Version!").build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        MemoryAppender logs = new MemoryAppender();
        Logger logger = Logger.getLogger(Host.class);
        Level originalLoggerLevel = logger.getLevel();
        logger.setLevel(Level.WARN);
        logger.addAppender((Appender)logs);
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat((String)logs.get()).contains(new CharSequence[]{"Error parsing DSE version Invalid Version!. This shouldn't have happened"});
            Assertions.assertThat(cluster).host(1).hasNoDseVersion().hasWorkload("Analytics");
        }
        finally {
            logger.removeAppender((Appender)logs);
            logger.setLevel(originalLoggerLevel);
            cluster.close();
            scassandraCluster.stop();
        }
    }

    @Test(groups={"short"})
    public void should_parse_dse_graph_if_available() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(3).forcePeerInfo(1, 1, "graph", true).forcePeerInfo(1, 3, "graph", false).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat(cluster).host(1).hasDseGraph();
            Assertions.assertThat(cluster).host(2).hasNoDseGraph();
            Assertions.assertThat(cluster).host(3).hasNoDseGraph();
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    @Test(groups={"short"})
    public void should_not_parse_dse_graph_if_not_present_in_local_table() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(2).forcePeerInfo(1, 2, "graph", true).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat(cluster).host(1).hasNoDseGraph();
            Assertions.assertThat(cluster).host(2).hasDseGraph();
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_set_broadcast_address_for_all_nodes() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(3).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            for (int i = 1; i <= scassandraCluster.nodes().size(); ++i) {
                Assertions.assertThat(cluster).host(i).hasBroadcastAddress(TestUtils.addressOfNode(i));
            }
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_set_listen_address_if_available() {
        InetAddress listenAddress = TestUtils.addressOfNode(10);
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(3).forcePeerInfo(1, 2, "listen_address", listenAddress).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat(cluster).host(1).hasListenAddress(TestUtils.addressOfNode(1));
            Assertions.assertThat(cluster).host(2).hasListenAddress(listenAddress);
            Assertions.assertThat(cluster).host(3).hasNoListenAddress();
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    @Test(groups={"short"})
    public void should_parse_dse_workloads_if_available() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(5).forcePeerInfo(1, 1, "workloads", Collections.singleton("Cassandra")).forcePeerInfo(1, 2, "workloads", Collections.singleton("Search")).forcePeerInfo(1, 3, "workloads", Sets.newHashSet((Object[])new String[]{"Search", "Analytics", "Graph"})).forcePeerInfo(1, 4, "workloads", Collections.emptySet()).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat(cluster).host(1).hasWorkload("Cassandra");
            Assertions.assertThat(cluster).host(2).hasWorkload("Search");
            Assertions.assertThat(cluster).host(3).hasWorkload("Search", "Analytics", "Graph");
            Assertions.assertThat(cluster).host(4).hasNoWorkload();
            Assertions.assertThat(cluster).host(5).hasNoWorkload();
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    @Test
    public void should_parse_node_ports_if_available() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(3).forcePeerInfo(1, 2, "server_id", "theserverId2").forcePeerInfo(1, 2, "native_transport_port", 11001).forcePeerInfo(1, 2, "native_transport_port_ssl", 11002).forcePeerInfo(1, 2, "storage_port", 11003).forcePeerInfo(1, 2, "storage_port_ssl", 11004).forcePeerInfo(1, 2, "jmx_port", 11005).forcePeerInfo(1, 3, "server_id", "theserverId3").forcePeerInfo(1, 3, "native_transport_port", 12001).forcePeerInfo(1, 3, "native_transport_port_ssl", 12002).forcePeerInfo(1, 3, "storage_port", 12003).forcePeerInfo(1, 3, "storage_port_ssl", 12004).forcePeerInfo(1, 3, "jmx_port", 12005).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            Assertions.assertThat(cluster).host(1).hasServerId("00:00:00:00:00:00");
            Assertions.assertThat(cluster).host(1).hasNativeTransportPort(9042);
            Assertions.assertThat(cluster).host(1).hasNativeTransportPortSsl(9142);
            Assertions.assertThat(cluster).host(1).hasStoragePort(7000);
            Assertions.assertThat(cluster).host(1).hasStoragePortSsl(7100);
            Assertions.assertThat(cluster).host(1).hasJmxPort(7199);
            Assertions.assertThat(cluster).host(2).hasServerId("theserverId2");
            Assertions.assertThat(cluster).host(2).hasNativeTransportPort(11001);
            Assertions.assertThat(cluster).host(2).hasNativeTransportPortSsl(11002);
            Assertions.assertThat(cluster).host(2).hasStoragePort(11003);
            Assertions.assertThat(cluster).host(2).hasStoragePortSsl(11004);
            Assertions.assertThat(cluster).host(2).hasJmxPort(11005);
            Assertions.assertThat(cluster).host(3).hasServerId("theserverId3");
            Assertions.assertThat(cluster).host(3).hasNativeTransportPort(12001);
            Assertions.assertThat(cluster).host(3).hasNativeTransportPortSsl(12002);
            Assertions.assertThat(cluster).host(3).hasStoragePort(12003);
            Assertions.assertThat(cluster).host(3).hasStoragePortSsl(12004);
            Assertions.assertThat(cluster).host(3).hasJmxPort(12005);
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }
}

