/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;

public class FakeHost {
    final String address;
    private final int port;
    private final Behavior behavior;
    private final ExecutorService executor;

    FakeHost(String address, int port, Behavior behavior) {
        this.address = address;
        this.port = port;
        this.behavior = behavior;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public void start() {
        this.executor.execute(new AcceptClientAndWait(this.address, this.port, this.behavior));
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    private static class AcceptClientAndWait
    implements Runnable {
        private final String address;
        private final int port;
        private final Behavior behavior;

        public AcceptClientAndWait(String address, int port, Behavior behavior) {
            this.address = address;
            this.port = port;
            this.behavior = behavior;
        }

        @Override
        public void run() {
            ServerSocket server = null;
            Socket client = null;
            try {
                InetAddress bindAddress = InetAddress.getByName(this.address);
                int backlog = this.behavior == Behavior.THROWING_CONNECT_TIMEOUTS ? 1 : -1;
                server = new ServerSocket(this.port, backlog, bindAddress);
                if (this.behavior == Behavior.THROWING_CONNECT_TIMEOUTS) {
                    client = new Socket();
                    client.connect(server.getLocalSocketAddress());
                }
                TimeUnit.MINUTES.sleep(10L);
                Assertions.fail((String)"Mock host wasn't expected to live more than 10 minutes");
            }
            catch (IOException e) {
                Assertions.fail((String)"Unexpected I/O exception", (Throwable)e);
            }
            catch (InterruptedException e) {
                try {
                    if (client != null) {
                        client.close();
                    }
                    server.close();
                }
                catch (IOException e1) {
                    Assertions.fail((String)"Unexpected error while closing sockets", (Throwable)e);
                }
            }
        }
    }

    public static enum Behavior {
        THROWING_CONNECT_TIMEOUTS,
        THROWING_OPERATION_TIMEOUTS;

    }
}

