/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Duration;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class DurationTest {
    @Test(groups={"unit"})
    public void testFromStringWithStandardPattern() {
        Assertions.assertThat((Object)Duration.from((String)"1y2mo")).isEqualTo((Object)Duration.newInstance((int)14, (int)0, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"-1y2mo")).isEqualTo((Object)Duration.newInstance((int)-14, (int)0, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"1Y2MO")).isEqualTo((Object)Duration.newInstance((int)14, (int)0, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"2w")).isEqualTo((Object)Duration.newInstance((int)0, (int)14, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"2d10h")).isEqualTo((Object)Duration.newInstance((int)0, (int)2, (long)36000000000000L));
        Assertions.assertThat((Object)Duration.from((String)"2d")).isEqualTo((Object)Duration.newInstance((int)0, (int)2, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"30h")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)108000000000000L));
        Assertions.assertThat((Object)Duration.from((String)"30h20m")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)109200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"20m")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)1200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"56s")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)56000000000L));
        Assertions.assertThat((Object)Duration.from((String)"567ms")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)567000000L));
        Assertions.assertThat((Object)Duration.from((String)"1950us")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)1950000L));
        Assertions.assertThat((Object)Duration.from((String)"1950\u00b5s")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)1950000L));
        Assertions.assertThat((Object)Duration.from((String)"1950000ns")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)1950000L));
        Assertions.assertThat((Object)Duration.from((String)"1950000NS")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)1950000L));
        Assertions.assertThat((Object)Duration.from((String)"-1950000ns")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)-1950000L));
        Assertions.assertThat((Object)Duration.from((String)"1y3mo2h10m")).isEqualTo((Object)Duration.newInstance((int)15, (int)0, (long)7800000000000L));
    }

    @Test(groups={"unit"})
    public void testFromStringWithIso8601Pattern() {
        Assertions.assertThat((Object)Duration.from((String)"P1Y2D")).isEqualTo((Object)Duration.newInstance((int)12, (int)2, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P1Y2M")).isEqualTo((Object)Duration.newInstance((int)14, (int)0, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P2W")).isEqualTo((Object)Duration.newInstance((int)0, (int)14, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P1YT2H")).isEqualTo((Object)Duration.newInstance((int)12, (int)0, (long)7200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"-P1Y2M")).isEqualTo((Object)Duration.newInstance((int)-14, (int)0, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P2D")).isEqualTo((Object)Duration.newInstance((int)0, (int)2, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"PT30H")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)108000000000000L));
        Assertions.assertThat((Object)Duration.from((String)"PT30H20M")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)109200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"PT20M")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)1200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"PT56S")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)56000000000L));
        Assertions.assertThat((Object)Duration.from((String)"P1Y3MT2H10M")).isEqualTo((Object)Duration.newInstance((int)15, (int)0, (long)7800000000000L));
    }

    @Test(groups={"unit"})
    public void testFromStringWithIso8601AlternativePattern() {
        Assertions.assertThat((Object)Duration.from((String)"P0001-00-02T00:00:00")).isEqualTo((Object)Duration.newInstance((int)12, (int)2, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P0001-02-00T00:00:00")).isEqualTo((Object)Duration.newInstance((int)14, (int)0, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P0001-00-00T02:00:00")).isEqualTo((Object)Duration.newInstance((int)12, (int)0, (long)7200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"-P0001-02-00T00:00:00")).isEqualTo((Object)Duration.newInstance((int)-14, (int)0, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P0000-00-02T00:00:00")).isEqualTo((Object)Duration.newInstance((int)0, (int)2, (long)0L));
        Assertions.assertThat((Object)Duration.from((String)"P0000-00-00T30:00:00")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)108000000000000L));
        Assertions.assertThat((Object)Duration.from((String)"P0000-00-00T30:20:00")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)109200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"P0000-00-00T00:20:00")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)1200000000000L));
        Assertions.assertThat((Object)Duration.from((String)"P0000-00-00T00:00:56")).isEqualTo((Object)Duration.newInstance((int)0, (int)0, (long)56000000000L));
        Assertions.assertThat((Object)Duration.from((String)"P0001-03-00T02:10:00")).isEqualTo((Object)Duration.newInstance((int)15, (int)0, (long)7800000000000L));
    }

    @Test(groups={"unit"})
    public void testInvalidDurations() {
        this.assertInvalidDuration("9223372036854775807d", "Invalid duration. The total number of days must be less or equal to 2147483647");
        this.assertInvalidDuration("2\u00b5", "Unable to convert '2\u00b5' to a duration");
        this.assertInvalidDuration("-2\u00b5", "Unable to convert '2\u00b5' to a duration");
        this.assertInvalidDuration("12.5s", "Unable to convert '12.5s' to a duration");
        this.assertInvalidDuration("2m12.5s", "Unable to convert '2m12.5s' to a duration");
        this.assertInvalidDuration("2m-12s", "Unable to convert '2m-12s' to a duration");
        this.assertInvalidDuration("12s3s", "Invalid duration. The seconds are specified multiple times");
        this.assertInvalidDuration("12s3m", "Invalid duration. The seconds should be after minutes");
        this.assertInvalidDuration("1Y3M4D", "Invalid duration. The minutes should be after days");
        this.assertInvalidDuration("P2Y3W", "Unable to convert 'P2Y3W' to a duration");
        this.assertInvalidDuration("P0002-00-20", "Unable to convert 'P0002-00-20' to a duration");
    }

    public void assertInvalidDuration(String duration, String expectedErrorMessage) {
        try {
            Duration.from((String)duration);
            Assertions.fail((String)"Expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)expectedErrorMessage);
        }
    }
}

