/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.assertj.core.api.Fail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionChecker {
    private static final int DEFAULT_PERIOD_MILLIS = 500;
    private static final int DEFAULT_TIMEOUT_MILLIS = 60000;
    private static final Logger logger = LoggerFactory.getLogger(ConditionChecker.class);
    private final Object input;
    private final Predicate<Object> predicate;
    private final Lock lock;
    private final Condition condition;
    private final Timer timer;

    public static ConditionCheckerBuilder check() {
        return new ConditionCheckerBuilder();
    }

    public <T> ConditionChecker(T input, Predicate<? super T> predicate, long period, TimeUnit periodUnit) {
        this.input = input;
        this.predicate = predicate;
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.timer = new Timer("condition-checker", true);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                ConditionChecker.this.checkCondition();
            }
        }, 0L, periodUnit.toMillis(period));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await(long timeout, TimeUnit unit) {
        boolean interrupted = false;
        long nanos = unit.toNanos(timeout);
        this.lock.lock();
        try {
            while (!this.evalCondition()) {
                if (nanos <= 0L) {
                    Fail.fail((String)String.format("Timeout after %s %s while waiting for condition", timeout, unit.toString().toLowerCase()));
                }
                try {
                    nanos = this.condition.awaitNanos(nanos);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
        }
        finally {
            this.timer.cancel();
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void checkCondition() {
        this.lock.lock();
        try {
            if (this.evalCondition()) {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean evalCondition() {
        return this.predicate.apply(this.input);
    }

    public static class ConditionCheckerBuilder {
        private long timeout = 60000L;
        private TimeUnit timeoutUnit = TimeUnit.MILLISECONDS;
        private long period = 500L;
        private TimeUnit periodUnit = TimeUnit.MILLISECONDS;
        private Object input;
        private Predicate<?> predicate;

        public ConditionCheckerBuilder every(long period, TimeUnit unit) {
            this.period = period;
            this.periodUnit = unit;
            return this;
        }

        public ConditionCheckerBuilder every(long periodMillis) {
            this.period = periodMillis;
            this.periodUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public ConditionCheckerBuilder before(long timeout, TimeUnit unit) {
            this.timeout = timeout;
            this.timeoutUnit = unit;
            return this;
        }

        public ConditionCheckerBuilder before(long timeoutMillis) {
            this.timeout = timeoutMillis;
            this.timeoutUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public <T> ConditionCheckerBuilder that(T input, Predicate<? super T> predicate) {
            this.input = input;
            this.predicate = predicate;
            return this;
        }

        public ConditionCheckerBuilder that(final Callable<Boolean> condition) {
            this.input = null;
            this.predicate = new Predicate<Void>(){

                public boolean apply(Void input) {
                    try {
                        return (Boolean)condition.call();
                    }
                    catch (Exception e) {
                        logger.error("Evaluation of condition threw exception", (Throwable)e);
                        return false;
                    }
                }
            };
            return this;
        }

        public void becomesTrue() {
            new ConditionChecker(this.input, this.predicate, this.period, this.periodUnit).await(this.timeout, this.timeoutUnit);
        }

        public void becomesFalse() {
            this.predicate = Predicates.not(this.predicate);
            new ConditionChecker(this.input, this.predicate, this.period, this.periodUnit).await(this.timeout, this.timeoutUnit);
        }
    }
}

