/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CountingReconnectionPolicy;
import com.datastax.driver.core.FakeHost;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostAssert;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scassandra.Scassandra;
import org.scassandra.http.client.PrimingClient;
import org.scassandra.http.client.PrimingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

public class ClusterInitTest {
    private static final Logger logger = LoggerFactory.getLogger(ClusterInitTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_handle_failing_or_missing_contact_points() throws UnknownHostException {
        Cluster cluster = null;
        Scassandra scassandra = null;
        ArrayList failingHosts = Lists.newArrayList();
        try {
            scassandra = TestUtils.createScassandraServer();
            scassandra.start();
            int port = scassandra.getBinaryPort();
            for (int i = 2; i <= 5; ++i) {
                FakeHost failingHost = new FakeHost(TestUtils.ipOfNode(i), port, FakeHost.Behavior.THROWING_CONNECT_TIMEOUTS);
                failingHosts.add(failingHost);
                failingHost.start();
            }
            String missingHostAddress = TestUtils.ipOfNode(6);
            this.primePeerRows(scassandra, failingHosts);
            logger.info("Environment is set up, starting test");
            long start = System.nanoTime();
            SocketOptions socketOptions = (SocketOptions)Mockito.spy((Object)new SocketOptions());
            ConstantReconnectionPolicy reconnectionPolicy = new ConstantReconnectionPolicy(3600000L);
            PoolingOptions poolingOptions = new PoolingOptions().setConnectionsPerHost(HostDistance.LOCAL, 1, 1);
            ProtocolVersion protocolVersion = ProtocolVersion.V4;
            cluster = Cluster.builder().withPort(scassandra.getBinaryPort()).addContactPoints(new String[]{TestUtils.ipOfNode(1), ((FakeHost)failingHosts.get((int)0)).address, ((FakeHost)failingHosts.get((int)1)).address, ((FakeHost)failingHosts.get((int)2)).address, ((FakeHost)failingHosts.get((int)3)).address, missingHostAddress}).withProtocolVersion(protocolVersion).withSocketOptions(socketOptions).withReconnectionPolicy((ReconnectionPolicy)reconnectionPolicy).withPoolingOptions(poolingOptions).build();
            cluster.connect();
            long initTimeMs = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
            logger.info("Cluster and session initialized in {} ms", (Object)initTimeMs);
            ((SocketOptions)Mockito.verify((Object)socketOptions, (VerificationMode)Mockito.atLeast((int)6))).getKeepAlive();
            ((SocketOptions)Mockito.verify((Object)socketOptions, (VerificationMode)Mockito.atMost((int)7))).getKeepAlive();
            ((HostAssert)Assertions.assertThat(cluster).host(1).isNotNull()).isUp();
            for (FakeHost failingHost : failingHosts) {
                Assertions.assertThat(cluster).host(failingHost.address).goesDownWithin(10L, TimeUnit.SECONDS);
                Host host = TestUtils.findHost(cluster, failingHost.address);
                if (host != null && (host.getReconnectionAttemptFuture() == null || host.getReconnectionAttemptFuture().isDone())) {
                    logger.warn("Periodic Reconnection Attempt hasn't started yet for {}, waiting 1 second and then checking.", (Object)host);
                    Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                }
                Assertions.assertThat(cluster).host(failingHost.address).isReconnectingFromDown();
            }
            Assertions.assertThat(TestUtils.findHost(cluster, missingHostAddress)).isNull();
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
            for (FakeHost fakeHost : failingHosts) {
                fakeHost.stop();
            }
            if (scassandra != null) {
                scassandra.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, expectedExceptions={NoHostAvailableException.class})
    public void should_not_schedule_reconnections_before_init_complete() {
        ArrayList hosts = Lists.newArrayList((Object[])new FakeHost[]{new FakeHost(TestUtils.ipOfNode(0), 9042, FakeHost.Behavior.THROWING_CONNECT_TIMEOUTS), new FakeHost(TestUtils.ipOfNode(1), 9042, FakeHost.Behavior.THROWING_CONNECT_TIMEOUTS)});
        CountingReconnectionPolicy reconnectionPolicy = new CountingReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy(100L));
        Cluster cluster = Cluster.builder().addContactPoints(new String[]{((FakeHost)hosts.get((int)0)).address, ((FakeHost)hosts.get((int)1)).address}).withReconnectionPolicy((ReconnectionPolicy)reconnectionPolicy).build();
        try {
            cluster.init();
        }
        finally {
            Assertions.assertThat((int)reconnectionPolicy.count.get()).isEqualTo(2);
            for (FakeHost fakeHost : hosts) {
                fakeHost.stop();
            }
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_be_able_to_close_cluster_that_never_successfully_connected() throws Exception {
        Cluster cluster = Cluster.builder().addContactPointsWithPorts(new InetSocketAddress[]{new InetSocketAddress("127.0.0.1", 65534)}).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            cluster.connect();
            Assertions.fail((String)"Should not have been able to connect.");
        }
        catch (NoHostAvailableException e) {
            CloseFuture closeFuture = cluster.closeAsync();
            try {
                closeFuture.get(1L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e1) {
                Assertions.fail((String)"Close Future did not complete quickly.");
            }
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_not_abort_init_if_host_does_not_support_protocol_version() {
        ScassandraCluster scassandraCluster = ScassandraCluster.builder().withIpPrefix(TestUtils.IP_PREFIX).withNodes(5).forcePeerInfo(1, 2, "release_version", "1.2.19").build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{scassandraCluster.address(1).getAddress()}).withPort(scassandraCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            scassandraCluster.init();
            cluster.init();
            for (int i = 1; i <= 5; ++i) {
                InetAddress hostAddress = scassandraCluster.address(i).getAddress();
                if (i == 2) {
                    Assertions.assertThat(cluster).host(hostAddress).hasState(Host.State.ADDED);
                    continue;
                }
                Assertions.assertThat(cluster).host(hostAddress).hasState(Host.State.UP);
            }
        }
        finally {
            cluster.close();
            scassandraCluster.stop();
        }
    }

    private void primePeerRows(Scassandra scassandra, List<FakeHost> otherHosts) throws UnknownHostException {
        PrimingClient primingClient = PrimingClient.builder().withHost(TestUtils.ipOfNode(1)).withPort(scassandra.getAdminPort()).build();
        ArrayList rows = Lists.newArrayListWithCapacity((int)5);
        int i = 0;
        for (FakeHost otherHost : otherHosts) {
            InetAddress address = InetAddress.getByName(otherHost.address);
            rows.add(ImmutableMap.builder().put((Object)"peer", (Object)address).put((Object)"rpc_address", (Object)address).put((Object)"data_center", (Object)"datacenter1").put((Object)"rack", (Object)"rack1").put((Object)"release_version", (Object)ProtocolVersion.NEWEST_SUPPORTED.minCassandraVersion().toString()).put((Object)"tokens", (Object)ImmutableSet.of((Object)Long.toString(Long.MIN_VALUE + (long)i++))).put((Object)"host_id", (Object)UUID.randomUUID()).build());
        }
        primingClient.prime(PrimingRequest.queryBuilder().withQuery("SELECT * FROM system.peers").withThen(PrimingRequest.then().withRows((List)rows).withColumnTypes(ScassandraCluster.SELECT_PEERS)).build());
    }
}

