/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMAccess;
import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMCache;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMException;
import com.datastax.driver.core.CCMWorkload;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CCMTestsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(CCMTestsSupport.class);
    private static final AtomicInteger CCM_COUNTER = new AtomicInteger(1);
    private static final List<String> TEST_GROUPS = Lists.newArrayList((Object[])new String[]{"isolated", "short", "long", "stress", "duration"});
    private static final Map<String, VersionNumber> configVersionRequirements = ImmutableMap.builder().put((Object)"enable_user_defined_functions", (Object)VersionNumber.parse((String)"2.2.0")).build();
    private CreateCCM.TestMode testMode;
    protected CCMTestConfig ccmTestConfig;
    private CCMAccess ccm;
    private CCMBridge.Builder ccmBuilder;
    private Cluster cluster;
    private Session session;
    protected String keyspace;
    private boolean erroredOut = false;
    private Closer closer;

    @BeforeClass(groups={"isolated", "short", "long", "stress", "duration"})
    public void beforeTestClass() throws Exception {
        this.beforeTestClass(this);
    }

    public void beforeTestClass(Object testInstance) throws Exception {
        this.testMode = CCMTestsSupport.determineTestMode(testInstance.getClass());
        if (this.testMode == CreateCCM.TestMode.PER_CLASS) {
            this.closer = Closer.create();
            try {
                this.initTestContext(testInstance, null);
                this.initTestCluster(testInstance);
                this.initTestSession();
                this.initTestKeyspace();
                this.initTest(testInstance);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                this.errorOut();
                Assertions.fail((String)e.getMessage());
            }
        }
    }

    @BeforeMethod(groups={"isolated", "short", "long", "stress", "duration"})
    public void beforeTestMethod(Method testMethod) throws Exception {
        this.beforeTestMethod(this, testMethod);
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        if (CCMTestsSupport.isCcmEnabled(testMethod)) {
            if (this.closer == null) {
                this.closer = Closer.create();
            }
            if (this.testMode == CreateCCM.TestMode.PER_METHOD || this.erroredOut) {
                try {
                    this.initTestContext(testInstance, testMethod);
                    this.initTestCluster(testInstance);
                    this.initTestSession();
                    this.initTestKeyspace();
                    this.initTest(testInstance);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    this.errorOut();
                    Assertions.fail((String)e.getMessage());
                }
            }
            assert (this.ccmTestConfig != null);
            assert (!this.ccmTestConfig.createCcm() || this.ccm != null);
        }
    }

    @AfterMethod(groups={"isolated", "short", "long", "stress", "duration"}, alwaysRun=true)
    public void afterTestMethod(ITestResult tr) throws Exception {
        if (CCMTestsSupport.isCcmEnabled(tr.getMethod().getConstructorOrMethod().getMethod())) {
            if (tr.getStatus() == 2) {
                this.errorOut();
            }
            if (this.erroredOut || this.testMode == CreateCCM.TestMode.PER_METHOD) {
                this.closeCloseables();
                this.closeTestCluster();
            }
            if (this.testMode == CreateCCM.TestMode.PER_METHOD) {
                this.closeTestContext();
            }
        }
    }

    @AfterClass(groups={"isolated", "short", "long", "stress", "duration"}, alwaysRun=true)
    public void afterTestClass() throws Exception {
        if (this.testMode == CreateCCM.TestMode.PER_CLASS) {
            this.closeCloseables();
            this.closeTestCluster();
            this.closeTestContext();
        }
    }

    public Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withCodecRegistry(new CodecRegistry());
    }

    public Cluster.Builder createClusterBuilderNoDebouncing() {
        return Cluster.builder().withQueryOptions(TestUtils.nonDebouncingQueryOptions());
    }

    public void onTestContextInitialized() {
    }

    public CCMAccess ccm() {
        return this.ccm;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public Session session() {
        return this.session;
    }

    public void execute(String ... statements) {
        this.execute(Arrays.asList(statements));
    }

    public void execute(Collection<String> statements) {
        assert (this.session != null);
        for (String stmt : statements) {
            try {
                this.session.execute(stmt);
            }
            catch (Exception e) {
                this.errorOut();
                LOGGER.error("Could not execute statement: " + stmt, (Throwable)e);
                Throwables.propagate((Throwable)e);
            }
        }
    }

    public void errorOut() {
        this.erroredOut = true;
        if (this.ccm != null) {
            this.ccm.setKeepLogs(true);
        }
    }

    public List<InetAddress> getContactPoints() {
        assert (this.ccmTestConfig != null);
        ArrayList<InetAddress> contactPoints = new ArrayList<InetAddress>();
        int n = 1;
        int[] numberOfNodes = this.ccmTestConfig.numberOfNodes();
        for (int dc = 1; dc <= numberOfNodes.length; ++dc) {
            int nodesInDc = numberOfNodes[dc - 1];
            for (int i = 0; i < nodesInDc; ++i) {
                try {
                    contactPoints.add(InetAddress.getByName(TestUtils.ipOfNode(n)));
                }
                catch (UnknownHostException e) {
                    Throwables.propagate((Throwable)e);
                }
                ++n;
            }
        }
        return contactPoints;
    }

    public List<InetSocketAddress> getContactPointsWithPorts() {
        assert (this.ccmTestConfig != null);
        ArrayList<InetSocketAddress> contactPoints = new ArrayList<InetSocketAddress>();
        int n = 1;
        int[] numberOfNodes = this.ccmTestConfig.numberOfNodes();
        for (int dc = 1; dc <= numberOfNodes.length; ++dc) {
            int nodesInDc = numberOfNodes[dc - 1];
            for (int i = 0; i < nodesInDc; ++i) {
                contactPoints.add(new InetSocketAddress(TestUtils.ipOfNode(n), this.ccm.getBinaryPort()));
                ++n;
            }
        }
        return contactPoints;
    }

    public <T extends Closeable> T register(T closeable) {
        this.closer.register(closeable);
        return closeable;
    }

    public void useKeyspace(String ks) {
        this.useKeyspace(this.session(), ks);
    }

    public void useKeyspace(Session session, String ks) {
        int maxTries = 3;
        for (int i = 1; i <= 3; ++i) {
            try {
                session.execute("USE " + ks);
                continue;
            }
            catch (InvalidQueryException e) {
                if (i == 3) {
                    throw e;
                }
                LOGGER.error("Could not USE keyspace, retrying");
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MINUTES);
            }
        }
    }

    protected void initTestContext(Object testInstance, Method testMethod) throws Exception {
        this.erroredOut = false;
        this.ccmTestConfig = CCMTestsSupport.createCCMTestConfig(testInstance, testMethod);
        assert (this.ccmTestConfig != null);
        if (this.ccmTestConfig.createCcm()) {
            this.ccmBuilder = this.ccmTestConfig.ccmBuilder(testInstance);
            CCMAccess ccm = CCMCache.get(this.ccmBuilder);
            assert (ccm != null);
            this.ccm = this.ccmTestConfig.dirtiesContext() ? ccm : new ReadOnlyCCMAccess(ccm);
            try {
                ccm.start();
            }
            catch (CCMException e) {
                this.errorOut();
                Assertions.fail((String)e.getMessage());
            }
            LOGGER.debug("Using {}", (Object)ccm);
        }
    }

    protected void initTestCluster(Object testInstance) throws Exception {
        if (this.ccmTestConfig.createCcm() && this.ccmTestConfig.createCluster()) {
            Cluster.Builder builder = this.ccmTestConfig.clusterProvider(testInstance);
            if (builder.getContactPoints().isEmpty()) {
                builder.addContactPoints(this.getContactPoints());
            }
            builder.withPort(this.ccm.getBinaryPort());
            this.cluster = this.register(builder.build());
            this.cluster.init();
        }
    }

    protected void initTestSession() throws Exception {
        if (this.ccmTestConfig.createCcm() && this.ccmTestConfig.createCluster() && this.ccmTestConfig.createSession()) {
            this.session = this.register(this.cluster.connect());
        }
    }

    protected void initTestKeyspace() {
        if (this.ccmTestConfig.createCcm() && this.ccmTestConfig.createCluster() && this.ccmTestConfig.createSession() && this.ccmTestConfig.createKeyspace()) {
            try {
                this.keyspace = TestUtils.generateIdentifier("ks_");
                LOGGER.debug("Using keyspace " + this.keyspace);
                this.session.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", this.keyspace, 1));
                this.useKeyspace(this.keyspace);
            }
            catch (Exception e) {
                this.errorOut();
                LOGGER.error("Could not create test keyspace", (Throwable)e);
                Throwables.propagate((Throwable)e);
            }
        }
    }

    protected void initTest(Object testInstance) throws Exception {
        this.ccmTestConfig.invokeInitTest(testInstance);
    }

    protected void closeTestContext() throws Exception {
        if (this.ccmTestConfig != null && this.ccmBuilder != null && this.ccm != null) {
            if (this.ccmTestConfig.dirtiesContext()) {
                CCMCache.remove(this.ccmBuilder);
                this.ccm.close();
            } else {
                ((ReadOnlyCCMAccess)this.ccm).delegate.close();
            }
        }
        this.ccmTestConfig = null;
        this.ccmBuilder = null;
        this.ccm = null;
    }

    protected void closeTestCluster() {
        if (this.cluster != null && !this.cluster.isClosed()) {
            TestUtils.executeNoFail(new Runnable(){

                @Override
                public void run() {
                    CCMTestsSupport.this.cluster.close();
                }
            }, false);
        }
        this.cluster = null;
        this.session = null;
        this.keyspace = null;
    }

    protected void resetTestSession() throws Exception {
        this.session.close();
        Cluster.Builder builder = this.ccmTestConfig.clusterProvider(this);
        if (builder.getContactPoints().isEmpty()) {
            builder.addContactPoints(this.getContactPoints());
        }
        builder.withPort(this.ccm.getBinaryPort());
        this.cluster = this.register(builder.build());
        this.cluster.init();
        this.session.close();
        this.session = this.register(this.cluster.connect());
        this.useKeyspace(this.session, this.keyspace);
    }

    protected void closeCloseables() {
        if (this.closer != null) {
            TestUtils.executeNoFail(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    CCMTestsSupport.this.closer.close();
                    return null;
                }
            }, false);
        }
    }

    private static boolean isCcmEnabled(Method testMethod) {
        Test ann = CCMTestsSupport.locateAnnotation(testMethod, Test.class);
        return !Collections.disjoint(Arrays.asList(ann.groups()), TEST_GROUPS);
    }

    private static CCMTestConfig createCCMTestConfig(Object testInstance, Method testMethod) throws Exception {
        ArrayList<CCMConfig> annotations = new ArrayList<CCMConfig>();
        CCMConfig ann = CCMTestsSupport.locateAnnotation(testMethod, CCMConfig.class);
        if (ann != null) {
            annotations.add(ann);
        }
        CCMTestsSupport.locateClassAnnotations(testInstance.getClass(), CCMConfig.class, annotations);
        return new CCMTestConfig(annotations);
    }

    private static CreateCCM.TestMode determineTestMode(Class<?> testClass) {
        List<CreateCCM> annotations = CCMTestsSupport.locateClassAnnotations(testClass, CreateCCM.class, new ArrayList());
        if (!annotations.isEmpty()) {
            return annotations.get(0).value();
        }
        return CreateCCM.TestMode.PER_CLASS;
    }

    private static <A extends Annotation> A locateAnnotation(Method testMethod, Class<? extends A> clazz) {
        if (testMethod == null) {
            return null;
        }
        testMethod.setAccessible(true);
        return testMethod.getAnnotation(clazz);
    }

    private static <A extends Annotation> List<A> locateClassAnnotations(Class<?> clazz, Class<? extends A> annotationClass, List<A> annotations) {
        A ann = clazz.getAnnotation(annotationClass);
        if (ann != null) {
            annotations.add(ann);
        }
        if ((clazz = clazz.getSuperclass()) == null) {
            return annotations;
        }
        return CCMTestsSupport.locateClassAnnotations(clazz, annotationClass, annotations);
    }

    private static Method locateMethod(String methodName, Class<?> clazz) throws NoSuchMethodException {
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException e) {
            clazz = clazz.getSuperclass();
            if (clazz == null) {
                throw e;
            }
            return CCMTestsSupport.locateMethod(methodName, clazz);
        }
    }

    private static <T> T instantiate(Class<? extends T> clazz) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (clazz.getEnclosingClass() == null || Modifier.isStatic(clazz.getModifiers())) {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        Class<?> enclosingClass = clazz.getEnclosingClass();
        Object enclosingInstance = enclosingClass.newInstance();
        Constructor<T> constructor = clazz.getDeclaredConstructor(enclosingClass);
        constructor.setAccessible(true);
        return constructor.newInstance(enclosingInstance);
    }

    private static class CCMTestConfig {
        private final List<CCMConfig> annotations;
        private CCMBridge.Builder ccmBuilder;

        public CCMTestConfig(List<CCMConfig> annotations) {
            this.annotations = annotations;
        }

        private int[] numberOfNodes() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.numberOfNodes().length <= 0) continue;
                return ann.numberOfNodes();
            }
            return new int[]{1};
        }

        private String version() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.version().isEmpty()) continue;
                return ann.version();
            }
            return null;
        }

        private Boolean dse() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.dse().length <= 0) continue;
                return ann.dse()[0];
            }
            return null;
        }

        private boolean ssl() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.ssl().length <= 0) continue;
                return ann.ssl()[0];
            }
            return false;
        }

        private boolean auth() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.auth().length <= 0) continue;
                return ann.auth()[0];
            }
            return false;
        }

        private Map<String, Object> config() {
            HashMap<String, Object> config = new HashMap<String, Object>();
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                this.addConfigOptions(ann.config(), config);
            }
            return config;
        }

        private Map<String, Object> dseConfig() {
            HashMap<String, Object> config = new HashMap<String, Object>();
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                this.addConfigOptions(ann.dseConfig(), config);
            }
            return config;
        }

        private void addConfigOptions(String[] conf, Map<String, Object> config) {
            VersionNumber version = VersionNumber.parse((String)this.version());
            if (version == null) {
                version = CCMBridge.getGlobalCassandraVersion();
            } else {
                Boolean dse = this.dse();
                if (dse != null && dse.booleanValue()) {
                    version = CCMBridge.getCassandraVersion(version);
                }
            }
            for (String aConf : conf) {
                String[] tokens = aConf.split(":");
                if (tokens.length != 2) {
                    Assertions.fail((String)("Wrong configuration option: " + aConf));
                }
                String key = tokens[0];
                String value = tokens[1];
                if (configVersionRequirements.containsKey(key)) {
                    VersionNumber requirement = (VersionNumber)configVersionRequirements.get(key);
                    if (version != null && version.compareTo(requirement) < 0) {
                        LOGGER.debug("Skipping inclusion of '{}' in cassandra.yaml since it requires >= C* {} and {} was detected.", new Object[]{aConf, requirement, version});
                        continue;
                    }
                }
                config.put(key, value);
            }
        }

        private Set<String> jvmArgs() {
            LinkedHashSet<String> args = new LinkedHashSet<String>();
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                Collections.addAll(args, ann.jvmArgs());
            }
            return args;
        }

        private Set<String> startOptions() {
            LinkedHashSet<String> args = new LinkedHashSet<String>();
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                Collections.addAll(args, ann.options());
            }
            return args;
        }

        private List<String[]> workloads() {
            int total = 0;
            for (int perDc : this.numberOfNodes()) {
                total += perDc;
            }
            ArrayList<Object> workloads = new ArrayList<Object>(Collections.nCopies(total, null));
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                CCMWorkload[] annWorkloads = ann.workloads();
                for (int j = 0; j < annWorkloads.length; ++j) {
                    CCMWorkload nodeWorkloads = annWorkloads[j];
                    workloads.set(j, nodeWorkloads.value());
                }
            }
            return workloads;
        }

        private boolean createCcm() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.createCcm().length <= 0) continue;
                return ann.createCcm()[0];
            }
            return true;
        }

        private boolean createCluster() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.createCluster().length <= 0) continue;
                return ann.createCluster()[0];
            }
            return true;
        }

        private boolean createSession() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.createSession().length <= 0) continue;
                return ann.createSession()[0];
            }
            return true;
        }

        private boolean createKeyspace() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.createKeyspace().length <= 0) continue;
                return ann.createKeyspace()[0];
            }
            return true;
        }

        private boolean dirtiesContext() {
            for (CCMConfig ann : this.annotations) {
                if (ann == null || ann.dirtiesContext().length <= 0) continue;
                return ann.dirtiesContext()[0];
            }
            return false;
        }

        private CCMBridge.Builder ccmBuilder(Object testInstance) throws Exception {
            if (this.ccmBuilder == null) {
                Boolean dse;
                String versionStr;
                this.ccmBuilder = this.ccmProvider(testInstance);
                if (this.ccmBuilder == null) {
                    this.ccmBuilder = CCMBridge.builder().withNodes(this.numberOfNodes()).notStarted();
                }
                if ((versionStr = this.version()) != null) {
                    VersionNumber version = VersionNumber.parse((String)versionStr);
                    this.ccmBuilder.withVersion(version);
                }
                if ((dse = this.dse()) != null) {
                    this.ccmBuilder.withDSE(dse);
                }
                if (this.ssl()) {
                    this.ccmBuilder.withSSL();
                }
                if (this.auth()) {
                    this.ccmBuilder.withAuth();
                }
                for (Map.Entry<String, Object> entry : this.config().entrySet()) {
                    this.ccmBuilder.withCassandraConfiguration(entry.getKey(), entry.getValue());
                }
                for (Map.Entry<String, Object> entry : this.dseConfig().entrySet()) {
                    this.ccmBuilder.withDSEConfiguration(entry.getKey(), entry.getValue());
                }
                for (String option : this.startOptions()) {
                    this.ccmBuilder.withCreateOptions(option);
                }
                for (String arg : this.jvmArgs()) {
                    this.ccmBuilder.withJvmArgs(arg);
                }
                List<String[]> workloads = this.workloads();
                for (int i = 0; i < workloads.size(); ++i) {
                    String[] workload = workloads.get(i);
                    if (workload == null) continue;
                    this.ccmBuilder.withWorkload(i + 1, workload);
                }
            }
            return this.ccmBuilder;
        }

        private CCMBridge.Builder ccmProvider(Object testInstance) throws Exception {
            String methodName = null;
            Class<?> clazz = null;
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                if (!ann.ccmProvider().isEmpty()) {
                    methodName = ann.ccmProvider();
                }
                if (ann.ccmProviderClass().equals(CCMConfig.Undefined.class)) continue;
                clazz = ann.ccmProviderClass();
            }
            if (methodName == null) {
                return null;
            }
            if (clazz == null) {
                clazz = testInstance.getClass();
            }
            Method method = CCMTestsSupport.locateMethod(methodName, clazz);
            assert (CCMBridge.Builder.class.isAssignableFrom(method.getReturnType()));
            if (Modifier.isStatic(method.getModifiers())) {
                return (CCMBridge.Builder)method.invoke(null, new Object[0]);
            }
            Object receiver = testInstance.getClass().equals(clazz) ? testInstance : CCMTestsSupport.instantiate(clazz);
            return (CCMBridge.Builder)method.invoke(receiver, new Object[0]);
        }

        private Cluster.Builder clusterProvider(Object testInstance) throws Exception {
            String methodName = null;
            Class<?> clazz = null;
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                if (!ann.clusterProvider().isEmpty()) {
                    methodName = ann.clusterProvider();
                }
                if (ann.clusterProviderClass().equals(CCMConfig.Undefined.class)) continue;
                clazz = ann.clusterProviderClass();
            }
            if (methodName == null) {
                methodName = "createClusterBuilder";
            }
            if (clazz == null) {
                clazz = testInstance.getClass();
            }
            Method method = CCMTestsSupport.locateMethod(methodName, clazz);
            assert (Cluster.Builder.class.isAssignableFrom(method.getReturnType()));
            if (Modifier.isStatic(method.getModifiers())) {
                return (Cluster.Builder)method.invoke(null, new Object[0]);
            }
            Object receiver = testInstance.getClass().equals(clazz) ? testInstance : CCMTestsSupport.instantiate(clazz);
            return (Cluster.Builder)method.invoke(receiver, new Object[0]);
        }

        private void invokeInitTest(Object testInstance) throws Exception {
            Method method;
            String methodName = null;
            Class<?> clazz = null;
            for (int i = this.annotations.size() - 1; i >= 0; --i) {
                CCMConfig ann = this.annotations.get(i);
                if (!ann.testInitializer().isEmpty()) {
                    methodName = ann.testInitializer();
                }
                if (ann.testInitializerClass().equals(CCMConfig.Undefined.class)) continue;
                clazz = ann.testInitializerClass();
            }
            if (methodName == null) {
                methodName = "onTestContextInitialized";
            }
            if (clazz == null) {
                clazz = testInstance.getClass();
            }
            if (Modifier.isStatic((method = CCMTestsSupport.locateMethod(methodName, clazz)).getModifiers())) {
                method.invoke(null, new Object[0]);
            } else {
                Object receiver = testInstance.getClass().equals(clazz) ? testInstance : CCMTestsSupport.instantiate(clazz);
                method.invoke(receiver, new Object[0]);
            }
        }
    }

    private static class ReadOnlyCCMAccess
    implements CCMAccess {
        private final CCMAccess delegate;

        private ReadOnlyCCMAccess(CCMAccess delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getClusterName() {
            return this.delegate.getClusterName();
        }

        @Override
        public VersionNumber getCassandraVersion() {
            return this.delegate.getCassandraVersion();
        }

        @Override
        public VersionNumber getDSEVersion() {
            return this.delegate.getDSEVersion();
        }

        @Override
        public InetSocketAddress addressOfNode(int n) {
            return this.delegate.addressOfNode(n);
        }

        @Override
        public InetSocketAddress jmxAddressOfNode(int n) {
            return this.delegate.jmxAddressOfNode(n);
        }

        @Override
        public File getCcmDir() {
            return this.delegate.getCcmDir();
        }

        @Override
        public File getClusterDir() {
            return this.delegate.getClusterDir();
        }

        @Override
        public File getNodeDir(int n) {
            return this.delegate.getNodeDir(n);
        }

        @Override
        public File getNodeConfDir(int n) {
            return this.delegate.getNodeConfDir(n);
        }

        @Override
        public int getStoragePort() {
            return this.delegate.getStoragePort();
        }

        @Override
        public int getThriftPort() {
            return this.delegate.getThriftPort();
        }

        @Override
        public int getBinaryPort() {
            return this.delegate.getBinaryPort();
        }

        @Override
        public void setKeepLogs(boolean keepLogs) {
            this.delegate.setKeepLogs(keepLogs);
        }

        @Override
        public int[] getNodeCount() {
            return this.delegate.getNodeCount();
        }

        @Override
        public String checkForErrors() {
            return this.delegate.checkForErrors();
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void start() {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void stop() {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void forceStop() {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void start(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void stop(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void forceStop(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void pause(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void resume(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void remove(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void add(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void add(int dc, int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void decommission(int n) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void updateConfig(Map<String, Object> configs) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void updateDSEConfig(Map<String, Object> configs) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void updateNodeConfig(int n, String key, Object value) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void updateNodeConfig(int n, Map<String, Object> configs) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void updateDSENodeConfig(int n, String key, Object value) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void updateDSENodeConfig(int n, Map<String, Object> configs) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void setWorkload(int node, String ... workload) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void waitForUp(int node) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void waitForDown(int node) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void dsetool(int node, String ... args) {
            throw new UnsupportedOperationException("This CCM cluster is read-only");
        }

        @Override
        public void reloadCore(int node, String keyspace, String table, boolean reindex) {
            this.delegate.reloadCore(node, keyspace, table, reindex);
        }

        @Override
        public ProtocolVersion getProtocolVersion() {
            return this.delegate.getProtocolVersion();
        }

        @Override
        public ProtocolVersion getProtocolVersion(ProtocolVersion maximumAllowed) {
            return this.delegate.getProtocolVersion(maximumAllowed);
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

