/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolFeature;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@CassandraVersion(value="2.0.0")
public class BatchStatementIntegrationTest
extends CCMTestsSupport {
    private static final String keyspace2Internal = TestUtils.generateIdentifier("KS_");
    private static final String keyspace2 = Metadata.quoteIfNecessary((String)keyspace2Internal);
    private static final AtomicInteger idCounter = new AtomicInteger(0);

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test (k text, v int, PRIMARY KEY (k, v))", "CREATE TABLE test2 (k text, v int, PRIMARY KEY (k, v))", String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace2, 1), String.format("CREATE TABLE %s.users(id int, id2 int, name text, primary key (id, id2))", keyspace2));
    }

    @Test(groups={"short"})
    public void should_execute_simple_batch() {
        try {
            PreparedStatement st = this.session().prepare("INSERT INTO test (k, v) VALUES (?, ?)");
            BatchStatement batch = new BatchStatement();
            batch.add((Statement)new SimpleStatement("INSERT INTO test (k, v) VALUES (?, ?)", new Object[]{"key1", 0}));
            batch.add((Statement)st.bind(new Object[]{"key1", 1}));
            batch.add((Statement)st.bind(new Object[]{"key2", 0}));
            Assert.assertEquals((int)3, (int)batch.size());
            this.session().execute((Statement)batch);
            ResultSet rs = this.session().execute("SELECT * FROM test");
            Row r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key1");
            Assert.assertEquals((int)r.getInt("v"), (int)0);
            r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key1");
            Assert.assertEquals((int)r.getInt("v"), (int)1);
            r = rs.one();
            Assert.assertEquals((String)r.getString("k"), (String)"key2");
            Assert.assertEquals((int)r.getInt("v"), (int)0);
            Assert.assertTrue((boolean)rs.isExhausted());
        }
        catch (UnsupportedFeatureException e) {
            Assert.assertEquals((Object)this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion(), (Object)ProtocolVersion.V1);
        }
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.9", description="This will only work with C* 2.0.9 (CASSANDRA-7337)")
    public void should_execute_cas_batch() {
        PreparedStatement st = this.session().prepare("INSERT INTO test2 (k, v) VALUES (?, ?) IF NOT EXISTS");
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement("INSERT INTO test2 (k, v) VALUES (?, ?)", new Object[]{"key1", 0}));
        batch.add((Statement)st.bind(new Object[]{"key1", 1}));
        batch.add((Statement)st.bind(new Object[]{"key1", 2}));
        Assert.assertEquals((int)3, (int)batch.size());
        ResultSet rs = this.session().execute((Statement)batch);
        Row r = rs.one();
        Assert.assertTrue((!r.isNull("[applied]") ? 1 : 0) != 0);
        Assert.assertEquals((boolean)r.getBool("[applied]"), (boolean)true);
        rs = this.session().execute((Statement)batch);
        r = rs.one();
        Assert.assertTrue((!r.isNull("[applied]") ? 1 : 0) != 0);
        Assert.assertEquals((boolean)r.getBool("[applied]"), (boolean)false);
    }

    @CassandraVersion(value="4.0.0")
    @Test(groups={"short"})
    public void should_use_keyspace_if_set_on_batch_statement() {
        this.insertWithKeyspaceOnStatement(this.keyspace);
    }

    @CassandraVersion(value="4.0.0")
    @Test(groups={"short"})
    public void should_use_keyspace_if_set_on_batch_statement_no_ks_on_session() {
        this.insertWithKeyspaceOnStatement(null);
    }

    @CassandraVersion(value="4.0.0")
    @Test(groups={"short"})
    public void should_use_keyspace_if_set_on_batch_statement_same_ks_on_session() {
        this.insertWithKeyspaceOnStatement(keyspace2);
    }

    @Test(groups={"short"}, expectedExceptions={InvalidQueryException.class})
    public void should_not_use_keyspace_if_set_and_protocol_does_not_support() {
        ProtocolVersion protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        while (ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(protocolVersion)) {
            protocolVersion = protocolVersion.getLowerSupported();
        }
        Cluster cluster = this.createClusterBuilderNoDebouncing().addContactPointsWithPorts(this.getContactPointsWithPorts()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).withProtocolVersion(protocolVersion).build();
        this.insertWithKeyspaceOnStatement(cluster, this.keyspace);
    }

    @CassandraVersion(value="4.0.0")
    @Test(groups={"short"})
    public void should_inherit_keyspace_from_inner_statement() {
        int id = idCounter.incrementAndGet();
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)new SimpleStatement("INSERT INTO users (id, id2, name) values (?, 1, 'hello')", new Object[]{id}));
        batch.add((Statement)new SimpleStatement("INSERT INTO users (id, id2, name) values (?, 2, 'sweet')", new Object[]{id}).setKeyspace(keyspace2Internal));
        batch.add((Statement)new SimpleStatement("INSERT INTO users (id, id2, name) values (?, 3, 'world')", new Object[]{id}));
        Assertions.assertThat((String)batch.getKeyspace()).isEqualTo((Object)keyspace2Internal);
        this.session().execute((Statement)batch);
        this.validateData(this.session(), id);
    }

    private void insertWithKeyspaceOnStatement(String sessionKeyspace) {
        this.insertWithKeyspaceOnStatement(this.cluster(), sessionKeyspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertWithKeyspaceOnStatement(Cluster cluster, String sessionKeyspace) {
        Session session = sessionKeyspace != null ? cluster.connect(sessionKeyspace) : cluster.connect();
        try {
            int id = idCounter.incrementAndGet();
            BatchStatement batch = new BatchStatement();
            batch.add((Statement)new SimpleStatement("INSERT INTO users (id, id2, name) values (?, 1, 'hello')", new Object[]{id}));
            batch.add((Statement)new SimpleStatement("INSERT INTO users (id, id2, name) values (?, 2, 'sweet')", new Object[]{id}));
            batch.add((Statement)new SimpleStatement("INSERT INTO users (id, id2, name) values (?, 3, 'world')", new Object[]{id}));
            batch.setKeyspace(keyspace2Internal);
            Assertions.assertThat((String)batch.getKeyspace()).isEqualTo((Object)keyspace2Internal);
            session.execute((Statement)batch);
            this.validateData(session, id);
        }
        finally {
            session.close();
            if (cluster != this.cluster()) {
                cluster.close();
            }
        }
    }

    private void validateData(Session session, int id) {
        ResultSet result = session.execute((Statement)new SimpleStatement("select * from users where id = ?", new Object[]{id}).setKeyspace(keyspace2Internal));
        Assertions.assertThat((int)result.getAvailableWithoutFetching()).isEqualTo(3);
        Row row1 = result.one();
        Assertions.assertThat((int)row1.getInt("id")).isEqualTo(id);
        Assertions.assertThat((int)row1.getInt("id2")).isEqualTo(1);
        Assertions.assertThat((String)row1.getString("name")).isEqualTo((Object)"hello");
        Row row2 = result.one();
        Assertions.assertThat((int)row2.getInt("id")).isEqualTo(id);
        Assertions.assertThat((int)row2.getInt("id2")).isEqualTo(2);
        Assertions.assertThat((String)row2.getString("name")).isEqualTo((Object)"sweet");
        Row row3 = result.one();
        Assertions.assertThat((int)row3.getInt("id")).isEqualTo(id);
        Assertions.assertThat((int)row3.getInt("id2")).isEqualTo(3);
        Assertions.assertThat((String)row3.getString("name")).isEqualTo((Object)"world");
    }
}

