/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetSocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(config={"authenticator:PasswordAuthenticator"}, jvmArgs={"-Dcassandra.superuser_setup_delay_ms=0"}, createCluster={false})
public class AuthenticationTest
extends CCMTestsSupport {
    @BeforeMethod(groups={"short"})
    public void sleepIf12() {
        if (this.ccm().getCassandraVersion().getMajor() < 2) {
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    @Test(groups={"short"})
    public void should_connect_with_credentials() throws InterruptedException {
        PlainTextAuthProvider authProvider = (PlainTextAuthProvider)Mockito.spy((Object)new PlainTextAuthProvider("cassandra", "cassandra"));
        Cluster cluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withAuthProvider((AuthProvider)authProvider).build();
        cluster.connect();
        ((PlainTextAuthProvider)Mockito.verify((Object)authProvider, (VerificationMode)Mockito.atLeastOnce())).newAuthenticator(TestUtils.findHost(cluster, 1).getSocketAddress(), "org.apache.cassandra.auth.PasswordAuthenticator");
        Assertions.assertThat((long)cluster.getMetrics().getErrorMetrics().getAuthenticationErrors().getCount()).isEqualTo(0L);
    }

    @Test(groups={"short"}, expectedExceptions={AuthenticationException.class})
    public void should_fail_to_connect_with_wrong_credentials() throws InterruptedException {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withCredentials("bogus", "bogus").build());
        try {
            cluster.connect();
        }
        finally {
            Assertions.assertThat((long)cluster.getMetrics().getErrorMetrics().getAuthenticationErrors().getCount()).isEqualTo(1L);
        }
    }

    @Test(groups={"short"}, expectedExceptions={AuthenticationException.class})
    public void should_fail_to_connect_without_credentials() throws InterruptedException {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).build());
        try {
            cluster.connect();
        }
        finally {
            Assertions.assertThat((long)cluster.getMetrics().getErrorMetrics().getAuthenticationErrors().getCount()).isEqualTo(1L);
        }
    }

    @Test(groups={"short"})
    @CCMConfig(dirtiesContext={true})
    public void should_connect_with_slow_server() throws InterruptedException {
        Cluster cluster = Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withAuthProvider((AuthProvider)new SlowAuthProvider()).withPoolingOptions(new PoolingOptions().setHeartbeatIntervalSeconds(1)).build();
        cluster.connect();
    }

    private void simulateBusyServer() {
        this.ccm().pause(1);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                AuthenticationTest.this.ccm().resume(1);
            }
        }, 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_not_create_pool_with_wrong_credentials() throws InterruptedException {
        Session session;
        PlainTextAuthProvider authProvider = new PlainTextAuthProvider("cassandra", "cassandra");
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withAuthProvider((AuthProvider)authProvider).build());
        cluster.init();
        authProvider.setPassword("wrong");
        Level previous = TestUtils.setLogLevel(Session.class, Level.WARN);
        MemoryAppender logs = new MemoryAppender().enableFor(Session.class);
        try {
            session = cluster.connect();
        }
        catch (Throwable throwable) {
            TestUtils.setLogLevel(Session.class, previous);
            logs.disableFor(Session.class);
            throw throwable;
        }
        TestUtils.setLogLevel(Session.class, previous);
        logs.disableFor(Session.class);
        Assertions.assertThat((Iterable)session.getState().getConnectedHosts()).isEmpty();
        InetSocketAddress host = this.ccm().addressOfNode(1);
        Assertions.assertThat((String)logs.get()).contains(new CharSequence[]{"Error creating pool to " + host, "Authentication error on host " + host, AuthenticationException.class.getSimpleName()});
    }

    private class SlowAuthProvider
    extends PlainTextAuthProvider {
        public SlowAuthProvider() {
            super("cassandra", "cassandra");
        }

        public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) throws AuthenticationException {
            AuthenticationTest.this.simulateBusyServer();
            return super.newAuthenticator(host, authenticator);
        }
    }
}

