/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.datastax.driver.dse.graph.Vertex;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
public class DefaultTimestampTest
extends CCMGraphTestsSupport {
    @Override
    public void onTestContextInitialized() {
        super.onTestContextInitialized();
        this.executeGraph(GraphFixtures.modern);
    }

    @Test(groups={"short"})
    public void should_use_default_timestamp_if_set() {
        long ts = (System.currentTimeMillis() - 1L) * 1000L + 555L;
        long expectedTs = ts + 1L;
        GraphStatement addVtxStmt = new SimpleGraphStatement("graph.addVertex(label, 'person', 'name', 'tom', 'age', 23);").setDefaultTimestamp(ts);
        GraphResultSet result = this.session().executeGraph(addVtxStmt);
        Vertex v = result.one().asVertex();
        GraphNode id = v.getId();
        Select.Where readCqlStatement = QueryBuilder.select().column("name").writeTime("name").as("wname").column("age").writeTime("age").as("wage").column(QueryBuilder.quote((String)"~~vertex_exists")).writeTime(QueryBuilder.quote((String)"~~vertex_exists")).as("wv").from(this.cluster().getConfiguration().getGraphOptions().getGraphName(), "person_p").where(QueryBuilder.eq((String)"community_id", (Object)id.get("community_id").asLong()));
        ResultSet resultSet = this.session().execute((Statement)readCqlStatement);
        for (Row row : resultSet) {
            String name = row.getString("name");
            int age = row.getInt("age");
            boolean vertexExists = row.getBool(QueryBuilder.quote((String)"~~vertex_exists"));
            if (name != null) {
                Assertions.assertThat((String)name).isEqualTo((Object)"tom");
                Assertions.assertThat((long)row.getLong("wname")).isEqualTo(expectedTs);
                continue;
            }
            if (!row.isNull("age")) {
                Assertions.assertThat((int)age).isEqualTo(23);
                Assertions.assertThat((long)row.getLong("wage")).isEqualTo(expectedTs);
                continue;
            }
            if (!row.isNull(QueryBuilder.quote((String)"~~vertex_exists"))) {
                Assertions.assertThat((boolean)vertexExists).isTrue();
                Assertions.assertThat((long)row.getLong("wv")).isEqualTo(expectedTs);
                continue;
            }
            Assertions.fail((String)"Got a row where all columns were null.");
        }
    }
}

