/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry.codecs;

import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.geometry.Utils;
import com.datastax.driver.dse.geometry.codecs.GeometryCodecTest;
import com.datastax.driver.dse.geometry.codecs.PolygonCodec;
import org.testng.annotations.DataProvider;

public class PolygonCodecTest
extends GeometryCodecTest<Polygon, PolygonCodec> {
    private Polygon polygon = new Polygon(Utils.p(30.0, 10.0), Utils.p(10.0, 20.0), Utils.p(20.0, 40.0), new Point[]{Utils.p(40.0, 40.0)});

    public PolygonCodecTest() {
        super(PolygonCodec.INSTANCE);
    }

    @Override
    @DataProvider
    public Object[][] serde() {
        return new Object[][]{{null, null}, {this.polygon, this.polygon}};
    }

    @Override
    @DataProvider
    public Object[][] format() {
        return new Object[][]{{null, "NULL"}, {this.polygon, "'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))'"}};
    }

    @Override
    @DataProvider
    public Object[][] parse() {
        return new Object[][]{{null, null}, {"", null}, {" ", null}, {"NULL", null}, {" NULL ", null}, {"'POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))'", this.polygon}, {" ' Polygon ( ( 30 10, 40 40, 20 40, 10 20, 30 10 ) ) ' ", this.polygon}};
    }
}

