/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.geometry.Utils;
import com.esri.core.geometry.ogc.OGCLineString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.testng.annotations.Test;

public class LineStringTest {
    private final LineString lineString = new LineString(Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), new Point[]{Utils.p(40.0, 40.0)});
    private final String wkt = "LINESTRING (30 10, 10 30, 40 40)";
    private final String json = "{\"type\":\"LineString\",\"coordinates\":[[30.0,10.0],[10.0,30.0],[40.0,40.0]]}";

    @Test(groups={"unit"})
    public void should_parse_valid_well_known_text() {
        Assertions.assertThat((Object)LineString.fromWellKnownText((String)"LINESTRING (30 10, 10 30, 40 40)")).isEqualTo((Object)this.lineString);
    }

    @Test(groups={"unit"})
    public void should_fail_to_parse_invalid_well_known_text() {
        this.assertInvalidWkt("linestring()");
        this.assertInvalidWkt("linestring(30 10 20, 10 30 20)");
        this.assertInvalidWkt("linestring(0 0, 1 1, 0 1, 1 0)");
        this.assertInvalidWkt("superlinestring(30 10, 10 30, 40 40)");
    }

    @Test(groups={"unit"})
    public void should_convert_to_well_known_text() {
        Assertions.assertThat((String)this.lineString.toString()).isEqualTo((Object)"LINESTRING (30 10, 10 30, 40 40)");
    }

    @Test(groups={"unit"})
    public void should_convert_to_well_know_binary() {
        ByteBuffer actual = this.lineString.asWellKnownBinary();
        ByteBuffer expected = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        expected.position(0);
        expected.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        expected.putInt(2);
        expected.putInt(3);
        expected.putDouble(30.0);
        expected.putDouble(10.0);
        expected.putDouble(10.0);
        expected.putDouble(30.0);
        expected.putDouble(40.0);
        expected.putDouble(40.0);
        expected.flip();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)expected);
    }

    @Test(groups={"unit"})
    public void should_load_from_well_know_binary() {
        ByteBuffer bb = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        bb.position(0);
        bb.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        bb.putInt(2);
        bb.putInt(3);
        bb.putDouble(30.0);
        bb.putDouble(10.0);
        bb.putDouble(10.0);
        bb.putDouble(30.0);
        bb.putDouble(40.0);
        bb.putDouble(40.0);
        bb.flip();
        Assertions.assertThat((Object)LineString.fromWellKnownBinary((ByteBuffer)bb)).isEqualTo((Object)this.lineString);
    }

    @Test(groups={"unit"})
    public void should_parse_valid_geo_json() {
        Assertions.assertThat((Object)LineString.fromGeoJson((String)"{\"type\":\"LineString\",\"coordinates\":[[30.0,10.0],[10.0,30.0],[40.0,40.0]]}")).isEqualTo((Object)this.lineString);
    }

    @Test(groups={"unit"})
    public void should_convert_to_geo_json() {
        Assertions.assertThat((String)this.lineString.asGeoJson()).isEqualTo((Object)"{\"type\":\"LineString\",\"coordinates\":[[30.0,10.0],[10.0,30.0],[40.0,40.0]]}");
    }

    @Test(groups={"unit"})
    public void should_convert_to_ogc_line_string() {
        Assertions.assertThat((Object)this.lineString.getOgcGeometry()).isInstanceOf(OGCLineString.class);
    }

    @Test(groups={"unit"})
    public void should_produce_same_hashcode_for_equal_objects() {
        LineString line1 = new LineString(Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), new Point[]{Utils.p(40.0, 40.0)});
        LineString line2 = LineString.fromWellKnownText((String)"LINESTRING (30 10, 10 30, 40 40)");
        Assertions.assertThat((Object)line1).isEqualTo((Object)line2);
        Assertions.assertThat((int)line1.hashCode()).isEqualTo(line2.hashCode());
    }

    @Test(groups={"unit"})
    public void should_expose_points() {
        Assertions.assertThat((List)this.lineString.getPoints()).containsOnly((Object[])new Point[]{Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), Utils.p(40.0, 40.0)});
        Assertions.assertThat((List)LineString.fromWellKnownText((String)"LINESTRING (30 10, 10 30, 40 40)").getPoints()).containsOnly((Object[])new Point[]{Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), Utils.p(40.0, 40.0)});
    }

    @Test(groups={"unit"})
    public void should_serialize_and_deserialize() throws Exception {
        Assertions.assertThat((Object)Utils.serializeAndDeserialize((Geometry)this.lineString)).isEqualTo((Object)this.lineString);
    }

    @Test(groups={"unit"})
    public void should_contain_self() {
        Assertions.assertThat((boolean)this.lineString.contains((Geometry)this.lineString)).isTrue();
    }

    @Test(groups={"unit"})
    public void should_contain_all_intersected_points_except_start_and_end() {
        LineString s = new LineString(Utils.p(0.0, 0.0), Utils.p(0.0, 30.0), new Point[]{Utils.p(30.0, 30.0)});
        Assertions.assertThat((boolean)s.contains((Geometry)Utils.p(0.0, 0.0))).isFalse();
        Assertions.assertThat((boolean)s.contains((Geometry)Utils.p(0.0, 15.0))).isTrue();
        Assertions.assertThat((boolean)s.contains((Geometry)Utils.p(0.0, 30.0))).isTrue();
        Assertions.assertThat((boolean)s.contains((Geometry)Utils.p(15.0, 30.0))).isTrue();
        Assertions.assertThat((boolean)s.contains((Geometry)Utils.p(30.0, 30.0))).isFalse();
    }

    @Test(groups={"unit"})
    public void should_contain_substring() {
        Assertions.assertThat((boolean)this.lineString.contains((Geometry)new LineString(Utils.p(30.0, 10.0), Utils.p(10.0, 30.0), new Point[0]))).isTrue();
    }

    @Test(groups={"unit"})
    public void should_not_contain_unrelated_string() {
        Assertions.assertThat((boolean)this.lineString.contains((Geometry)new LineString(Utils.p(10.0, 10.0), Utils.p(30.0, 30.0), new Point[0]))).isFalse();
    }

    @Test(groups={"unit"})
    public void should_not_contain_polygon() {
        LineString s = new LineString(Utils.p(0.0, 0.0), Utils.p(0.0, 30.0), new Point[]{Utils.p(30.0, 30.0), Utils.p(30.0, 0.0)});
        Polygon p = new Polygon(Utils.p(10.0, 10.0), Utils.p(10.0, 20.0), Utils.p(20.0, 20.0), new Point[]{Utils.p(20.0, 10.0)});
        Assertions.assertThat((boolean)s.contains((Geometry)p)).isFalse();
    }

    @Test(groups={"unit"})
    public void should_accept_empty_shape() throws Exception {
        LineString s = LineString.fromWellKnownText((String)"LINESTRING EMPTY");
        Assertions.assertThat((boolean)s.getOgcGeometry().isEmpty()).isTrue();
    }

    private void assertInvalidWkt(String s) {
        try {
            LineString.fromWellKnownText((String)s);
            Fail.fail((String)"Should have thrown InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }
}

