/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.auth;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.auth.DsePlainTextAuthProvider;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@DseVersion(value="5.0")
@CCMConfig(createCluster={false}, config={"authorizer:com.datastax.bdp.cassandra.auth.DseAuthorizer", "authenticator:com.datastax.bdp.cassandra.auth.DseAuthenticator"}, dseConfig={"authentication_options.enabled:true", "authentication_options.default_scheme:internal"}, jvmArgs={"-Dcassandra.superuser_setup_delay_ms=0"})
public class DseAuthenticatorTransitionalModeTest
extends CCMDseTestsSupport {
    @CCMConfig(dseConfig={"authentication_options.transitional_mode:normal"})
    @Test(groups={"short"})
    public void should_allow_unauthorized_login_when_transitional_mode_on() throws Exception {
        this.tryConnect(this.clusterBuilder().build());
    }

    @CCMConfig(dseConfig={"authentication_options.transitional_mode:disabled"})
    @Test(groups={"short"})
    public void should_not_allow_unauthorized_login_when_transitional_mode_off() throws Exception {
        try {
            this.tryConnect(this.clusterBuilder().build());
            Assert.fail((String)"Expecting AuthenticationException");
        }
        catch (AuthenticationException e) {
            Assertions.assertThat((Throwable)e).hasMessageEndingWith("requires authentication, but no authenticator found in Cluster configuration");
        }
    }

    @CCMConfig(dseConfig={"authentication_options.transitional_mode:normal"})
    @Test(groups={"short"})
    public void should_allow_authorized_login_when_transitional_mode_on() throws Exception {
        DsePlainTextAuthProvider authProvider = new DsePlainTextAuthProvider("cassandra", "cassandra");
        DseCluster cluster = this.clusterBuilder().withAuthProvider((AuthProvider)authProvider).build();
        this.tryConnect(cluster);
    }

    private DseCluster.Builder clusterBuilder() {
        return DseCluster.builder().addContactPointsWithPorts(this.getContactPointsWithPorts());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryConnect(DseCluster cluster) {
        try {
            SimpleStatement statement = new SimpleStatement("select * from system.local");
            DseSession session = cluster.connect();
            Row row = session.execute((Statement)statement).one();
            Assertions.assertThat((Object)row).isNotNull();
        }
        finally {
            cluster.close();
        }
    }
}

