/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.DseCluster;
import java.util.Map;
import org.testng.annotations.Test;

@CCMConfig(dse={true}, dseConfig={"authentication_options.enabled:true", "authentication_options.default_scheme:internal", "authorization_options.enabled:true", "authorization_options.allow_row_level_security:true"})
@DseVersion(value="5.1.0")
public class RowLevelAccessTest
extends CCMDseTestsSupport {
    @Override
    public DseCluster.Builder createClusterBuilder() {
        return super.createClusterBuilder().withCredentials("cassandra", "cassandra");
    }

    @Test(groups={"short"})
    public void should_show_RLAC_for_table() throws Exception {
        this.session().execute(String.format("CREATE TABLE %s.reports (\n  report_user text,\n  report_number int,\n  report_month int,\n  report_year int,\n  report_text text,\n  PRIMARY KEY (report_user, report_number)\n);", this.keyspace));
        String rlacCql = String.format("RESTRICT ROWS ON %s.reports USING report_user;", this.keyspace);
        this.session().execute(rlacCql);
        TableMetadata table = this.cluster().getMetadata().getKeyspace(this.keyspace).getTable("reports");
        Assertions.assertThat((Map)table.getOptions().getExtensions()).containsKey((Object)"DSE_RLACA");
        Assertions.assertThat((String)table.exportAsString()).contains(new CharSequence[]{rlacCql});
    }

    @Test(groups={"short"}, enabled=false)
    public void should_show_RLAC_for_materialized_view() throws Exception {
        this.session().execute(String.format("CREATE TABLE %s.reports (\n  report_user text,\n  report_number int,\n  report_month int,\n  report_year int,\n  report_text text,\n  PRIMARY KEY (report_user, report_number)\n);", this.keyspace));
        this.session().execute(String.format("CREATE MATERIALIZED VIEW %s.reports_by_year AS SELECT report_year, report_user, report_number, report_text FROM %s.reports WHERE report_user IS NOT NULL AND report_number IS NOT NULL AND report_year IS NOT NULL PRIMARY KEY ((report_year, report_user), report_number)", this.keyspace, this.keyspace));
        String rlacCql = String.format("RESTRICT ROWS ON %s.reports_by_year USING report_user;", this.keyspace);
        this.session().execute(rlacCql);
        MaterializedViewMetadata mv = this.cluster().getMetadata().getKeyspace(this.keyspace).getMaterializedView("reports_by_year");
        Assertions.assertThat((Map)mv.getOptions().getExtensions()).containsKey((Object)"DSE_RLACA");
        Assertions.assertThat((String)mv.exportAsString()).contains(new CharSequence[]{rlacCql});
    }
}

