/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.schemabuilder.Alter;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.datastax.driver.core.schemabuilder.TableOptions;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class AlterTest {
    @Test(groups={"unit"})
    public void should_alter_column_type() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"test").alterColumn("name").type(DataType.ascii());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test ALTER name TYPE ascii");
    }

    @Test(groups={"unit"})
    public void should_alter_column_type_with_keyspace() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"ks", (String)"test").alterColumn("name").type(DataType.ascii());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE ks.test ALTER name TYPE ascii");
    }

    @Test(groups={"unit"})
    public void should_alter_column_type_to_UDT() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"ks", (String)"test").alterColumn("address").udtType(SchemaBuilder.frozen((String)"address"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE ks.test ALTER address TYPE frozen<address>");
    }

    @Test(groups={"unit"})
    public void should_add_column() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"test").addColumn("location").type(DataType.ascii());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test ADD location ascii");
    }

    @Test(groups={"unit"})
    public void should_add_column_with_UDT_type() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"test").addColumn("location").udtType(SchemaBuilder.frozen((String)"address"));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test ADD location frozen<address>");
    }

    @Test(groups={"unit"})
    public void should_rename_column() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"test").renameColumn("name").to("description");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test RENAME name TO description");
    }

    @Test(groups={"unit"})
    public void should_drop_column() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"test").dropColumn("name");
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test DROP name");
    }

    @Test(groups={"unit"})
    public void should_alter_table_options() throws Exception {
        TableOptions statement = ((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)((Alter.Options)SchemaBuilder.alterTable((String)"test").withOptions().bloomFilterFPChance(Double.valueOf(0.01))).caching(SchemaBuilder.Caching.ROWS_ONLY)).comment("This is a comment")).compactionOptions((TableOptions.CompactionOptions)SchemaBuilder.leveledStrategy().ssTableSizeInMB(Integer.valueOf(160)))).compressionOptions(SchemaBuilder.lz4())).dcLocalReadRepairChance(Double.valueOf(0.21))).defaultTimeToLive(Integer.valueOf(100))).gcGraceSeconds(Integer.valueOf(9999))).indexInterval(Integer.valueOf(256))).minIndexInterval(Integer.valueOf(64))).maxIndexInterval(Integer.valueOf(512))).memtableFlushPeriodInMillis(Integer.valueOf(12))).populateIOCacheOnFlush(Boolean.valueOf(true))).replicateOnWrite(Boolean.valueOf(true))).readRepairChance(Double.valueOf(0.42))).speculativeRetry(SchemaBuilder.always())).cdc(Boolean.valueOf(true));
        TableOptions statementWith21Caching = SchemaBuilder.alterTable((String)"test").withOptions().caching(SchemaBuilder.KeyCaching.NONE, SchemaBuilder.rows((int)100));
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test\n\tWITH caching = 'rows_only' AND bloom_filter_fp_chance = 0.01 AND comment = 'This is a comment' AND compression = {'sstable_compression' : 'LZ4Compressor'} AND compaction = {'class' : 'LeveledCompactionStrategy', 'sstable_size_in_mb' : 160} AND dclocal_read_repair_chance = 0.21 AND default_time_to_live = 100 AND gc_grace_seconds = 9999 AND index_interval = 256 AND min_index_interval = 64 AND max_index_interval = 512 AND memtable_flush_period_in_ms = 12 AND populate_io_cache_on_flush = true AND read_repair_chance = 0.42 AND replicate_on_write = true AND speculative_retry = 'ALWAYS' AND cdc = true");
        Assertions.assertThat((String)statementWith21Caching.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test\n\tWITH caching = {'keys' : 'none', 'rows_per_partition' : 100}");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The keyspace name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_keyspace_name_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.alterTable((String)"add", (String)"test").addColumn("test").type(DataType.ascii());
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The table name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_table_name_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.alterTable((String)"add").addColumn("test").type(DataType.ascii());
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The new column name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_added_column_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.alterTable((String)"test").addColumn("add").type(DataType.ascii()).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The altered column name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_altered_column_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.alterTable((String)"test").alterColumn("add").type(DataType.ascii()).getQueryString();
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The renamed column name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_renamed_column_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.alterTable((String)"test").renameColumn("add");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The new column name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_new_renamed_column_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.alterTable((String)"test").renameColumn("col").to("add");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class}, expectedExceptionsMessageRegExp="The dropped column name 'add' is not allowed because it is a reserved keyword")
    public void should_fail_if_drop_column_is_a_reserved_keyword() throws Exception {
        SchemaBuilder.alterTable((String)"test").dropColumn("add").getQueryString();
    }

    @Test(groups={"unit"})
    public void should_add_static_column() throws Exception {
        SchemaStatement statement = SchemaBuilder.alterTable((String)"test").addStaticColumn("stat").type(DataType.text());
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER TABLE test ADD stat text static");
    }
}

