/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.schemabuilder;

import com.datastax.driver.core.schemabuilder.KeyspaceOptions;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class AlterKeyspaceTest {
    @Test(groups={"unit"})
    public void should_alter_keyspace_with_options() throws Exception {
        HashMap<String, Object> replicationOptions = new HashMap<String, Object>();
        replicationOptions.put("class", "SimpleStrategy");
        replicationOptions.put("replication_factor", 1);
        KeyspaceOptions statement = SchemaBuilder.alterKeyspace((String)"test").with().durableWrites(Boolean.valueOf(true)).replication(replicationOptions);
        Assertions.assertThat((String)statement.getQueryString()).isEqualTo((Object)"\n\tALTER KEYSPACE test\n\tWITH\n\t\tREPLICATION = {'replication_factor': 1, 'class': 'SimpleStrategy'}\n\t\tAND DURABLE_WRITES = true");
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void incorrect_replication_options() throws Exception {
        HashMap<String, Integer> replicationOptions = new HashMap<String, Integer>();
        replicationOptions.put("class", 5);
        SchemaBuilder.alterKeyspace((String)"test").with().replication(replicationOptions);
    }
}

