/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.RetryPolicy;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class RetryDecisionTest {
    @Test(groups={"unit"})
    public void should_expose_decision_properties() throws Throwable {
        RetryPolicy.RetryDecision retryAtOne = RetryPolicy.RetryDecision.retry((ConsistencyLevel)ConsistencyLevel.ONE);
        Assertions.assertThat((Comparable)retryAtOne.getType()).isEqualTo((Object)RetryPolicy.RetryDecision.Type.RETRY);
        Assertions.assertThat((Comparable)retryAtOne.getRetryConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.ONE);
        Assertions.assertThat((boolean)retryAtOne.isRetryCurrent()).isTrue();
        Assertions.assertThat((String)retryAtOne.toString()).isEqualTo((Object)"Retry at ONE on same host.");
        RetryPolicy.RetryDecision tryNextAtOne = RetryPolicy.RetryDecision.tryNextHost((ConsistencyLevel)ConsistencyLevel.ONE);
        Assertions.assertThat((Comparable)tryNextAtOne.getType()).isEqualTo((Object)RetryPolicy.RetryDecision.Type.RETRY);
        Assertions.assertThat((Comparable)tryNextAtOne.getRetryConsistencyLevel()).isEqualTo((Object)ConsistencyLevel.ONE);
        Assertions.assertThat((boolean)tryNextAtOne.isRetryCurrent()).isFalse();
        Assertions.assertThat((String)tryNextAtOne.toString()).isEqualTo((Object)"Retry at ONE on next host.");
        RetryPolicy.RetryDecision rethrow = RetryPolicy.RetryDecision.rethrow();
        Assertions.assertThat((Comparable)rethrow.getType()).isEqualTo((Object)RetryPolicy.RetryDecision.Type.RETHROW);
        Assertions.assertThat((String)rethrow.toString()).isEqualTo((Object)"Rethrow");
        RetryPolicy.RetryDecision ignore = RetryPolicy.RetryDecision.ignore();
        Assertions.assertThat((Comparable)ignore.getType()).isEqualTo((Object)RetryPolicy.RetryDecision.Type.IGNORE);
        Assertions.assertThat((String)ignore.toString()).isEqualTo((Object)"Ignore");
    }
}

