/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.testng.annotations.Test;

@CassandraVersion(value="3.0")
public class UnresolvedUserTypeTest
extends CCMTestsSupport {
    private static final String KEYSPACE = "unresolved_user_type_test";
    private static final String EXPECTED_SCHEMA = String.format("CREATE KEYSPACE %s WITH REPLICATION = { 'class' : 'org.apache.cassandra.locator.SimpleStrategy', 'replication_factor': '1' } AND DURABLE_WRITES = true;\n\nCREATE TYPE %s.g (\n    f1 int\n);\n\nCREATE TYPE %s.h (\n    f1 int\n);\n\nCREATE TYPE %s.\"E\" (\n    f1 frozen<list<frozen<%s.g>>>\n);\n\nCREATE TYPE %s.\"F\" (\n    f1 frozen<%s.h>\n);\n\nCREATE TYPE %s.\"D\" (\n    f1 frozen<tuple<\"F\", g, h>>\n);\n\nCREATE TYPE %s.\"B\" (\n    f1 frozen<set<frozen<%s.\"D\">>>\n);\n\nCREATE TYPE %s.\"C\" (\n    f1 frozen<map<frozen<%s.\"E\">, frozen<%s.\"D\">>>\n);\n\nCREATE TYPE %s.\"A\" (\n    f1 frozen<%s.\"C\">\n);\n", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test", "unresolved_user_type_test");

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE KEYSPACE unresolved_user_type_test WITH replication = {'class': 'SimpleStrategy', 'replication_factor': '1'}", String.format("CREATE TYPE %s.h (f1 int)", KEYSPACE), String.format("CREATE TYPE %s.g (f1 int)", KEYSPACE), String.format("CREATE TYPE %s.\"F\" (f1 frozen<h>)", KEYSPACE), String.format("CREATE TYPE %s.\"E\" (f1 frozen<list<g>>)", KEYSPACE), String.format("CREATE TYPE %s.\"D\" (f1 frozen<tuple<\"F\",g,h>>)", KEYSPACE), String.format("CREATE TYPE %s.\"C\" (f1 frozen<map<\"E\",\"D\">>)", KEYSPACE), String.format("CREATE TYPE %s.\"B\" (f1 frozen<set<\"D\">>)", KEYSPACE), String.format("CREATE TYPE %s.\"A\" (f1 frozen<\"C\">)", KEYSPACE));
    }

    @Test(groups={"short"})
    public void should_resolve_nested_user_types() throws ExecutionException, InterruptedException {
        this.checkUserTypes(this.cluster().getMetadata());
        Cluster newCluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).build());
        this.checkUserTypes(newCluster.getMetadata());
    }

    private void checkUserTypes(Metadata metadata) {
        KeyspaceMetadata keyspaceMetadata = metadata.getKeyspace(KEYSPACE);
        UserType a = keyspaceMetadata.getUserType("\"A\"");
        UserType b = keyspaceMetadata.getUserType("\"B\"");
        UserType c = keyspaceMetadata.getUserType("\"C\"");
        UserType d = keyspaceMetadata.getUserType("\"D\"");
        UserType e = keyspaceMetadata.getUserType("\"E\"");
        UserType f = keyspaceMetadata.getUserType("\"F\"");
        UserType g = keyspaceMetadata.getUserType("g");
        UserType h = keyspaceMetadata.getUserType("h");
        Assertions.assertThat(a).hasField("f1", (DataType)c);
        Assertions.assertThat(b).hasField("f1", (DataType)DataType.set((DataType)d));
        Assertions.assertThat(c).hasField("f1", (DataType)DataType.map((DataType)e, (DataType)d));
        Assertions.assertThat(d).hasField("f1", (DataType)metadata.newTupleType(new DataType[]{f, g, h}));
        Assertions.assertThat(e).hasField("f1", (DataType)DataType.list((DataType)g));
        Assertions.assertThat(f).hasField("f1", (DataType)h);
        Assertions.assertThat(g).hasField("f1", DataType.cint());
        Assertions.assertThat(h).hasField("f1", DataType.cint());
        ArrayList userTypes = new ArrayList(keyspaceMetadata.getUserTypes());
        Assertions.assertThat(userTypes.subList(0, 2)).containsOnly((Object[])new UserType[]{g, h});
        Assertions.assertThat(userTypes.subList(2, 4)).containsOnly((Object[])new UserType[]{e, f});
        Assertions.assertThat(userTypes.subList(4, 5)).containsOnly((Object[])new UserType[]{d});
        Assertions.assertThat(userTypes.subList(5, 7)).containsOnly((Object[])new UserType[]{b, c});
        Assertions.assertThat(userTypes.subList(7, 8)).containsOnly((Object[])new UserType[]{a});
        String script = keyspaceMetadata.exportAsString();
        Assertions.assertThat((String)script).isEqualTo((Object)EXPECTED_SCHEMA);
    }
}

