/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.PrimitiveTypeSamples;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.base.Joiner;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class TupleTest
extends CCMTestsSupport {
    private ProtocolVersion protocolVersion;
    private Map<DataType, Object> samples;

    @Override
    public void onTestContextInitialized() {
        this.protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        this.samples = PrimitiveTypeSamples.samples(this.protocolVersion);
        this.execute("CREATE TABLE t (k int PRIMARY KEY, v frozen<tuple<int, text, float>>)");
    }

    @Test(groups={"short"})
    public void simpleValueTest() throws Exception {
        TupleType t = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint(), DataType.text(), DataType.cfloat()});
        TupleValue v = t.newValue();
        v.setInt(0, 1);
        v.setString(1, "a");
        v.setFloat(2, 1.0f);
        Assert.assertEquals((int)v.getType().getComponentTypes().size(), (int)3);
        Assert.assertEquals(v.getType().getComponentTypes().get(0), (Object)DataType.cint());
        Assert.assertEquals(v.getType().getComponentTypes().get(1), (Object)DataType.text());
        Assert.assertEquals(v.getType().getComponentTypes().get(2), (Object)DataType.cfloat());
        Assert.assertEquals((int)v.getInt(0), (int)1);
        Assert.assertEquals((String)v.getString(1), (String)"a");
        Assert.assertEquals((Object)Float.valueOf(v.getFloat(2)), (Object)Float.valueOf(1.0f));
        Assert.assertEquals((String)TypeCodec.tuple((TupleType)t).format((Object)v), (String)"(1,'a',1.0)");
    }

    @Test(groups={"short"})
    public void simpleWriteReadTest() throws Exception {
        this.session().execute("USE " + this.keyspace);
        PreparedStatement ins = this.session().prepare("INSERT INTO t(k, v) VALUES (?, ?)");
        PreparedStatement sel = this.session().prepare("SELECT * FROM t WHERE k=?");
        TupleType t = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint(), DataType.text(), DataType.cfloat()});
        int k = 1;
        TupleValue v = t.newValue(new Object[]{1, "a", Float.valueOf(1.0f)});
        this.session().execute((Statement)ins.bind(new Object[]{k, v}));
        TupleValue v2 = this.session().execute((Statement)sel.bind(new Object[]{k})).one().getTupleValue("v");
        Assert.assertEquals((Object)v2, (Object)v);
        k = 2;
        v = t.newValue(new Object[]{2, "b", Float.valueOf(2.0f)});
        this.session().execute("INSERT INTO t(k, v) VALUES (?, ?)", new Object[]{k, v});
        v2 = this.session().execute((Statement)sel.bind(new Object[]{k})).one().getTupleValue("v");
        Assert.assertEquals((Object)v2, (Object)v);
    }

    @Test(groups={"short"})
    public void tupleTypeTest() throws Exception {
        this.session().execute("CREATE KEYSPACE test_tuple_type WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
        this.session().execute("USE test_tuple_type");
        this.session().execute("CREATE TABLE mytable (a int PRIMARY KEY, b frozen<tuple<ascii, int, boolean>>)");
        TupleType t = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.ascii(), DataType.cint(), DataType.cboolean()});
        TupleValue complete = t.newValue(new Object[]{"foo", 123, true});
        this.session().execute("INSERT INTO mytable (a, b) VALUES (0, ?)", new Object[]{complete});
        TupleValue r = this.session().execute("SELECT b FROM mytable WHERE a=0").one().getTupleValue("b");
        Assert.assertEquals((Object)r, (Object)complete);
        try {
            t.newValue(new Object[]{"bar", 456});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TupleType t1 = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.ascii(), DataType.cint()});
        TupleValue partial = t1.newValue(new Object[]{"bar", 456});
        TupleValue partionResult = t.newValue(new Object[]{"bar", 456, null});
        this.session().execute("INSERT INTO mytable (a, b) VALUES (0, ?)", new Object[]{partial});
        r = this.session().execute("SELECT b FROM mytable WHERE a=0").one().getTupleValue("b");
        Assert.assertEquals((Object)r, (Object)partionResult);
        try {
            t.newValue(new Object[]{"zoo"});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TupleType t2 = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.ascii()});
        TupleValue subpartial = t2.newValue(new Object[]{"zoo"});
        TupleValue subpartialResult = t.newValue(new Object[]{"zoo", null, null});
        this.session().execute("INSERT INTO mytable (a, b) VALUES (0, ?)", new Object[]{subpartial});
        r = this.session().execute("SELECT b FROM mytable WHERE a=0").one().getTupleValue("b");
        Assert.assertEquals((Object)r, (Object)subpartialResult);
        PreparedStatement prepared = this.session().prepare("INSERT INTO mytable (a, b) VALUES (?, ?)");
        this.session().execute((Statement)prepared.bind(new Object[]{3, complete}));
        this.session().execute((Statement)prepared.bind(new Object[]{4, partial}));
        this.session().execute((Statement)prepared.bind(new Object[]{5, subpartial}));
        prepared = this.session().prepare("SELECT b FROM mytable WHERE a=?");
        Assert.assertEquals((Object)this.session().execute((Statement)prepared.bind(new Object[]{3})).one().getTupleValue("b"), (Object)complete);
        Assert.assertEquals((Object)this.session().execute((Statement)prepared.bind(new Object[]{4})).one().getTupleValue("b"), (Object)partionResult);
        Assert.assertEquals((Object)this.session().execute((Statement)prepared.bind(new Object[]{5})).one().getTupleValue("b"), (Object)subpartialResult);
    }

    @Test(groups={"short"})
    public void tupleTestTypeVaryingLengths() throws Exception {
        this.session().execute("CREATE KEYSPACE test_tuple_type_varying_lengths WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
        this.session().execute("USE test_tuple_type_varying_lengths");
        int[] lengths = new int[]{1, 2, 3, 384};
        ArrayList<String> valueSchema = new ArrayList<String>();
        for (int i : lengths) {
            ArrayList<String> ints = new ArrayList<String>();
            for (int j = 0; j < i; ++j) {
                ints.add("int");
            }
            valueSchema.add(String.format(" v_%d frozen<tuple<%s>>", i, Joiner.on((char)',').join(ints)));
        }
        this.session().execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, %s)", Joiner.on((char)',').join(valueSchema)));
        for (int i : lengths) {
            ArrayList<DataType> dataTypes = new ArrayList<DataType>();
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int j = 0; j < i; ++j) {
                dataTypes.add(DataType.cint());
                values.add(j);
            }
            TupleType t = new TupleType(dataTypes, this.protocolVersion, this.cluster().getConfiguration().getCodecRegistry());
            TupleValue createdTuple = t.newValue(values.toArray());
            this.session().execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple});
            TupleValue r = this.session().execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
            Assert.assertEquals((Object)r, (Object)createdTuple);
        }
    }

    @Test(groups={"short"})
    public void tupleSubtypesTest() throws Exception {
        ArrayList<DataType> DATA_TYPE_PRIMITIVES = new ArrayList<DataType>(this.samples.keySet());
        this.session().execute("CREATE KEYSPACE test_tuple_subtypes WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
        this.session().execute("USE test_tuple_subtypes");
        this.session().execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, v frozen<tuple<%s>>)", Joiner.on((char)',').join(DATA_TYPE_PRIMITIVES)));
        int i = 1;
        for (DataType ignored : DATA_TYPE_PRIMITIVES) {
            int j;
            ArrayList dataTypes = new ArrayList();
            ArrayList completeDataTypes = new ArrayList();
            ArrayList<Object> createdValues = new ArrayList<Object>();
            ArrayList<Object> completeValues = new ArrayList<Object>();
            for (j = 0; j < i; ++j) {
                dataTypes.add(DATA_TYPE_PRIMITIVES.get(j));
                completeDataTypes.add(DATA_TYPE_PRIMITIVES.get(j));
                createdValues.add(this.samples.get(DATA_TYPE_PRIMITIVES.get(j)));
                completeValues.add(this.samples.get(DATA_TYPE_PRIMITIVES.get(j)));
            }
            for (j = 0; j < DATA_TYPE_PRIMITIVES.size() - i; ++j) {
                completeDataTypes.add(DATA_TYPE_PRIMITIVES.get(i + j));
                completeValues.add(null);
            }
            TupleType t = new TupleType(dataTypes, this.protocolVersion, this.cluster().getConfiguration().getCodecRegistry());
            TupleType t2 = new TupleType(completeDataTypes, this.protocolVersion, this.cluster().getConfiguration().getCodecRegistry());
            TupleValue createdTuple = t.newValue(createdValues.toArray());
            TupleValue completeTuple = t2.newValue(completeValues.toArray());
            this.session().execute(String.format("INSERT INTO mytable (k, v) VALUES (%s, ?)", i), new Object[]{createdTuple});
            TupleValue r = this.session().execute("SELECT v FROM mytable WHERE k=?", new Object[]{i}).one().getTupleValue("v");
            Assert.assertEquals((Object)r, (Object)completeTuple);
            ++i;
        }
    }

    @Test(groups={"short"})
    public void tupleNonPrimitiveSubTypesTest() throws Exception {
        TupleValue r;
        TupleValue createdTuple;
        TupleType t;
        ArrayList<Object> createdValues;
        ArrayList<DataType.CollectionType> dataTypes;
        ArrayList<DataType> DATA_TYPE_PRIMITIVES = new ArrayList<DataType>(this.samples.keySet());
        this.session().execute("CREATE KEYSPACE test_tuple_non_primitive_subtypes WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
        this.session().execute("USE test_tuple_non_primitive_subtypes");
        ArrayList<String> values = new ArrayList<String>();
        for (DataType datatype : DATA_TYPE_PRIMITIVES) {
            values.add(String.format("v_%s frozen<tuple<list<%s>>>", values.size(), datatype));
        }
        for (DataType datatype : DATA_TYPE_PRIMITIVES) {
            if (datatype == DataType.duration()) continue;
            values.add(String.format("v_%s frozen<tuple<set<%s>>>", values.size(), datatype));
        }
        for (DataType datatype : DATA_TYPE_PRIMITIVES) {
            if (datatype == DataType.duration()) continue;
            values.add(String.format("v_%s frozen<tuple<map<%s, %s>>>", values.size(), datatype, datatype));
        }
        this.session().execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, %s)", Joiner.on((char)',').join(values)));
        int i = 0;
        for (DataType datatype : DATA_TYPE_PRIMITIVES) {
            dataTypes = new ArrayList<DataType.CollectionType>();
            createdValues = new ArrayList<Object>();
            dataTypes.add(DataType.list((DataType)datatype));
            createdValues.add(Collections.singletonList(this.samples.get(datatype)));
            t = new TupleType(dataTypes, this.protocolVersion, this.cluster().getConfiguration().getCodecRegistry());
            createdTuple = t.newValue(createdValues.toArray());
            this.session().execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple});
            r = this.session().execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
            Assert.assertEquals((Object)r, (Object)createdTuple);
            ++i;
        }
        for (DataType datatype : DATA_TYPE_PRIMITIVES) {
            if (datatype == DataType.duration()) continue;
            dataTypes = new ArrayList();
            createdValues = new ArrayList();
            dataTypes.add(DataType.set((DataType)datatype));
            createdValues.add(new HashSet<Object>(Collections.singletonList(this.samples.get(datatype))));
            t = new TupleType(dataTypes, this.protocolVersion, this.cluster().getConfiguration().getCodecRegistry());
            createdTuple = t.newValue(createdValues.toArray());
            this.session().execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple});
            r = this.session().execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
            Assert.assertEquals((Object)r, (Object)createdTuple);
            ++i;
        }
        for (DataType datatype : DATA_TYPE_PRIMITIVES) {
            if (datatype == DataType.duration()) continue;
            dataTypes = new ArrayList();
            createdValues = new ArrayList();
            HashMap<Object, Object> hm = new HashMap<Object, Object>();
            hm.put(this.samples.get(datatype), this.samples.get(datatype));
            dataTypes.add(DataType.map((DataType)datatype, (DataType)datatype));
            createdValues.add(hm);
            TupleType t2 = new TupleType(dataTypes, this.protocolVersion, this.cluster().getConfiguration().getCodecRegistry());
            TupleValue createdTuple2 = t2.newValue(createdValues.toArray());
            this.session().execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (0, ?)", i), new Object[]{createdTuple2});
            TupleValue r2 = this.session().execute(String.format("SELECT v_%s FROM mytable WHERE k=0", i)).one().getTupleValue(String.format("v_%s", i));
            Assert.assertEquals((Object)r2, (Object)createdTuple2);
            ++i;
        }
    }

    @Test(groups={"short"})
    public void detachedTupleTypeTest() {
        TupleType detachedType = TupleType.of((ProtocolVersion)this.protocolVersion, (CodecRegistry)CodecRegistry.DEFAULT_INSTANCE, (DataType[])new DataType[]{DataType.cint(), DataType.text(), DataType.cfloat()});
        TupleValue detachedValue = detachedType.newValue(new Object[]{1, "hello", Float.valueOf(2.0f)});
        TupleType attachedType = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint(), DataType.text(), DataType.cfloat()});
        TupleValue attachedValue = attachedType.newValue(new Object[]{1, "hello", Float.valueOf(2.0f)});
        Assertions.assertThat((Object)detachedValue).isEqualTo((Object)attachedValue);
    }

    private String nestedTuplesSchemaHelper(int depth) {
        if (depth == 0) {
            return "int";
        }
        return String.format("frozen<tuple<%s>>", this.nestedTuplesSchemaHelper(depth - 1));
    }

    private TupleValue nestedTuplesCreatorHelper(int depth) {
        if (depth == 1) {
            TupleType baseTuple = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint()});
            return baseTuple.newValue(new Object[]{303});
        }
        TupleValue innerTuple = this.nestedTuplesCreatorHelper(depth - 1);
        TupleType t = this.cluster().getMetadata().newTupleType(new DataType[]{innerTuple.getType()});
        return t.newValue(new Object[]{innerTuple});
    }

    @Test(groups={"short"})
    public void nestedTuplesTest() throws Exception {
        this.session().execute("CREATE KEYSPACE test_nested_tuples WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
        this.session().execute("USE test_nested_tuples");
        this.session().execute(String.format("CREATE TABLE mytable (k int PRIMARY KEY, v_1 %s, v_2 %s, v_3 %s, v_32 %s)", this.nestedTuplesSchemaHelper(1), this.nestedTuplesSchemaHelper(2), this.nestedTuplesSchemaHelper(3), this.nestedTuplesSchemaHelper(32)));
        for (int i : Arrays.asList(1, 2, 3, 32)) {
            TupleValue createdTuple = this.nestedTuplesCreatorHelper(i);
            this.session().execute(String.format("INSERT INTO mytable (k, v_%s) VALUES (?, ?)", i), new Object[]{i, createdTuple});
            TupleValue r = this.session().execute(String.format("SELECT v_%s FROM mytable WHERE k=?", i), new Object[]{i}).one().getTupleValue(String.format("v_%s", i));
            Assert.assertEquals((Object)r, (Object)createdTuple);
        }
    }

    @Test(groups={"short"})
    public void testTuplesWithNulls() throws Exception {
        this.session().execute("CREATE KEYSPACE testTuplesWithNulls WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor': '1'}");
        this.session().execute("USE testTuplesWithNulls");
        this.session().execute("CREATE TYPE user (a text, b frozen<tuple<text, int, uuid, blob>>)");
        this.session().execute("CREATE TABLE mytable (a int PRIMARY KEY, b frozen<user>)");
        UserType userTypeDef = this.cluster().getMetadata().getKeyspace("testTuplesWithNulls").getUserType("user");
        UDTValue userType = userTypeDef.newValue();
        TupleType t = this.cluster().getMetadata().newTupleType(new DataType[]{DataType.text(), DataType.cint(), DataType.uuid(), DataType.blob()});
        TupleValue v = t.newValue(new Object[]{null, null, null, null});
        userType.setTupleValue("b", v);
        PreparedStatement ins = this.session().prepare("INSERT INTO mytable (a, b) VALUES (?, ?)");
        this.session().execute((Statement)ins.bind(new Object[]{0, userType}));
        ResultSet rs = this.session().execute("SELECT * FROM mytable");
        List rows = rs.all();
        Assert.assertEquals((int)1, (int)rows.size());
        Row row = (Row)rows.get(0);
        Assert.assertEquals((int)row.getInt("a"), (int)0);
        Assert.assertEquals((Object)row.getUDTValue("b"), (Object)userType);
        v = t.newValue(new Object[]{"", null, null, ByteBuffer.allocate(0)});
        userType.setTupleValue("b", v);
        this.session().execute((Statement)ins.bind(new Object[]{0, userType}));
        rs = this.session().execute("SELECT * FROM mytable");
        rows = rs.all();
        Assert.assertEquals((int)1, (int)rows.size());
        row = (Row)rows.get(0);
        Assert.assertEquals((int)row.getInt("a"), (int)0);
        Assert.assertEquals((Object)row.getUDTValue("b"), (Object)userType);
    }
}

