/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.utils.Bytes;
import java.nio.ByteBuffer;
import java.util.Set;
import org.testng.annotations.Test;

@CCMConfig(config={"initial_token:1"}, clusterProvider="createClusterBuilderNoDebouncing")
public class SingleTokenIntegrationTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_return_single_non_empty_range_when_cluster_has_one_single_token() {
        this.cluster().manager.controlConnection.refreshNodeListAndTokenMap();
        Metadata metadata = this.cluster().getMetadata();
        Set tokenRanges = metadata.getTokenRanges();
        Assertions.assertThat((Iterable)tokenRanges).hasSize(1);
        TokenRange tokenRange = (TokenRange)tokenRanges.iterator().next();
        Assertions.assertThat(tokenRange).startsWith(Token.M3PToken.FACTORY.minToken()).endsWith(Token.M3PToken.FACTORY.minToken()).isNotEmpty().isNotWrappedAround();
        Set hostsForRange = metadata.getReplicas(this.keyspace, tokenRange);
        Host host1 = TestUtils.findHost(this.cluster(), 1);
        Assertions.assertThat((Iterable)hostsForRange).containsOnly((Object[])new Host[]{host1});
        ByteBuffer randomPartitionKey = Bytes.fromHexString((String)"0xCAFEBABE");
        Set hostsForKey = metadata.getReplicas(this.keyspace, randomPartitionKey);
        Assertions.assertThat((Iterable)hostsForKey).containsOnly((Object[])new Host[]{host1});
        Set rangesForHost = metadata.getTokenRanges(this.keyspace, host1);
        Assertions.assertThat((Iterable)rangesForHost).containsOnly((Object[])new TokenRange[]{tokenRange});
    }
}

