/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.utils.UUIDs;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.scassandra.Scassandra;
import org.scassandra.ScassandraFactory;
import org.scassandra.cql.CqlType;
import org.scassandra.cql.MapType;
import org.scassandra.cql.PrimitiveType;
import org.scassandra.cql.SetType;
import org.scassandra.http.client.PrimingClient;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.types.ColumnMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScassandraCluster {
    private static final Logger logger = LoggerFactory.getLogger(ScassandraCluster.class);
    private final String ipPrefix;
    private final int binaryPort;
    private final List<Scassandra> instances;
    private final Map<Integer, List<Scassandra>> dcNodeMap;
    private final List<Map<String, ?>> keyspaceRows;
    private final String cassandraVersion;
    private static final UUID schemaVersion = UUIDs.random();
    private final Map<Integer, Map<Integer, Map<String, Object>>> forcedPeerInfos;
    private final String keyspaceQuery;
    private final ColumnMetadata[] keyspaceColumnTypes;
    public static final ColumnMetadata[] SELECT_PEERS = new ColumnMetadata[]{ColumnMetadata.column((String)"peer", (CqlType)PrimitiveType.INET), ColumnMetadata.column((String)"rpc_address", (CqlType)PrimitiveType.INET), ColumnMetadata.column((String)"data_center", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"rack", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"release_version", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"tokens", (CqlType)SetType.set((CqlType)PrimitiveType.TEXT)), ColumnMetadata.column((String)"listen_address", (CqlType)PrimitiveType.INET), ColumnMetadata.column((String)"host_id", (CqlType)PrimitiveType.UUID), ColumnMetadata.column((String)"graph", (CqlType)PrimitiveType.BOOLEAN), ColumnMetadata.column((String)"schema_version", (CqlType)PrimitiveType.UUID), ColumnMetadata.column((String)"server_id", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"native_transport_port", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"native_transport_port_ssl", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"storage_port", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"storage_port_ssl", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"jmx_port", (CqlType)PrimitiveType.INT)};
    public static final ColumnMetadata[] SELECT_LOCAL = new ColumnMetadata[]{ColumnMetadata.column((String)"key", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"bootstrapped", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"broadcast_address", (CqlType)PrimitiveType.INET), ColumnMetadata.column((String)"cluster_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"cql_version", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"data_center", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"listen_address", (CqlType)PrimitiveType.INET), ColumnMetadata.column((String)"partitioner", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"rack", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"release_version", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"tokens", (CqlType)SetType.set((CqlType)PrimitiveType.TEXT)), ColumnMetadata.column((String)"graph", (CqlType)PrimitiveType.BOOLEAN), ColumnMetadata.column((String)"host_id", (CqlType)PrimitiveType.UUID), ColumnMetadata.column((String)"schema_version", (CqlType)PrimitiveType.UUID), ColumnMetadata.column((String)"server_id", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"native_transport_port", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"native_transport_port_ssl", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"storage_port", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"storage_port_ssl", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"jmx_port", (CqlType)PrimitiveType.INT)};
    static final ColumnMetadata[] SELECT_CLUSTER_NAME = new ColumnMetadata[]{ColumnMetadata.column((String)"cluster_name", (CqlType)PrimitiveType.TEXT)};
    static final ColumnMetadata[] SELECT_SCHEMA_KEYSPACES = new ColumnMetadata[]{ColumnMetadata.column((String)"durable_writes", (CqlType)PrimitiveType.BOOLEAN), ColumnMetadata.column((String)"keyspace_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"strategy_class", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"strategy_options", (CqlType)PrimitiveType.TEXT)};
    static final ColumnMetadata[] SELECT_SCHEMA_KEYSPACES_V3 = new ColumnMetadata[]{ColumnMetadata.column((String)"durable_writes", (CqlType)PrimitiveType.BOOLEAN), ColumnMetadata.column((String)"keyspace_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"replication", (CqlType)MapType.map((CqlType)PrimitiveType.TEXT, (CqlType)PrimitiveType.TEXT))};
    static final ColumnMetadata[] SELECT_SCHEMA_COLUMN_FAMILIES = new ColumnMetadata[]{ColumnMetadata.column((String)"bloom_filter_fp_chance", (CqlType)PrimitiveType.DOUBLE), ColumnMetadata.column((String)"caching", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"cf_id", (CqlType)PrimitiveType.UUID), ColumnMetadata.column((String)"column_aliases", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"columnfamily_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"comment", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"compaction_strategy_class", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"compaction_strategy_options", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"comparator", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"compression_parameters", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"default_time_to_live", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"default_validator", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"dropped_columns", (CqlType)MapType.map((CqlType)PrimitiveType.TEXT, (CqlType)PrimitiveType.BIG_INT)), ColumnMetadata.column((String)"gc_grace_seconds", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"index_interval", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"is_dense", (CqlType)PrimitiveType.BOOLEAN), ColumnMetadata.column((String)"key_aliases", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"key_validator", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"keyspace_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"local_read_repair_chance", (CqlType)PrimitiveType.DOUBLE), ColumnMetadata.column((String)"max_compaction_threshold", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"max_index_interval", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"memtable_flush_period_in_ms", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"min_compaction_threshold", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"min_index_interval", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"read_repair_chance", (CqlType)PrimitiveType.DOUBLE), ColumnMetadata.column((String)"speculative_retry", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"subcomparator", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"type", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"value_alias", (CqlType)PrimitiveType.TEXT)};
    static final ColumnMetadata[] SELECT_SCHEMA_COLUMNS = new ColumnMetadata[]{ColumnMetadata.column((String)"column_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"columnfamily_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"component_index", (CqlType)PrimitiveType.INT), ColumnMetadata.column((String)"index_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"index_options", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"index_type", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"keyspace_name", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"type", (CqlType)PrimitiveType.TEXT), ColumnMetadata.column((String)"validator", (CqlType)PrimitiveType.TEXT)};

    ScassandraCluster(Integer[] nodes, String ipPrefix, int binaryPort, int adminPort, List<Map<String, ?>> keyspaceRows, String cassandraVersion, Map<Integer, Map<Integer, Map<String, Object>>> forcedPeerInfos) {
        this.ipPrefix = ipPrefix;
        this.binaryPort = binaryPort;
        this.cassandraVersion = cassandraVersion != null ? cassandraVersion : "3.0.10";
        this.forcedPeerInfos = forcedPeerInfos;
        int node = 1;
        ImmutableList.Builder instanceListBuilder = ImmutableList.builder();
        ImmutableMap.Builder dcNodeMapBuilder = ImmutableMap.builder();
        for (int dc = 0; dc < nodes.length; ++dc) {
            ImmutableList.Builder dcNodeListBuilder = ImmutableList.builder();
            for (int n = 0; n < nodes[dc]; ++n) {
                String ip = ipPrefix + node++;
                Scassandra instance = ScassandraFactory.createServer((String)ip, (int)binaryPort, (String)ip, (int)adminPort);
                instanceListBuilder = instanceListBuilder.add((Object)instance);
                dcNodeListBuilder = dcNodeListBuilder.add((Object)instance);
            }
            dcNodeMapBuilder.put((Object)(dc + 1), (Object)dcNodeListBuilder.build());
        }
        this.instances = instanceListBuilder.build();
        this.dcNodeMap = dcNodeMapBuilder.build();
        String[] versionArray = this.cassandraVersion.split("\\.|-");
        double major = Double.parseDouble(versionArray[0] + "." + versionArray[1]);
        if (major < 3.0) {
            this.keyspaceQuery = "SELECT * FROM system.schema_keyspaces";
            this.keyspaceColumnTypes = SELECT_SCHEMA_KEYSPACES;
            this.keyspaceRows = Lists.newArrayList(keyspaceRows);
            for (Map<String, ?> keyspaceRow : this.keyspaceRows) {
                keyspaceRow.remove("replication");
            }
        } else {
            this.keyspaceQuery = "SELECT * FROM system_schema.keyspaces";
            this.keyspaceColumnTypes = SELECT_SCHEMA_KEYSPACES_V3;
            this.keyspaceRows = Lists.newArrayList(keyspaceRows);
            for (Map<String, ?> keyspaceRow : this.keyspaceRows) {
                keyspaceRow.remove("strategy_class");
                keyspaceRow.remove("strategy_options");
            }
        }
    }

    public Scassandra node(int node) {
        return this.instances.get(node - 1);
    }

    public List<Scassandra> nodes() {
        return this.instances;
    }

    public Scassandra node(int dc, int node) {
        return this.dcNodeMap.get(dc).get(node - 1);
    }

    public List<Scassandra> nodes(int dc) {
        return this.dcNodeMap.get(dc);
    }

    public int ipSuffix(int dc, int node) {
        int nodeCount = 0;
        for (Integer dcNum : new TreeSet<Integer>(this.dcNodeMap.keySet())) {
            List<Scassandra> nodesInDc = this.dcNodeMap.get(dc);
            for (int n = 0; n < nodesInDc.size(); ++n) {
                ++nodeCount;
                if (dcNum != dc || n + 1 != node) continue;
                return nodeCount;
            }
        }
        return -1;
    }

    public int getBinaryPort() {
        return this.binaryPort;
    }

    public InetSocketAddress address(int node) {
        return new InetSocketAddress(this.ipPrefix + node, this.binaryPort);
    }

    public InetSocketAddress address(int dc, int node) {
        int ipSuffix = this.ipSuffix(dc, node);
        if (ipSuffix == -1) {
            return null;
        }
        return new InetSocketAddress(this.ipPrefix + ipSuffix, this.binaryPort);
    }

    public Host host(Cluster cluster, int dc, int node) {
        InetAddress address = this.address(dc, node).getAddress();
        for (Host host : cluster.getMetadata().getAllHosts()) {
            if (!host.getAddress().equals(address)) continue;
            return host;
        }
        return null;
    }

    public static String datacenter(int dc) {
        return "DC" + dc;
    }

    public void init() {
        for (Map.Entry<Integer, List<Scassandra>> dc : this.dcNodeMap.entrySet()) {
            for (Scassandra node : dc.getValue()) {
                node.start();
                this.primeMetadata(node);
            }
        }
    }

    public void stop() {
        logger.debug("Stopping ScassandraCluster.");
        for (Scassandra node : this.instances) {
            node.stop();
        }
    }

    public void stopDC(Cluster cluster, int dc) {
        logger.debug("Stopping all nodes in {}.", (Object)ScassandraCluster.datacenter(dc));
        int controlHost = -1;
        for (int i = 1; i <= this.nodes(dc).size(); ++i) {
            int id = this.ipSuffix(dc, i);
            Host host = TestUtils.findHost(cluster, id);
            if (cluster.manager.controlConnection.connectedHost() == host) {
                logger.debug("Node {} identified as control host.  Stopping last.", (Object)id);
                controlHost = id;
                continue;
            }
            this.stop(cluster, id);
        }
        if (controlHost != -1) {
            this.stop(cluster, controlHost);
        }
    }

    public void stop(Cluster cluster, int node) {
        logger.debug("Stopping node {}.", (Object)node);
        Scassandra scassandra = this.node(node);
        scassandra.stop();
        Assertions.assertThat(cluster).host(node).goesDownWithin(10L, TimeUnit.SECONDS);
    }

    public void stop(Cluster cluster, int dc, int node) {
        logger.debug("Stopping node {} in {}.", (Object)node, (Object)ScassandraCluster.datacenter(dc));
        this.stop(cluster, this.ipSuffix(dc, node));
    }

    public void startDC(Cluster cluster, int dc) {
        logger.debug("Starting all nodes in {}.", (Object)ScassandraCluster.datacenter(dc));
        for (int i = 1; i <= this.nodes(dc).size(); ++i) {
            int id = this.ipSuffix(dc, i);
            this.start(cluster, id);
        }
    }

    public void start(Cluster cluster, int node) {
        logger.debug("Starting node {}.", (Object)node);
        Scassandra scassandra = this.node(node);
        scassandra.start();
        Assertions.assertThat(cluster).host(node).comesUpWithin(10L, TimeUnit.SECONDS);
    }

    public void start(Cluster cluster, int dc, int node) {
        logger.debug("Starting node {} in {}.", (Object)node, (Object)ScassandraCluster.datacenter(dc));
        this.start(cluster, this.ipSuffix(dc, node));
    }

    public List<Long> getTokensForDC(int dc) {
        int offset = (dc - 1) * 100;
        int dcNodeCount = this.nodes(dc).size();
        ArrayList tokens = Lists.newArrayListWithExpectedSize((int)dcNodeCount);
        for (int i = 0; i < dcNodeCount; ++i) {
            tokens.add((long)i * ((long)Math.pow(2.0, 64.0) / (long)dcNodeCount) + (long)offset);
        }
        return tokens;
    }

    private void primeMetadata(Scassandra node) {
        PrimingClient client = node.primingClient();
        int nodeCount = 0;
        ImmutableList.Builder rows = ImmutableList.builder();
        HashSet localMetadata = Sets.newHashSet((Object[])SELECT_LOCAL);
        HashSet peersMetadata = Sets.newHashSet((Object[])SELECT_PEERS);
        for (Integer dc : new TreeSet<Integer>(this.dcNodeMap.keySet())) {
            List<Scassandra> nodesInDc = this.dcNodeMap.get(dc);
            List<Long> tokens = this.getTokensForDC(dc);
            for (int n = 0; n < nodesInDc.size(); ++n) {
                LinkedHashMap row;
                String address = this.ipPrefix + ++nodeCount;
                Scassandra peer = nodesInDc.get(n);
                if (node == peer) {
                    row = Maps.newLinkedHashMap();
                    this.addPeerInfo(row, dc, n + 1, "key", "local");
                    this.addPeerInfo(row, dc, n + 1, "bootstrapped", "COMPLETED");
                    this.addPeerInfo(row, dc, n + 1, "broadcast_address", address);
                    this.addPeerInfo(row, dc, n + 1, "cluster_name", "scassandra");
                    this.addPeerInfo(row, dc, n + 1, "cql_version", "3.2.0");
                    this.addPeerInfo(row, dc, n + 1, "data_center", ScassandraCluster.datacenter(dc));
                    this.addPeerInfo(row, dc, n + 1, "listen_address", this.getPeerInfo(dc, n + 1, "listen_address", address));
                    this.addPeerInfo(row, dc, n + 1, "partitioner", "org.apache.cassandra.dht.Murmur3Partitioner");
                    this.addPeerInfo(row, dc, n + 1, "rack", this.getPeerInfo(dc, n + 1, "rack", "rack1"));
                    this.addPeerInfo(row, dc, n + 1, "release_version", this.getPeerInfo(dc, n + 1, "release_version", this.cassandraVersion));
                    this.addPeerInfo(row, dc, n + 1, "tokens", ImmutableSet.of((Object)tokens.get(n)));
                    this.addPeerInfo(row, dc, n + 1, "host_id", UUIDs.random());
                    this.addPeerInfo(row, dc, n + 1, "schema_version", schemaVersion);
                    this.addPeerInfo(row, dc, n + 1, "graph", false);
                    this.addPeerInfo(row, dc, n + 1, "server_id", "00:00:00:00:00:00");
                    this.addPeerInfo(row, dc, n + 1, "native_transport_port", 9042);
                    this.addPeerInfo(row, dc, n + 1, "native_transport_port_ssl", 9142);
                    this.addPeerInfo(row, dc, n + 1, "storage_port", 7000);
                    this.addPeerInfo(row, dc, n + 1, "storage_port_ssl", 7100);
                    this.addPeerInfo(row, dc, n + 1, "jmx_port", 7199);
                    if (this.addPeerInfoIfExists(row, dc, n + 1, "dse_version")) {
                        localMetadata.add(ColumnMetadata.column((String)"dse_version", (CqlType)PrimitiveType.TEXT));
                    }
                    if (this.addPeerInfoIfExists(row, dc, n + 1, "workload")) {
                        localMetadata.add(ColumnMetadata.column((String)"workload", (CqlType)PrimitiveType.TEXT));
                    }
                    if (this.addPeerInfoIfExists(row, dc, n + 1, "workloads")) {
                        localMetadata.add(ColumnMetadata.column((String)"workloads", (CqlType)SetType.set((CqlType)PrimitiveType.TEXT)));
                    }
                    client.prime(PrimingRequest.queryBuilder().withQuery("SELECT * FROM system.local WHERE key='local'").withThen(PrimingRequest.then().withColumnTypes(localMetadata.toArray(new ColumnMetadata[localMetadata.size()])).withRows(Collections.singletonList(row)).build()).build());
                    continue;
                }
                row = Maps.newLinkedHashMap();
                this.addPeerInfo(row, dc, n + 1, "peer", address);
                this.addPeerInfo(row, dc, n + 1, "rpc_address", address);
                this.addPeerInfo(row, dc, n + 1, "data_center", ScassandraCluster.datacenter(dc));
                this.addPeerInfo(row, dc, n + 1, "rack", this.getPeerInfo(dc, n + 1, "rack", "rack1"));
                this.addPeerInfo(row, dc, n + 1, "release_version", this.getPeerInfo(dc, n + 1, "release_version", this.cassandraVersion));
                this.addPeerInfo(row, dc, n + 1, "tokens", ImmutableSet.of((Object)Long.toString(tokens.get(n))));
                this.addPeerInfo(row, dc, n + 1, "host_id", UUIDs.random());
                this.addPeerInfo(row, dc, n + 1, "schema_version", schemaVersion);
                this.addPeerInfo(row, dc, n + 1, "graph", false);
                this.addPeerInfo(row, dc, n + 1, "server_id", "00:00:00:00:00:00");
                this.addPeerInfo(row, dc, n + 1, "native_transport_port", 9042);
                this.addPeerInfo(row, dc, n + 1, "native_transport_port_ssl", 9142);
                this.addPeerInfo(row, dc, n + 1, "storage_port", 7000);
                this.addPeerInfo(row, dc, n + 1, "storage_port_ssl", 7100);
                this.addPeerInfo(row, dc, n + 1, "jmx_port", 7199);
                if (this.addPeerInfoIfExists(row, dc, n + 1, "listen_address")) {
                    peersMetadata.add(ColumnMetadata.column((String)"listen_address", (CqlType)PrimitiveType.INET));
                }
                if (this.addPeerInfoIfExists(row, dc, n + 1, "dse_version")) {
                    peersMetadata.add(ColumnMetadata.column((String)"dse_version", (CqlType)PrimitiveType.TEXT));
                }
                if (this.addPeerInfoIfExists(row, dc, n + 1, "workload")) {
                    peersMetadata.add(ColumnMetadata.column((String)"workload", (CqlType)PrimitiveType.TEXT));
                }
                if (this.addPeerInfoIfExists(row, dc, n + 1, "workloads")) {
                    peersMetadata.add(ColumnMetadata.column((String)"workloads", (CqlType)SetType.set((CqlType)PrimitiveType.TEXT)));
                }
                rows.add((Object)row);
                client.prime(PrimingRequest.queryBuilder().withQuery("SELECT * FROM system.peers WHERE peer='" + address + "'").withThen(PrimingRequest.then().withColumnTypes(peersMetadata.toArray(new ColumnMetadata[peersMetadata.size()])).withRows(Collections.singletonList(row)).build()).build());
            }
        }
        client.prime(PrimingRequest.queryBuilder().withQuery("SELECT * FROM system.peers").withThen(PrimingRequest.then().withColumnTypes(peersMetadata.toArray(new ColumnMetadata[peersMetadata.size()])).withRows((List)rows.build()).build()).build());
        ImmutableMap clusterNameRow = ImmutableMap.builder().put((Object)"cluster_name", (Object)"scassandra").build();
        client.prime(PrimingRequest.queryBuilder().withQuery("select cluster_name from system.local").withThen(PrimingRequest.then().withColumnTypes(SELECT_CLUSTER_NAME).withRows(Collections.singletonList(clusterNameRow)).build()).build());
        client.prime(PrimingRequest.queryBuilder().withQuery(this.keyspaceQuery).withThen(PrimingRequest.then().withColumnTypes(this.keyspaceColumnTypes).withRows(this.keyspaceRows).build()).build());
    }

    private void addPeerInfo(Map<String, Object> input, int dc, int node, String property, Object defaultValue) {
        Object peerInfo = this.getPeerInfo(dc, node, property, defaultValue);
        if (peerInfo != null) {
            input.put(property, peerInfo);
        }
    }

    private boolean addPeerInfoIfExists(Map<String, Object> input, int dc, int node, String property) {
        Map<Integer, Map<String, Object>> forDc = this.forcedPeerInfos.get(dc);
        if (forDc == null) {
            return false;
        }
        Map<String, Object> forNode = forDc.get(node);
        if (forNode == null) {
            return false;
        }
        if (forNode.containsKey(property)) {
            input.put(property, forNode.get(property));
            return true;
        }
        return false;
    }

    private Object getPeerInfo(int dc, int node, String property, Object defaultValue) {
        Map<Integer, Map<String, Object>> forDc = this.forcedPeerInfos.get(dc);
        if (forDc == null) {
            return defaultValue;
        }
        Map<String, Object> forNode = forDc.get(node);
        if (forNode == null) {
            return defaultValue;
        }
        return forNode.containsKey(property) ? forNode.get(property) : defaultValue;
    }

    public static ScassandraClusterBuilder builder() {
        return new ScassandraClusterBuilder();
    }

    public static class ScassandraClusterBuilder {
        private Integer[] nodes = new Integer[]{1};
        private String ipPrefix = TestUtils.IP_PREFIX;
        private final List<Map<String, ?>> keyspaceRows = Lists.newArrayList();
        private final Map<Integer, Map<Integer, Map<String, Object>>> forcedPeerInfos = Maps.newHashMap();
        private String cassandraVersion = null;

        public ScassandraClusterBuilder withNodes(Integer ... nodes) {
            this.nodes = nodes;
            return this;
        }

        public ScassandraClusterBuilder withIpPrefix(String ipPrefix) {
            this.ipPrefix = ipPrefix;
            return this;
        }

        public ScassandraClusterBuilder withSimpleKeyspace(String name, int replicationFactor) {
            HashMap simpleKeyspaceRow = Maps.newHashMap();
            simpleKeyspaceRow.put("durable_writes", false);
            simpleKeyspaceRow.put("keyspace_name", name);
            simpleKeyspaceRow.put("replication", ImmutableMap.builder().put((Object)"class", (Object)"org.apache.cassandra.locator.SimpleStrategy").put((Object)"replication_factor", (Object)("" + replicationFactor)).build());
            simpleKeyspaceRow.put("strategy_class", "SimpleStrategy");
            simpleKeyspaceRow.put("strategy_options", "{\"replication_factor\":\"" + replicationFactor + "\"}");
            this.keyspaceRows.add(simpleKeyspaceRow);
            return this;
        }

        public ScassandraClusterBuilder withNetworkTopologyKeyspace(String name, Map<Integer, Integer> replicationFactors) {
            StringBuilder strategyOptionsBuilder = new StringBuilder("{");
            ImmutableMap.Builder replicationBuilder = ImmutableMap.builder();
            replicationBuilder.put((Object)"class", (Object)"org.apache.cassandra.locator.NetworkTopologyStrategy");
            for (Map.Entry<Integer, Integer> dc : replicationFactors.entrySet()) {
                strategyOptionsBuilder.append("\"");
                strategyOptionsBuilder.append(ScassandraCluster.datacenter(dc.getKey()));
                strategyOptionsBuilder.append("\":\"");
                strategyOptionsBuilder.append(dc.getValue());
                strategyOptionsBuilder.append("\",");
                replicationBuilder.put((Object)ScassandraCluster.datacenter(dc.getKey()), (Object)("" + dc.getValue()));
            }
            String strategyOptions = strategyOptionsBuilder.substring(0, strategyOptionsBuilder.length() - 1) + "}";
            HashMap ntsKeyspaceRow = Maps.newHashMap();
            ntsKeyspaceRow.put("durable_writes", false);
            ntsKeyspaceRow.put("keyspace_name", name);
            ntsKeyspaceRow.put("strategy_class", "NetworkTopologyStrategy");
            ntsKeyspaceRow.put("strategy_options", strategyOptions);
            ntsKeyspaceRow.put("replication", replicationBuilder.build());
            this.keyspaceRows.add(ntsKeyspaceRow);
            return this;
        }

        public ScassandraClusterBuilder forcePeerInfo(int dc, int node, String name, Object value) {
            Map forNode;
            HashMap forDc = this.forcedPeerInfos.get(dc);
            if (forDc == null) {
                forDc = Maps.newHashMap();
                this.forcedPeerInfos.put(dc, forDc);
            }
            if ((forNode = (Map)forDc.get(node)) == null) {
                forNode = Maps.newHashMap();
                forDc.put(node, forNode);
            }
            forNode.put(name, value);
            return this;
        }

        public ScassandraClusterBuilder withCassandraVersion(String version) {
            this.cassandraVersion = version;
            return this;
        }

        public ScassandraCluster build() {
            return new ScassandraCluster(this.nodes, this.ipPrefix, TestUtils.findAvailablePort(), TestUtils.findAvailablePort(), this.keyspaceRows, this.cassandraVersion, this.forcedPeerInfos);
        }
    }
}

