/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.SortingLoadBalancingPolicy;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.utils.CassandraVersion;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

@CCMConfig(numberOfNodes={2}, dirtiesContext={true})
@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
public class PreparedStatementMultiNodeTest
extends CCMTestsSupport {
    private static final String keyspace2 = TestUtils.generateIdentifier("ks_");
    private static final String keyspace3Internal = TestUtils.generateIdentifier("KS_");
    private static final String keyspace3 = Metadata.quoteIfNecessary((String)keyspace3Internal);

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace2, 2), String.format("CREATE TABLE %s.users(id int, id2 int, name text, primary key (id, id2))", keyspace2), String.format("INSERT INTO %s.users(id, id2, name) VALUES (2, 2, 'test2')", keyspace2), String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", keyspace3, 2), String.format("CREATE TABLE %s.users(id int, id2 int, name text, primary key (id, id2))", keyspace3), String.format("INSERT INTO %s.users(id, id2, name) VALUES (3, 3, 'test3')", keyspace3));
    }

    @Test(groups={"long"})
    @CassandraVersion(value="4.0.0")
    public void should_execute_statement_with_per_query_keyspace_on_restarted_node() {
        this.executeAfterNodeBroughtBackUp(true, true);
        this.executeAfterNodeBroughtBackUp(false, true);
    }

    @Test(groups={"long"})
    public void should_execute_statement_with_session_keyspace_on_restarted_node() {
        this.executeAfterNodeBroughtBackUp(true, false);
        this.executeAfterNodeBroughtBackUp(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAfterNodeBroughtBackUp(boolean reprepareOnUp, boolean setKeyspace) {
        QueryOptions queryOptions = new QueryOptions().setReprepareOnUp(reprepareOnUp).setPrepareOnAllHosts(false);
        Cluster.Builder builder = this.createClusterBuilderNoDebouncing().withNettyOptions(TestUtils.nonQuietClusterCloseOptions).addContactPointsWithPorts(this.getContactPointsWithPorts()).withPort(this.ccm().getBinaryPort()).withQueryOptions(queryOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new SortingLoadBalancingPolicy());
        Cluster cluster = builder.build();
        try {
            PreparedStatement prep3;
            PreparedStatement prep2;
            Session session = cluster.connect();
            if (setKeyspace) {
                prep2 = session.prepare((RegularStatement)new SimpleStatement("SELECT * from users").setKeyspace(keyspace2));
                prep3 = session.prepare((RegularStatement)new SimpleStatement("SELECT * from users").setKeyspace(keyspace3Internal));
            } else {
                session.execute("USE " + keyspace2);
                prep2 = session.prepare((RegularStatement)new SimpleStatement("SELECT * from users"));
                session.execute("USE " + keyspace3);
                prep3 = session.prepare((RegularStatement)new SimpleStatement("SELECT * from users"));
            }
            Host host1 = TestUtils.findHost(cluster, 1);
            Host host2 = TestUtils.findHost(cluster, 2);
            if (!setKeyspace) {
                session.execute("USE " + keyspace2);
            }
            ResultSet result = session.execute((Statement)prep2.bind());
            Assertions.assertThat((Object)result.getExecutionInfo().getQueriedHost()).isEqualTo((Object)host1);
            Assertions.assertThat((String)result.one().getString("name")).isEqualTo((Object)"test2");
            if (!setKeyspace) {
                session.execute("USE " + keyspace3);
            }
            result = session.execute((Statement)prep3.bind());
            Assertions.assertThat((Object)result.getExecutionInfo().getQueriedHost()).isEqualTo((Object)host1);
            Assertions.assertThat((String)result.one().getString("name")).isEqualTo((Object)"test3");
            this.ccm().stop(1);
            TestUtils.waitForDown(TestUtils.ipOfNode(1), cluster);
            if (!setKeyspace) {
                session.execute("USE " + keyspace2);
            }
            result = session.execute((Statement)prep2.bind());
            Assertions.assertThat((Object)result.getExecutionInfo().getQueriedHost()).isEqualTo((Object)host2);
            Assertions.assertThat((String)result.one().getString("name")).isEqualTo((Object)"test2");
            if (!setKeyspace) {
                session.execute("USE " + keyspace3);
            }
            result = session.execute((Statement)prep3.bind());
            Assertions.assertThat((Object)result.getExecutionInfo().getQueriedHost()).isEqualTo((Object)host2);
            Assertions.assertThat((String)result.one().getString("name")).isEqualTo((Object)"test3");
            this.ccm().start(1);
            TestUtils.waitForUp(TestUtils.ipOfNode(1), cluster);
            if (!setKeyspace) {
                session.execute("USE " + keyspace2);
            }
            result = session.execute((Statement)prep2.bind());
            Assertions.assertThat((Object)result.getExecutionInfo().getQueriedHost()).isEqualTo((Object)host1);
            Assertions.assertThat((String)result.one().getString("name")).isEqualTo((Object)"test2");
            if (!setKeyspace) {
                session.execute("USE " + keyspace3);
            }
            result = session.execute((Statement)prep3.bind());
            Assertions.assertThat((Object)result.getExecutionInfo().getQueriedHost()).isEqualTo((Object)host1);
            Assertions.assertThat((String)result.one().getString("name")).isEqualTo((Object)"test3");
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"long"})
    public void should_fail_on_unprepared_if_keyspace_is_different() {
        QueryOptions queryOptions = new QueryOptions().setReprepareOnUp(false).setPrepareOnAllHosts(false);
        Cluster.Builder builder = this.createClusterBuilderNoDebouncing().withNettyOptions(TestUtils.nonQuietClusterCloseOptions).addContactPointsWithPorts(this.getContactPointsWithPorts()).withPort(this.ccm().getBinaryPort()).withQueryOptions(queryOptions).withLoadBalancingPolicy((LoadBalancingPolicy)new SortingLoadBalancingPolicy());
        if (this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"4.0.0")) >= 0) {
            builder = builder.withProtocolVersion(ProtocolVersion.V4);
        }
        Cluster cluster = builder.build();
        try {
            Session session = cluster.connect();
            session.execute("USE " + keyspace2);
            PreparedStatement prep = session.prepare((RegularStatement)new SimpleStatement("SELECT * from users"));
            Host host1 = TestUtils.findHost(cluster, 1);
            ResultSet result = session.execute((Statement)prep.bind());
            Assertions.assertThat((Object)result.getExecutionInfo().getQueriedHost()).isEqualTo((Object)host1);
            Assertions.assertThat((String)result.one().getString("name")).isEqualTo((Object)"test2");
            session.execute("USE " + keyspace3);
            this.ccm().stop(1);
            TestUtils.waitForDown(TestUtils.ipOfNode(1), cluster);
            try {
                session.execute((Statement)prep.bind());
                Assert.fail((String)"Expected DriverInternalError");
            }
            catch (DriverInternalError die) {
                Assertions.assertThat((Throwable)die.getCause()).isInstanceOf(IllegalStateException.class);
            }
        }
        finally {
            cluster.close();
        }
    }
}

